/*
*************************************************************************************
* Note: This file contains Russian translation of the oXs_config_description.h as supplied with oXs dated 12th of March, 2015.
* While it was attempted to keep the translation as close to the original document as it is possible, there
* may still be some mistypes, unclarity and other issues. Please report these to andy@rcgear.ru
*
* Данный документ является переводом файла oXs_config_description.h. Он актуален для oXs от 12.03.2015г.
* Несмотря на все старания, перевод может содержать некоторые ошибки и неточности (как, впрочем, и исходный документ).
* Вы можете отправить Ваши комментарии и предложения на почту: andy@rcgear.ru
*
*************************************************************************************
*
*                                  Важное замечание:
*  Не удаляйте и не редактируйте этот файл (если Вы не добавляете какие-либо комментарии).
*  Данный файл содержит лишь описание и инструкцию по настройке. 
*  Сами настройки задаются в файле oXs_config.h 
*************************************************************************************

Страница проекта: https://github.com/openXsensor/
Rainer Schlosshan, основатель проекта.

************************************************************************************************************************
************************************* Общее описание доступных опций ***************************************************
************************************************************************************************************************
*  Файл oXs_config.h содержит настройки и параметры oXs, необходимые для его работы. Ниже приведено краткое содержание:
*
*  1 - Общие настройки протокола и установка FrSky sensor_ID
*  2 - Настройка порта, отвечающего за передачу данных
*  3 - Настройки PWM (в оригинале называется PPM) (опционально)
*  4 - Настройки вариометра (опционально)
*   4.1 - Подключение 1 или 2 датчиков давления MS5611
*   4.2 - Предустановленная чувствительность вариометра
*   4.3 - Чувствительность вариометра, задаваемая посредством аппаратуры (TX)
*   4.4 - Гистерезис и компенсация показаний высотомера
*   4.5 - Вычисление вертикальных скоростей (опционально)
*   4.6 - "Аналоговая" вертикальная скорость (опционально)
*  5 - Настройка датчика воздушной скорости (опционально)
*  6 - Измерение напряжений и настройки датчика тока (опционально)
*   6.1 - Выбор опорного напряжения (Vcc или 1.1В внутреннее напряжение)
*   6.2 - Аналоговые порты измерения напряжения
*   6.3 - Параметры калибровки измерения напряжения
*   6.4 - Количество "банок" LiPo-батареи
*   6.5 - Аналоговый порт датчика тока
*   6.6 - Параметры калибровки датчика тока
*  7 - Датчик оборотов (RPM) (опционально)
*  8 - Настройки "постоянной" памяти (опционально)
*  9 - Передаваемые данные - в этом разделе содержится список кодов передаваемых данных и инструкция по их применению
*  10 - Sequencer (ON/OFF) для цифровых выходов (например, в качестве контроллера освещения)
*  11 - Зарезервировано для разработчиков
*
* Примечание: активные параметры обычно начинаются со слова "#define", за которым указано название параметра и, в большинстве случаев, его значение.
*       Чтобы отключить какой-либо параметр, Вы можете добавить "//" (в начале строки перед "#define"), в этом случае эта строка будет считаться комментарием и не будет влиять на работу oXs.
************************************************************************************************************************


**** 1 - Общие настройки протокола и установка FrSky sensor_ID **********************************************************************
* В настоящее время oXs поддерживает два протокола телеметрии : Multiplex и FrSky
* Только один из протоколов может быть активен, т.е. если Вы выбрали Multiplex, то протокол FrSky будет заблокирован (и наоборот) 
* 1.1 Multiplex protocol
*       Чтобы активировать протокол, уберите комментарий ("//") в строке //#define MULTIPLEX
* 1.2 FrSky protocol и настройка Device ID (необходимо для использования с SPORT)
*     Протокол FrSky может работать в двух режимах (протоколах):
*       - SPORT (Smart Port) - используется с телеметрийными приемниками серии X (такими как X8R или X6R)
*       - HUB - используется с телеметрийными приемниками серии D (такими как D4R-II)
*     oXs поддерживает оба протокола, причем (опционально) может автоматически определять тип приемника, к которому он подключен.
*     При использовании этой опции нет необходимости задавать протокол и перепрограммировать oXs при подключении к разным типам приемников FrSky.
*     В случае, если автоматическое определение типа приемника работает нестабильно, Вы можете принудительно задать используемый протокол, убрав комментарий с одной из следующих строк:
*     Чтобы принудительно задать протокол SPORT (для приемников серии X), уберите комментарий в строке #define FRSKY_TYPE_SPORT
*     Чтобы принудительно задать протокол HUB (для приемников серии D), уберите комментарий в строке #define FRSKY_TYPE_HUB
*       Примечание: В случае, если активны обе строки, приоритет будет отдан протоколу SPORT.
*     Имейте в виду, что некоторые параметры телеметрии существуют только для режима SPORT (детали приведены в разделе 8).
*
*     Для режима HUB допускается подключение только одного oXs к приемнику (другие датчики не должны быть подключены). 
*     Режим SPORT позволяет подключать несколько датчиков одновременно (например, датчик GPS). Однако, каждый датчик должен иметь 
*     свой уникальный идентификатор SENSOR_ID.
*     Поэтому Вы должны задать SENSOR_ID для oXs, отличный от идентификатора других подключенных датчиков.
*     SENSOR_ID задается строкой : #define SENSOR_ID    0x1B 
*     Допустимые значения: 0x1B, 0xBA, ... (всего 28 значений)     
*     Ниже приведен список sensor_IDs, используемых FrSky в их собственных датчиках (Физический идентификатор + контрольная сумма / Physical IDs + CRC). Использование этих идентификаторов в oXs не рекомендуется:
*       #define DATA_ID_VARIO  0x00  0
*       #define DATA_ID_FLVSS  0xA1  1
*       #define DATA_ID_FAS    0x22  2
*       #define DATA_ID_GPS    0x83  3
*       #define DATA_ID_RPM    0xE4  4
*       #define DATA_ID_SP2UH  0x45  5
*       #define DATA_ID_SP2UR  0xC6  6
************************************************************************************************************************
//#define MULTIPLEX
#define SENSOR_ID    0x1B   


**** 2 - Настройка порта, отвечающего за передачу данных **************************************************************
*   Для передачи телеметрийных данных oXs должен быть подключен к приемнику. Для этого один из ЦИФРОВЫХ портов Arduino должен быть подключен
*   к телеметрийному порту приемника: "Rx" для приемников серии D или S.Port для приемников серии X.
*   Вы должны задать номер используемого порта на Arduino.
*   Значение по умолчанию: 4 ; допустимы значения от 0 до 7, однако убедитесь в том, что этот порт не занят другими функциями
************************************************************************************************************************
#define PIN_SERIALTX  4

**** 3 - Настройки PWM (PPM) **************************************************************************************************
*   Комментарий: здесь и далее по тексту в английской версии инструкции вместо 'PWM' используется термин 'PPM'. Это связано с неточностью 
*   терминологии, заложенной еще на раннем этапе разработки oXs. В данном переводе восстановлена "справедливость", и в описаниях 
*   используется правильный термин PWM. Однако, названия параметров все равно включают в себя термин PPM. 
*   Возможно, эта неточность будет исправлена вдальнейшем.
*
*   oXs может (опционально) получать PWM сигнал, приходящий от приемника.
*   Это позволяет непосредственно с помощью апаратуры управления делать следующее :
*      - изменять чувствительность вариометра
*      - переключаться из режима нескомпенсированного в режим компенсированного вариометра (при использовании двух датчиков давления, 
*        один из которых подключен к т.н. TEK probe - датчику компенсации полной энергии)
*      - "перезапускать" датчик воздушной скорости (когда погрешность показаний датчика увеличивается с изменением температуры)
*      - изменять фактор компенсации вариометра (когда компенсированный вариометр использует воздушную скорость)
*      - управлять функцией Sequencer (см. п.10)
*   Это требует настройки одного или нескольких миксов на аппаратуре управления, 
*   а также соответствующих настроек в файле oXs-config.h (см. ниже).
*
*   Если Вы хотите использовать эту функцию, вы должны:
*      - убрать знаки комментариев в 3 строках, относящихся к настройке PWM
*      - задать с помощью параметра PIN_PPM цифровой порт Arduino, к которому будет подключен канал приемника
*            (oXs будет подключен к приемнику как, например, обычный сервопривод).
*            Значение по умолчанию: 2 ; Вы также можете использовать порт 3 для приема PWM-сигнала.
*            Внимание: только порты 2 или 3 могут быть использованы для приема PWM-сигнала от приемника.
*      - задать параметром PPM_MIN_100 длительность импульса (в микросекундах), соответствующую "логическому" уровню -100.
*            Значение по-умолчанию: 988
*      - задать параметром PPM_PLUS_100 длительность импульса (в микросекундах), соответствующую "логическому" уровню +100.
*            Значение по-умолчанию: 2012
*   Два последних параметра служат для калибровки oXs в соответствии с принимаемым от приемника сигналом.
*   С большой долей вероятности, значения по-умолчанию будут работать корректно.
*   Однако, Вы можете уточнить параметры калибровки для Вашего приемника самостоятельно.
*   Чтобы это сделать, необходимо, чтобы oXs передавал значение поля "PPM" на Вашу аппаратуру (например, как T1). Подробности приведены ниже.
*   Запишите значения, отображаемые на аппаратуре (например, в поле T1) когда значение канала установлено в -100 и +100 соответственно.
*   Затем используйте эти значения при указании параметров PPM_MIN_100 и PPM_PLUS_100 и перепрошейте Arduino.
************************************************************************************************************************
#define PIN_PPM             2 
#define PPM_MIN_100       988   
#define PPM_PLUS_100      2012   

**** 4 - Настройки вариометра ******************************************************************************************
*
* 4.1 - В качесве опции, возможно подключение к oXs одного или двух датчиков давления на базе MS5611: ******************
*     Вы можете подключить 1 или 2 датчика давления; каждый датчик должен быть основан на MS5611. Примером такого датчика является модуль GY63
*     Каждый датчик может вычислять абсолютную/относительную высоту (в метрах, с точностью до 0.1м) и вертикальную скорость (в м/сек, с точностью до 0.01м/c).
*     Второй датчик может быть полезен с случае, когда он используется совместно с системой компенсации полной энергии. В этом случае, при внешнем управлении с помощью PWM, Вы можете выбирать датчик, информация с которого будет поступать на аппаратуру управления.
*     Это позволяет выбирать между воздушно-компенсированным и нескомпенсированнм датчиками вариометра.
*     Рассмотреть возможность использования двух датчиков давления также имеет смысл, если Вы хотите уменьшить время реакции вариометра при малой погрешности.
*        Примечание: для уменьшения времени реакции, чувствительность должна быть увеличена (например, до 80 вместо 40 в параметре SENSITIVITY_MIN)
*     Когда используются два датчика давления, oXs может передавать в качестве вертикальной скорости среднее значение от обоих датчиков (см. параметр VERTICALSPEED_A в разделе 9) 
*     Уберите комментарий в строке "#define VARIO" чтобы включить первый MS5611.
*     Уберите комментарий в строке "#define VARIO2" чтобы включить второй MS5611.
*     Оба датчика MS5611 подключаются параллельно (используя порты A4 и A5 Arduino).
*     Первым MS5611 будет работать тот, у которого контакт CE (chip enable) заземлен. Это является штатным режимом работы, например, для модуля GY63. Он будет передавать информацию по I2C шине по адресу 0x77.
*     У второго MS5611 контакт CE (chip enable) должен быть подключен к VDD. При этом он получит адрес 0x76 на шине I2C.
*     Примечание: При использовании только одного MS5611, он должен быть включен как первый MS5611 (с контактом CE подключенным к земле).
*
*     При использовании функционала вариометра, oXs может учитывать несколько параметров, позволяющих скорректиовать чувствительность и гистерезис.
*     Чувствительность может быть задана в следующих пределах:
*         - 20 (консервативный режим, время реакции = несколько секунд)                     
*         - 150 (быстрый режим, но с большой погрешностью, время реакции = гораздо меньше секунды)       
*        Значение 40 является нормальным при измерении небольших вертикальных скоростей (поиск восходящих потоков на планере); время реакции в этом режиме будет около 1 секунды.
*     Чувствительность датчика может быть предустановлена в настройках, и/или изменяться с помощью аппаратуры управления.
************************************************************************************************************************
#define VARIO  //закомментируйте эту строчку, если не используете датчик давления
#define VARIO2  //закомментируйте эту строчку, если не используете второй датчик давления

* 4.2 - Предустановленная чувствительность вариометра: *****************************************************************************
*     Данная конфигурация включает в себя 4 параметра:
*        SENSIVITY_MIN = Это чувствительность, которая используется в нормальных условиях (большую часть времени).
*                        Таким образом это основной параметр, который задает чувствительность вариометра.
*                        Это значение используется oXs когда разница между текущей расчетной скоростью Vspeed (расчитываемой каждые 20 мс) и предыдущей усредненной скоростью VSpeed  МЕНЬШЕ, чем значение SENSITIVITY_MIN_AT ; обычно устанавливается равным 40.
*        SENSIVITY_MAX = Это максимальная чувствительность, используемая, когда Vspeed изменяется очень быстро.
*                        Это значение используется oXs когда разница между текущей расчетной скоростью Vspeed и предыдущей усредненной скоростью VSpeed  БОЛЬШЕ, чем значение SENSITIVITY_MAX_AT ; обычно устанавливается равным 300.
*        SENSITIVITY_MIN_AT = определяет до какого значения будет применяться SENSITIVITY_MIN (см. выше) (cm/s); обычно устанавливается равным 100 (cm/s).
*        SENSITIVITY_MAX_AT = определяет, начиная с какого значения будет применяться SENSITIVITY_MAX (см. выше) (cm/s); обычно устанавливается равным 1000 (cm/s).
*           Чувствительность автоматически интерполируется между SENSITIVITY_MIN и SENSITIVITY_MAX.
*     Эти параметры позволяют oXs обеспечить быструю реакцию, когда Vspeed изменяется очень быстро, и в то же время иметь небольшую погрешность в нормальной ситуации.
*     Примечание: SENSITIVITY_MAX может быть задана равной SENSITIVITY_MIN в случае, если не требуется автоматической подстройки при быстрых изменениях скорости.
************************************************************************************************************************
#define SENSITIVITY_MIN 50
#define SENSITIVITY_MAX 300
#define SENSITIVITY_MIN_AT 100
#define SENSITIVITY_MAX_AT 1000

* 4.3 - Чувствительность вариометра, задаваемая посредством аппаратуры (TX) ********************************************
*     Чувствительность может быть задана с аппаратуры управления посредством переключателя и/или потенциометра, при наличии соответствующего микса.
*     Чтобы эта функция работала, нужно, чтобы соответствующий канал приемника был подключен к oXs (см. Настройки PWM в разделе 3).
*     Когда oXs обнаруживает сигнал от аппаратуры управления, параметр SENSIVITY_MIN, заданный в соответствии с разделом 4.2, игнорируется и заменяется значением, расчитанным на основании параметров п. 4.3 в записимости от поступающего сигнала.
*     Примечание: эта функция не работает при использовании функции Sequencer'а.
*
*     Данная конфигурация включает в себя 4 параметра:
*         SENSITIVITY_MIN_AT_PPM  = Когда аппаратура передает это значение, значение параметра SENSITIVITY_MIN (см. п. 4.2) будет заменено параметром SENSITIVITY_PPM_MIN;  обычно устанавливается равным 10.
*         SENSITIVITY_MAX_AT_PPM  = Когда аппаратура передает это значение, значение параметра SENSITIVITY_MIN (см. п. 4.2) будет заменено параметром SENSITIVITY_PPM_MAX;  обычно устанавливается равным 40.
*              Параметры SENSIVITY_PPM_MIN+MAX определяют диапазон, в котором Вы сможете изменять чувствительность:
*         SENSITIVITY_PPM_MIN     =  минимальное значение параметра SENSITIVITY_MIN, которое может быть задано посредством PWM; обычно устанавливается равным 20.
*         SENSITIVITY_PPM_MAX     =  масимальное значение SENSITIVITY_MIN, коорое может быть задано посредством PWM; обычно устанавливается равным 100.
*             SENSITIVITY_MIN автоматически интерполируется между SENSITIVITY_PPM_MIN и SENSITIVITY_PPM_MAX в зависимости от PWM-сигнала.
*     Чувствительность будет меняться только тогда, когда поступающий PWM-сигнал находится в диапазоне между SENSITIVITY_MIN_AT_PPM - 5 и  SENSITIVITY_MAX_AT_PPM + 5.
*     Важное замечание: : Чувствительность изменяется на основании модуля значения PWM-сигнала (без учета его знака); таким образом PWM = -25 будет иметь то же влияние, что и PWM = 25.
*     Это важно в случае, если необходимо совместить подстройку чувствительности и переключение между двумя датчиками давления (компенсированный и нескомпенсированный режимы вариометра), см. далее.
************************************************************************************************************************
#define SENSITIVITY_MIN_AT_PPM 10
#define SENSITIVITY_MAX_AT_PPM 40
#define SENSITIVITY_PPM_MIN  20
#define SENSITIVITY_PPM_MAX 100

* 4.4 - Гистерезис и компенсация показаний высотомера ******************************************************************
*     oXs также может применять гистерезис при вычислении вертикальной скорости.
*     Это позволяет избежать ложных изменений передаваемых показаний Vspeed (что может вызывать ложные предупреждения на аппаратуре).
*     В целом, это является еще одним способом снизить его чувствительность.
*     Передаваемое значение Vspeed будет изменяться только в случае, если текущее измеренное значение VSpeed (после фильтрования) отлично от последнего переданного значения более, чем на значение, указанное в параметре VARIOHYSTERESIS.
*     Обычно устанавливается равным 5  (= 5 cm/s); установка параметра = 0 отключает функцию гистерезиса.
*
*    Кроме этого, oXs позволяет задать дополнительную компенсацию показаний датчика MS5611, чтобы снизить дрифт показаний высоты, связанный  с увеличением температуры датчика во время работы.
*    Было установлено, что внутренняя температура датчика MS5611 увеличивается на несколько градусов во время его работы.
*    В принципе, MS5611 уже содержит параметры калибровки, которые должны компенсировать эти изменения.
*    Однако, эти параметры не всегда оптимальны.
*    Пожтому oXs позволяет задать дополнительную компенсацию. Для этого Вы должны использовать параметр ALT_TEMP_COMPENSATION.
*    Чтобы определить оптимальное значение для Вашего датчика Вам, вероятно, придется попробовать несколько значений.
*    Следующая информация может быть полезна:
*        - Лучше всего проводить тесты при стабильном атмосферном давлении (хороший, спокойный день, без ветра)
*        - Убедитесь, что Ваша аппаратура отображает телеметрийное значение высоты.
*        - Убедитесь, что свет не попадает на датчик MS5611 (в противном случае его показания будут неверны)
*        - Начните с ALT_TEMP_COMPENSATION равной 0 (или закомментируйте этот параметр), включите аппаратуру и приемник. Не двигайте oXs (при этом, ви идеале, высота, отображаемая на аппаратуре, должна оставаться равной 0).
*        - Приблизительно через 5 минут проверьте, насколько изменились показания высоты.
*        - Выключите аппаратуру и приемник, и дайте время датчику oXs остыть.
*        - Повторите тест еще 1 или 2 раза.
*        - Если дрифт высоты каждый раз примерно одинаков и превышает 1 метр, Вы, вероятно, сможете уменьшить его, задав параметр ALT_TEMP_COMPENSATION
*        - Если дрифт положительный, Вам следует увеличить значение ALT_TEMP_COMPENSATION, в противном случае - уменьшить. Значение ALT_TEMP_COMPENSATION может быть отрицательным.
*        - Вычисление правильного значения компенсации - сложная задача. На датчике автора ПО значение = 1000 компенсирует дрифт около 3 метров. Однако, это также зависит от конкретного экземпляра датчика.
*        - Задав какое-то значение ALT_TEMP_COMPENSATION, повторите предыдущие эксперименты (включите приемник и передатчик, подождите 5 минут, посмотрите на величину дрифта) и откорректируйте значение ALT_TEMP_COMPENSATION, если нужно.
*    Важное замечание: использование поля ALT_TEMP_COMPENSATION не уберет дрифт полностью, т.к.:
*         - дрифт может быть вызван незначительными изменениями атмосферного давления (что не может быть скомпенсировано)
*         - на дрифт могут влиять другие факторы
*         - температурная компенсация, вероятно, не будет иметь линейный характер во всем диапазоне температур и возможных давлений
************************************************************************************************************************
#define VARIOHYSTERESIS 5
//#define ALT_TEMP_COMPENSATION 0
*
* 4.5 - Вычисление вертикальных скоростей *****************************************************************************
*     При использовании двух датчиков MS5611, или одного MS5611 и одного 4525D0 (см. раздел 5), oXs может вычислять несколько вертикальных скоростей (или т.н. dTE).
*     Когда используется опция PWM, oXs позволяет с помошью аппаратуры выбрать значение (Vspeed от первого или второго датчика давления, или скомпенсированного воздушной скоростью), которое будет передаваться телеметрией в качестве вертикальной скорости. Примечание: функция PWM не работает при использовании функции Sequencer'а.
*     Несмотря на то, что oXs может вычислять до 4 вертикальных скоростей (VERTICAL_SPEED, VERTICAL_SPEED_2, PRANDTL_DTE, VERTICAL_SPEED_A), в настоящее время поддерживается переключение только между двумя из них.
*     Чтоб включить эту функцию, необходимо задать следующие параметры:
*       1) Указать какое значение будет считаться первым, а какое - вторым, при помощи следующих строк:
*                  #define VARIO_PRIMARY       2  
*                  #define VARIO_SECONDARY     1
*                 При этом 0 означает первый ms5611, 1 означает второй ms5611 , 2 означает Prandtl Dte (т.е. показания вариометра, основанные на vario 1 + компенсация от датчика воздушной скорости на трубке Прандтля), 3 означает усредненное значение показаний первого и второго ms5611.
*       2) Указать диапазон значений сигнала PWM, при которых oXs посылает данные с первого или со второго датчика:
*                 #define SWITCH_VARIO_MIN_AT_PPM 10 
*                 #define SWITCH_VARIO_MAX_AT_PPM 90 
*             Когда модуль текущего значения PWM находится между SWITCH_VARIO_MIN_AT_PPM (обычно = 10) и SWITCH_VARIO_MAX_AT_PPM (обычно = 90):
*              - oXs будет передавать данные первого заданного датчика, если значения PWM ПОЛОЖИТЕЛЬНЫ
*              - oXs будет передавать данные второго заданного датчика, если значения PWM ОТРИЦАТЕЛЬНЫ
*     Примечание: когда модуль PWM сигнала выходит за пределы установленного диапазона, oXs продолжит передавать данные с последнего выбранного датчика.
*         Этот принцип позволяет использовать переключатель на аппаратуре совместно с потенциометром для контроля чувствительности или компенсации.
*         Переключение между позитивным и негативным значением может быть задано в OpenTX при использовании микса с параметром MULTIPLY by -100%.
*         Передача PWM сигнала вне данного диапазона позволяет передавать другие команды oXs (например, сброс расчета смещения воздушной скорости).
****************************************************************************************************************************
#define VARIO_PRIMARY       2  // 0 = первый ms5611, 1 = второй ms5611 , 2 = Prandtl Dte , 3 = усредненное показание первого и второго ms5611
#define VARIO_SECONDARY     1  // 0 = первый ms5611, 1 = второй ms5611 , 2 = Prandtl Dte , 3 = усредненное показание первого и второго ms5611
#define SWITCH_VARIO_MIN_AT_PPM 10
#define SWITCH_VARIO_MAX_AT_PPM 90

* 4.6 - "Аналоговая" вертикальная скорость *******************************************************************************
*     oXs может также передавать вертикальную скорость (только от первого датчика) в качестве аналогового сигнала, который может быть подключен, например, к порту A1 или A2 приемника FrSky.
*     Это может быть полезно при использовании приемника, не оборудованного цифровым входом, или если этот вход используется другими датчиками.
*     Для этой функции требуется дополнительное оборудование (1 резистор + 1 конденсатор)!!! Более подробная информация представлена в Wiki.
*     Чтобы включить эту функцию:
*     - уберите комментарии с 3 следующих параметров
*     - задайте PIN_ANALOG_VSPEED, который указывает на цифровой порт Arduino (см. ниже)
*         Значение по-умолчанию: 3; Допустимые значения - только 3 или 11, т.к. эти порты используют "Timer 2".
*     - задайте min и max пределы вертикальной скорости (в м/сек)
*        - Значения ниже или равные ANALOG_VSPEED_MIN будут соответствовать напряжению 0В
*        - Значения выше или равные ANALOG_VSPEED_MAX будут соответствовать напряжению 3.2В
*************************************************************************************************************************
#define PIN_ANALOG_VSPEED   3
#define ANALOG_VSPEED_MIN -3
#define ANALOG_VSPEED_MAX  3

************************************************************************************************************************
* Примечание: в случае, если функционал вариометра не используется, отключать строки, относящиеся к настройкам чувствительности, 
*        гистерезиса и др. не обязательно, т.к. эта часть конфигурации будет проигнорирована.
*        Настройки вариометра (чувствительность, гистерезис, PWM, ...) будут применены к обоим MS5611, если они используются.
************************************************************************************************************************


**** 5 - Настройка датчика воздушной скорости ***************************************************************************
* oXs может измерять разницу между статическим и динамическим давлением, измеренным при помощи трубки Прандтля.
* Для этого потребуется специальный датчик 4525DO-DS5AI001DP. В этом случае oXs должен работать от Vcc = 5 Вольт 
* и позволит измерять воздушную скорость до 360 км/ч. Есть другие модификации датчика 4525DO, которые работают при Vcc = 3.3 В, или 
* допускающие измерение большего давления и, таким образом, бОльшую скорость.
* Датчик 4525DO подключается к Arduino параллельно датчику MS5611 (использует порты A4 и A5, и также подключения к Vcc и "Земле").
* Рекомендуется также добавить развязывающий конденсатор (100nf) как можно ближе к 4524DO, между Vcc и "Землей".
* Примечание: на низких скоростях разница давлений настолько мала, что измерения скорости имеют большую погрешность.  
*       Поэтому oXs приравнивает значение скорости нулю на скоростях менее 10 км/ч.
* Уберите комментарий в строке "#define AIRSPEED" чтобы включить измерение скорости.
*
* Датчик давления 4525DO требует калибровки, чтобы показания скорости в режиме покоя равнялись 0.
* oXs проводит калибровку автоматически при включении питания (в предположении, что сорость в момент включения = 0).
* Чтобы калибровка была точной, важно, чтобы в трубку Прандтля не задувал ветер в момент калибровки.
* В любом случае при изменении температуры возможен некоторый дрифт показаний.
* oXs позволяет провести перекалибровку датчика с аппаратуры управления в случае, если используется PWM (см. п. 3). 
* Примечание: функция PWM не работает при использовании функции Sequencer'а. 
* Параметром AIRSPEED_RESET_AT_PPM задается значение канала, передаваемое аппаратурой управления, при получении которого выполнится калибровка.
* Значение по-умолчанию: 100.
* Самым простым способом будет настройка микса на аппаратуре управления, который будет генерировать импульс с заданным значением (например, 100) длительностью, например, 1сек.
* Учитывайте, что перекалибровка должна выполняться при фактической воздушной скорости = 0, иначе показания датчика будут неверны.
*
* oXs может также использовать измеренную воздушную скорость для подсчета показаний компенсированного вариометра PRANDTL_DTE (=изменение общей энергии).
* Дополнительную информацию по поводу  dTE (= electronically compensated vario) можно найти в Сети.
* Принцип заключается в том, чтобы вычислить воздушную скорость, при этом отсекая погрешность, вызванную изменением высоты (подъем или спуск).
* Как правило, dTE должен передаваться в качестве Vspeed (vertical speed = defaultfield), т.к. в прошивке OpenTX пока нет отдельного поля для dTE.
*
* В случае использования опции PWM, Вы также можете изменять фактор компенсации, выбирая одно из двух значений (данная функция не работает при использовании функции Sequencer'а).
* Это требует установки 4 параметров:
*     COMPENSATION_MIN_AT_PPM  укажите значение PWM-сигнала, которое будет устанавливать компенсацию COMPENSATION_PPM_MIN; по-умолчанию = 60.
*     COMPENSATION_MAX_AT_PPM  укажите значение PWM-сигнала, которое будет устанавливать компенсацию COMPENSATION_PPM_MAX; по-умолчанию = 90.
*     COMPENSATION_PPM_MIN     минимальная компенсация, % ; по-умолчанию: 80 
*     COMPENSATION_PPM_MAX     максимальная компенсация, % ; по-умолчанию: 120
************************************************************************************************************************
#define AIRSPEED  MS4525

#define AIRSPEED_RESET_AT_PPM   100

#define COMPENSATION_MIN_AT_PPM 60
#define COMPENSATION_MAX_AT_PPM 90
#define COMPENSATION_PPM_MIN  80
#define COMPENSATION_PPM_MAX 120


**** 6 - Измерение напряжений и настройки датчика тока *****************************************************************
*
* 6.1 - Выбор опорного напряжения (Vcc или 1.1В внутреннее напряжение) *********************************************
*     oXs позволяет измерять напряжение (а также ток, при использовании соответствующего датчика), сравнивая текущее значение с опорным (используя 1023 шага АЦП в Arduino). В качестве опорного напряжения может выступать Vcc (обычно 5В), или внутреннее опорное напряжение 1.1В.
*     Если напряжение Vcc стабильно, то, вероятно, проще и точнее будет использовать именно его (таким образом получим 1023 шага относительно Vcc).
*     Это требует, чтобы питание, подаваемое на порт "RAW" Arduino, было достаточно стабильным и всегда было выше 5.5В (чтобы внутренний стабилизатор питания Arduino выдавал стабильные 5В).
*     Если питание, подаваемое на порт RAW, менее 5.5 В и при этом меняется (например, при работе сервоприводов, или по мере разряда батареи), то измерение напряжений будет иметь значительную погрешность.
*     В случае, если напряжение Vcc нестабильно (например, когда Arduino питается через приемник от 4.8В NiMh батареи), а Вам нужно измерять только напряжение (нет необходимости мерять ток), возможно использование внутреннего опорного напряжения 1.1В.
*     Это решение не подойдет для измерения тока, т.к. датчик тока также требует для себя стабильного питания.
*     Напряжение, поступающее на аналоговые порты Arduino, не должно превышать Vcc или 1.1В (в зависимости от того, какой вариант Вы выбрали). Для этого нужно использовать делители напряжения, речь о которых пойдет ниже.
*     Чтобы включить использование внутреннего опорного напржения 1.1В, уберите комментарий в строке "#define USE_INTERNAL_REFERENCE". Иначе, измерения будут проводиться относительно Vcc.
************************************************************************************************************************
//#define USE_INTERNAL_REFERENCE

* 6.2 - Аналоговые порты измерения напряжения ******************************************************************************
*     Аналоговые порты (с A0 по A7) могут быть использованы, чтобы измерять до 6 напряжений (однако имейте в виду, что некоторые платы Arduino могут иметь меньшее число портов - это зависит от производителя).
*     Напряжение может поступать от батареи (например, от "многобаночной" LiPo), или от какого-либо датчика (например, дачик температуры может изменять напряжение в зависимости от температуры). 
*     Также, один аналоговый порт может быть использован для измерения тока с помощью соответствующего датчика. 
*     Настройка датчика тока описана в разделе 6.5 (см. ниже). Не используйте один порт для измерения показаний напряжения и тока одновременно.
*     Внимание: НЕ ИСПОЛЬЗУЙТЕ для измерения напряжений порты A4 и A5, если Вы используете функционал вариометра или датчика воздушной скорости, т.к. эти порты зарезервированы для соответствующих датчиков.
*     Номера портов (PIN), которые задаются в файле oXs_config.h, могут принимать значения от 0 до 7 (0 означает A0 = analog 0, 1 означает A1, ...7 означает A7).
*  !! Учтите, что напряжение, поступающее на порты Arduino, не должно превышать Vcc (обычно 5 В) или 1.1 В (если используется внутреннее опорное напряжение).
*     Таким образом, Вам, вероятно, придется использовать делитель, чтобы привести измеряемое напряжение в допустимые рамки.
*     Работа с делителями напряжения описана ниже.
*     Примечание: все напряжения измеряютcя относительно "Земли". Таким образом, для "многобаночной" LiPo максимальное напряжение первой банки составит 4.2В, второй банки - 8.4В, третьей банки - 12.6В и т.д. 
*   
*     В случае, когда измерение напряжений не нужно, одна, несколько, или все линии ниже могут быть закомментированы или удалены из файла конфигурации.
*  Примечание: одно и то же значение порта (PIN) может быть использовано для нескольких переменных PIN_VOLTAGE (в этом случае напряжение, постуающее на этот порт, будет посчитано для каждого варианта PIN_VOLTAGE )                                            
************************************************************************************************************************
#define PIN_VOLTAGE_1 0      // Порт для измерения Напряжения 1 ( Аналоговый порт! )
#define PIN_VOLTAGE_2 1      // Порт для измерения Напряжения 2 ( Аналоговый порт! )
#define PIN_VOLTAGE_3 2      // Порт для измерения Напряжения 3 ( Аналоговый порт! )
#define PIN_VOLTAGE_4 3      // Порт для измерения Напряжения 4 ( Аналоговый порт! )
#define PIN_VOLTAGE_5 6      // Порт для измерения Напряжения 5 ( Аналоговый порт! )
#define PIN_VOLTAGE_6 7      // Порт для измерения Напряжения 6 ( Аналоговый порт! )

* 6.3 - Параметры калибровки измерения напряжения **********************************************************************
*     Для каждого из 6 напряжений Вы можете задать смещение (OFFSET) и количество милливольт на каждый шаг АЦП (RATIO).
*     Эти параметры будут специфичны для каждого собранного oXs и, в основном, зависят от резисторов, используемых в делителе, а также от опорного напряжения.
*
*     Напоминание: Arduino не сможет измерить напряжение, превышающее опорное (Vcc или  1.1 В).
*     Если измеряемое напряжение превышает опорное, оно должно быть снижено ("масштабировано") при помощи делителя.
*     Для каждого порта, напряжение на котором необходимо уменьшить, выполните следующее:
*      - Сделайте делитель на двух резисторах по такой схеме:
*
*                 ------>  Вход  = сюда подается измеряемое напряжение (АКБ, датчик тока и т.д.) 
*                 |
*               __|__   
*              |     |
*              |     |   R2           
*              |     |              
*              |_____|          
*                 |
*                 |------> Средняя точка = подключается к аналоговому порту Arduino, pin A0,A1,A2,A3, A6 или A7
*               __|__   
*              |     |
*              |     |   R1          
*              |     |              
*              |_____|          
*                 |
*                 ------>  Подключается на "Землю"
*
*      - R1 и R2 подбираются таким образом, чтобы напряжение, приходящее на Arduino, было как можно ближе, но не превышало опорного.
*      - Напряжение в средней точке = Vcc (или 1.1 В) = "максимальное напряжение, подаваемое на вход" * R1 / (R1 + R2)
*      - Значит, R2 = R1 * ( ( "максимальное напряжение, подаваемое на вход"  / Vcc [или 1.1В] ) - 1 )
*         Например, при опорном напряжении 1.1 В, чтобы измерять напряжения до 6 вольт, при R1 = 10000 (10 кОм) получим, что R2 = 10000 * (( 6 / 1.1 ) - 1) = 45545 Ом; ближайший номинал резистора не ниже вычисленного значения будет 47000 Ом (47 кОм)
*
*     Резисторы имеют определенную погрешность, опорное напряжение тоже не идеально, поэтому, для достижения лучшего результата, рекомендуется откалибровать каждый порт с учетом его делителя. Для этого:
*      - установите следующие параметры в файле oXs_config.h  :
*            - выберите опорное напряжение (Vcc или 1.1В)(в последнем случае уберите комментарий из строки "#define USE_INTERNAL_REFERENCE" )
*            - Установите первый OFFSET = 0 (обычно установлено по-умолчанию)
*            - установите первый MVOLT_PER_STEP = 1 (обычно установлено по-умолчанию)
*            - выберите поле, в котором будет передаваться полученное напряжение (например, поле T1) и заполните строку "#define SETUP_DATA_TO_SEND" соответствующим образом
*      - загрузите программу в Arduino 
*      - подавайте различные напряжения на Вход (не превышая допустимого предела, расчитанного для связки R1 и R2)
*      - для каждого напряжения нужно записать его точное значение (измеренное вольтметром) и соответствующее этому напряжению показание телеметрии на экране аппаратуры  
*      - Создав таблицу значений в Excel'е (или построив график), Вы можете вычислить наиболее точные значения параметров  MVOLT_PER_STEP и OFFSET (используя линейную регрессию)
*     Если метод выше кажется слишком сложным, просто подайте два различных напряжения в пределах предполагаемых значений, 
*     но как можно более удаленных друг от друга, и проведите подсчет в соответствии с примером:
*      Предположим, напряжение на входе будет меняться в диапазоне от 4 до 6 Вольт. Для калибровки, по-очереди подаем два различных напряжения - близкое 4В и близкое к 6В:
*        - Первое напряжение по показаниям вольтметра: 3510 мВ (миллиВольт); показания телеметрии: 533
*        - Второе напряжение по показаниям вольтметра: 5900 мВ (миллиВольт); показания телеметрии: 904
*      Тогда вычисляем: MVOLT_PER_STEP = (5900-3510) / (904-533) = 6.4420
*      и затем: OFFSET = 3510 - (533 * 6.4420 ) = 76
*  Примечание: этот же принцип может применяться и при измерении других параметров (не только напряжения). Например, Вы можете откалибровать датчик температуры. 
*  Примечание 2: если какие-то входы не используются, Вы можете закомментировать соответствующие для них строки, или удалить совсем. Но даже если строки останутся - они будут проигнорированы.
*
*  Если Вы не можете провести калибковку (например, не нашлось под рукой вольтметра), но все же хотите, чтобы oXs передавал более-менее правильное напряжение батареи, Вы можете рассчитать теоретическое значение MVOLT_PER_STEP по следующей формуле:
*         OFFSET = 0
*         MVOLT_PER_STEP = V / 1023 * (R1 + R2) / R1
*                      При этом:
*                     - V (в миллиВольтах) соответствует напряжению Vcc (как правило 5000) или внутреннему опорному напряжению 1.1 В (т.е. 1100)
*                     - R1 и R2 - номиналы резисторов, использованных в делителе, или 1, если делитель не установлен
*
*     #define OFFSET_1             0         Смещение для первого напряжения (= voltage 1) (значение по-умолчанию = 0)
*     #define MVOLT_PER_STEP_1       1       кол-во миллиВольт в одном шаге АЦП для первого напряжения (начальное значение = 1)
*     #define OFFSET_2             0         Смещение для второго напряжения 
*     #define MVOLT_PER_STEP_2       1       кол-во миллиВольт в одном шаге АЦП для второго напряжения
*     etc. up to 6
************************************************************************************************************************
#define OFFSET_1             0   
#define MVOLT_PER_STEP_1       4.89  // = 5000 / 1023 (если Vcc = 5 В)     
#define OFFSET_2             0    
#define MVOLT_PER_STEP_2       1    
#define OFFSET_3             0       
#define MVOLT_PER_STEP_3       1
#define OFFSET_4             0        
#define MVOLT_PER_STEP_4       1        
#define OFFSET_5             0        
#define MVOLT_PER_STEP_5       1        
#define OFFSET_6             0        
#define MVOLT_PER_STEP_6       1        

* 6.4 - Количество "банок" LiPo-батареи ********************************************************************************
*     В п.6.3 мы настроили входы на измерение напряжений. Все измеряемые напряжения считаются относительно "Земли".
*     oXs может использовать некоторые из полученных значений для вычисления напряжения LiPo-батареи.
*     В этом разделе задается максимальное число "банок" в батарее. Допустимые значения: 0 (нет "банок"),1,2,3,4,5,6.
*     Если задано значение больше 1, то oXs будет вычислять напряжение каждой "банки" исходя из разницы двух соседних напряжений, начиная с Voltage1.
*     Общее напряжение всех "банок" будет вычисляться на стороне аппаратуры путем сложения всех полученных напряжений.
*     Общее напряжение будет отображаться на аппаратуре в поле "Cells" (зависит от прошивки аппаратуры).
*     Аппаратура также будет показывать минимальное напряжение среди всех "банок" в поле "Cell" (зависит от прошивки аппаратуры).
*     Также, Вы можете включить экран, отображающий напряжения всех "банок" - см. инструкцию к используемой прошивке.
*     Например, если количество "банок" = 3, 
*           Напряжение cell 1 будет равно напряжению, измеренному на PIN_Voltage1
*           Напряжение cell 2 будет равно разнице напряжений, измеренных на PIN_VOLTAGE_2 и PIN_VOLTAGE_1
*           Напряжение cell 3 будет равно разнице напряжений, измеренных на PIN_VOLTAGE_3 и PIN_VOLTAGE_2
*     
*     НЕ ЗАБЫВАЙТЕ предварительно задать параметры PIN_VOLTAGE_x, а также указать значения для калибровки.
*     Переменные PIN_VOLTAGE_x, не занятые измерением напряжения батареи, могут быть использованы для передачи информации от других датчиков (например, от датчика температуры).
*     Например, если NUMBEROFCELLS = 3, то:
*                                PIN_VOLTAGE_1 должен быть подключен к cell 1 (через делитель напряжения до ~4.5 В)
*                                PIN_VOLTAGE_2 должен быть подключен к cell 2 (через делитель напряжения до ~9 В)
*                                PIN_VOLTAGE_3 должен быть подключен к cell 3 (через делитель напряжения до ~13 В)
*                                PIN_VOLTAGE_4, 5 и/или 6 могут быть использованы для передачи других данных (температура, ток, ...)
*     Примечания: Вы должны использовать делители напряжения при подключении балансирных разъемов LiPo-батарей.
*            Также учтите, что чем больше "банок" oXs измеряет, тем менее точными окажутся результаты измерений.
*            Вероятно, измерение более чем 3-4 "банок" по-отдельности не имеет смысла (утверждение спорно, требует перепроверки).
*            Если Вы не хотите передавать напряжения отдельных "банок", поставьте значение параметра NUMBEROFCELLS = 0, или закомментируйте строку.
*            Данный параметр задает количество "банок", иинформация о которых будет передаваться по телеметрии. Если к oXs будет подключен аккумулятор с меньшим количеством "банок", несуществующие "банки" будут отображаться с напряжением 0 В.
************************************************************************************************************************
#define NUMBEROFCELLS    3 

* 6.5 - Аналоговый порт датчика тока ***********************************************************************************
*     При подключении датчика тока, oXs сможет измерять ток (и потребление энергии). Данная функция является опциональной.
*     Для этого необходимо дополнительное оборудование. Датчиком тока может служить интегральная схема типа ACS712 (на 5, 20, 30 Ампер) или ACS758 (на 50, 100, 150, 200 Ампер).
*     Большинство датчиков умеют считать ток в обоих направлениях. Однако в линейке датчиков ACS758 есть версия "U", которая считает ток лишь в одном направлении - это позволяет получить бОльшую чувствительность.
*     Данные датчики относительно недороги (при покупке на ebay) и изменяют выходное напряжение в зависимости от протекающего через них тока. Это позволяет подключать их к аналоговым портам oXs.
*     Номер порта задается цифрой от 0 до 7 (соответственно используются порты от A0 до A7).
*     Не используйте для датчика тока порт, который уже задействован для чего-либо еще.
*  !! Как и в случае с измерением напряжений, напряжение, поступающее на вход Arduino, не должно превышать опорное напряжение (Vcc или 1.1 В).
*     Возможно, Вам придется использовать делитель напряжения (см п.6.3).
*     Внимание: НЕ ИСПОЛЬЗУЙТЕ порты A4 и A5, если Вы используете функционал вариометра или датчика воздушной скорости, т.к. эти порты зарезервированы для соответствующих датчиков давления.
* Примечание: Как правило, датчик тока питается от напряжения Vcc (5В) - также, как и датчик давления.
*       Как сказано выше, некоторые датчики могут считать ток в обоих направлениях, а некоторые - только в одном.
*       В случае "двунаправленных" датчиков, напряжение на выходе датчика обычно равняется Vcc/2 когда тока нет (0 Ампер). У "однонаправленных" датчиков в отсутствии тока напряжение на выходе обычно составляет 0,6В.
*       Если oXs запитан от батареи напряжением менее 5.2В, напряжение питания датчика тока будет нестабильно и будет зависеть от напряжения пиания oXs.
*       Таким образом, Vcc/2 ( = 0 Ампер) будет также меняться.
*       Это приведет к неточным показаниям, особенно в случае, когда oXs настроен на внутреннее опорное напряжение 1.1 В.
*       Поэтому в таких случаях использование Vcc в качестве опорного напряжения даст более точные результаты.
*       Уберите комментарий в строке //#define PIN_CURRENTSENSOR чтобы включить датчик тока, а также проведите его калибровку.
************************************************************************************************************************
//#define PIN_CURRENTSENSOR   2

* 6.6 - Параметры калибровки датчика тока ******************************************************************************
*     Датчик тока калибруется с помощью двух параметров:
*        OFFSET_CURRENT_STEPS  =  величина смещения для измеренного тока; обычно равно 1024/2 для "двунаправленного" датчика, т.к. 0 Amp соответствует Vcc/2 (или 1.1В/2 при использовании соответствующего делителя).
*                                 Для "однонаправленного" датчика напряжение при токе 0 Amp составляет 0.6В при использовании 5В Vcc; в этом случае смещение должно быть: 1024 * 0.6 /5 = 123.
*        MAMP_PER_STEP         =  количество миллиАмпер на каждый шаг АЦП; значение зависит от чувствительности датчика (и от используемого делителя напряжения).
*                                 Если делитель напряжения не используется, то значение MAMP_PER_STEP обычно вычисляется по формуле:
*                                  V (миллиВольт) / (чувствительность (мВ/Амп) * 1.023), где:
*                                     - V - это Vcc (т.е. 5000) или внутреннее напряжение 1.1В (т.е. 1100)
*                                     - Чувствительность обычно указана в спецификации на используемый датчик.
*                                         Например, для ACS758LCB-050U чувствительность = 60 mv/Amp
*                                              Тогда, при использовании 5В Vcc, получаем: 5000 / (60 * 1.023) = 81.5.
*        Примечание: эти параметры будут игнорироваться, если PIN-CURRENTSENSOR не задан.
************************************************************************************************************************
#define OFFSET_CURRENT_STEPS         0         //66mv offset (set to zero for now)
#define MAMP_PER_STEP                0.9775    //INA282 with 0.1 ohm shunt gives 5000mv/A


**** 7 - Датчик оборотов (RPM) *****************************************************************************************
*      oXs позволяет считать количество оборотов при подключении датчика оборотов к порту ICP (=PB0, = pin 8).
*      Датчик должен изменять уровень сигнала (0 - Vcc) каждый раз когда, например, мимо него проходит лопасть.
*      Таким образом важным параметром является количество лопастей. Однако, это настраивается уже на аппаратуре.
*      Для включения данной функции уберите комментарий со строки #define MEASURE_RPM
* Примечание: Только порт 8 (PB0/ICP) может использоваться для датчика оборотов.
************************************************************************************************************************
//#define MEASURE_RPM


**** 8 - Настройки "постоянной" памяти *********************************************************************************
*      При активированной функции "постоянной" памяти, расход АКБ будет записываться в EEPROM каждые 10 секунд, 
*      а при отключении и повторном включении значение будет восстанавливаться.
*      Таким образом Вы сможете увидеть текущий расход АКБ даже если Вы отключаете АКБ между полетами.
*      Сброс показаний возможен при помощи кнопки, подключенной к oXs.
*      Для этого кнопка должна быть подключена к цифровому порту Arduino и к "Земле".
*      Чтобы активировать эту функцию, Вы должны:
*          - убрать комментарии в строке "#define SAVE_TO_EEPROM"
*          - указать цифровой порт Arduino, к которому подключена кнопка сброса.
*               Значение по-умолчанию: 10 ; при необходимости могут быть использованы другие порты.
************************************************************************************************************************
#define SAVE_TO_EEPROM
#define PIN_PUSHBUTTON    10   


**** 9 - Передаваемые данные *******************************************************************************************
*      В этом разделе Вы должны указать значения и поля, которые будут передаваться по телеметрии.
*      Вы также можете указать множители, которые должен применять oXs при передаче данных.
*      Кроме этого, для протокола Multiplex Вы можете также задать диапазон значений, которые будут включать или выключать "тревогу".
*
*      Каждый параметр, который рассчитан oXs, имеет свой идентификатор или имя (= имя параметра oXs ).
*      Большинство параметров могут быть переданы посредством любого из поддерживаемых протоколов, однако есть некоторые исключения.
*
*      В протоколе Multiplex для каждого параметра Вы должны указать только номер строки (2...15), в которой данный параметр должен 
*            быть отображен на аппаратуре. На самой аппаратуре никаких преобразований полученных данных не производится.
*      В протоколе FrSky каждое переданное значение содержит соответствующий ему идентификационный код FrSky.
*            В зависимости от кода FrSky, аппаратура производит преобразования, перевод величин и определяет местоположение значения на экране.
*            Настройка oXs базируется на названиях полей телеметрии на стороне аппаратуры.
*
* Примечание: некоторые поля телеметрии не могут передаваться на приемники FrSky серии D, т.к. эти поля не поддерживаются протоколом приемников (например, поля A3 и A4).
*      В некоторых случаях oXs может самостоятельно выбрать правильные поля телеметрии. Для этого используйте параметр "DEFAULTFIELD" в качестве имени поля (см. список ниже).
*      Однако, не все поля совместимы с параметром DEFAULTFIELD - например потому, что FrSky и OpenTX не предусмотрели поля для некоторых значений параметров oXs (например, чувствительность вариометра - поле Vario sensitivity).
*      В этих случаях Вы можете самостоятельно выбрать в каком поле будет отображаться то или иное значение (например, чувствительность может передаваться как T1).  
*      С другой стороны, некоторые телеметрийные поля требуют специальной обработки, поэтому для них применимо только DEFAULTFIELD. В этом случае oXs самостоятельно подберет нужные параметры для передачи данных.
*      В списке ниже представлена информация о возможном применении DEFAULTFIELD с конкретными полями. В частности, приведены варианты использования - "Обязательно", "Возможно" (но можно использовать что-то другое) или "Запрещено".
* Примечание: для приемников серии D параметр DEFAULTFIELD не всегда работает как эквивалент field_ID. Это распространяется на:
*        - ALTIMETER (протокол HUB требует, чтобы метры и сантиметры передавались в разных полях)
*        - VERTICAL_SPEED (в протоколе HUB значения 0.10 и -0.10 преобразуются в 0.09 и -0.09, чтобы обойти ошибку в одной из старых версий протокола)
*        - CURRENTMA (в протоколе HUB, при использовании DEFAULTFIELD, oXs берет текущее значение миллиАмпер и делит на 100, при этом дополнительная конвертация не требуются).
*
* Примечание: FrSky требует, чтобы некоторые поля телеметрии имели особый формат. Например, в протоколе X-серии, напряжение на 1-й и 2-й "банках" LiPo должны передаваться в одном поле.
*       oXs делает необходимые манипуляции автоматически, когда используется параметр DEFAULTFIELD.
*       OpenTx также применяет свое форматирование к полученным данным. Например, oXs передает вертикальную скорость в см/с, однако OpenTx показывает ее в м/с с двумя знаками после запятой.
*       Также OpenTX может конвертировать некоторые данные из метрической системы в дюймовую и наоборот.
*       Поэтому, если Вы передаете какие-то данные в "нестандартные" поля телеметрии, возможно, потребуется добавить какие-то преобразования.
*       В oXs это реализовано с помощью множителя (по-умолчанию 1), делителя (по-умолчанию 1) и смещения (по-умолчанию 0). Значения по-умолчанию не добавляют каких-либо преобразований.
*
* Примечание: OpenTx не преобразует поля T1, T2, AccX, AccY, AccZ, если на аппаратуре установлен метрический режим. Поэтому данные поля могут использоваться для получения "чистых" значений каких-либо параметров oXs.
*
********************************************  Список телеметрийных параметров oXs (включает все возможные опции)  ***************************************************
*        oXs             oXs      Описание                           Использование с опцией DEFAULTFIELD           Название поля на аппаратуре       Размерность
*    Имя параметра   размерность                                     Обязательно / Возможно / Запрещено          при использовании DEFAULTFIELD 
*    ALTIMETER           cm      Высота (1)                                Возможно (X series)                                 Alt                        1m
*                                                                          Обязательно (D series)                              Alt
*    ALTIMETER_2         cm      Высота (2)                                Возможно (X series)                                 Alt                        1m
*                                                                          Обязательно (D series)  
*    VERTICAL_SPEED     cm/s     Вертикальная скорость (1)                          Возможно                                  VSpd                      0.1m/s
*    VERTICAL_SPEED_2   cm/s     Вертикальная скорость (2)                          Возможно                                  VSpd
*    VERTICAL_SPEED_A   cm/s     Вертикальная скорость (7)                          Возможно                                  VSpd
*    PRANDTL_DTE        cm/s     Компенсированная верт. скор. (по воздушной)(3)     Возможно                                  VSpd
*    PPM_VSPEED         cm/s     Верт. скор. выбранная PWM (4)                      Возможно (X series)                       VSpd
*                                                                         Не имплементировано (D series)  
*    SENSITIVITY        none     Чувствительность вариометра (1)                    Запрещено
*    SENSITIVITY_2      none     Чувствительность вариометра (2)                    Запрещено 
*    ALT_OVER_10_SEC     m       Разница высот за последние 10сек. (1)              Запрещено
*    ALT_OVER_10_SEC_2   m       Разница высот за последние 10сек. (2)              Запрещено
*    VOLT1             mV(5)     Значение PIN_VOLTAGE_1 (миллиВольт)                Запрещено
*    VOLT2             mV(5)     Значение PIN_VOLTAGE_2 (миллиВольт)                Запрещено
*    VOLT3             mV(5)     Значение PIN_VOLTAGE_3 (миллиВольт)                Запрещено
*    VOLT4             mV(5)     Значение PIN_VOLTAGE_4 (миллиВольт)                Запрещено
*    VOLT5             mV(5)     Значение PIN_VOLTAGE_5 (миллиВольт)                Запрещено
*    VOLT6             mV(5)     Значение PIN_VOLTAGE_6 (миллиВольт)                Запрещено
*    CELLS_1_2        special    Напряжение "банок" 1 & 2                           Обязательно                           Cell & Cells
*    CELLS_3_4        special    Напряжение "банок" 3 & 4                           Обязательно                           Cell & Cells
*    CELLS_5_6        special    Напряжение "банок" 5 & 6                           Обязательно                           Cell & Cells
*    CURRENTMA          mA       Текущие показания датчика тока (миллиАмпер)        Возможно                                 Curr
*    MILLIAH            mAh      Общее потребление, мАч                             Возможно                                 Fuel
*    RPM              t/min(?)   Показания датчика оборотов                         Обязательно                              Rpm
*    AIR_SPEED        knot/10    Воздушная скорость                                 Возможно (X series)                      ASpd
*                                                                                   Возможно (D series)                      Spd (6)      
*    PRANDTL_COMPENSATION cm/s   Компенсация (для компенс. вариометра)              Запрещено
*    PPM                none     Текущее значение PWM сигнала (диап.: -100 +100)    Запрещено
*    REL_ALTIMETER       cm      Относительная высота (1)                     Не имплементировано в протоколе FrSky            1m
*    REL_ALTIMETER_2     cm      Относительная высота (2)                     Не имплементировано в протоколе FrSky            1m
*    ALTIMETER_MAX       cm      Максимальная относительная высота (1)        Не имплементировано в протоколе FrSky            1m
*    CELL_1             mV(5)    Текущее значение на PIN_VOLTAGE_1            Не имплементировано в протоколе FrSky           0.1V
*    CELL_2             mV(5)    Текущее значение на PIN_VOLTAGE_1 & 2        Не имплементировано в протоколе FrSky           0.1V
*    CELL_3             mV(5)    Текущее значение на PIN_VOLTAGE_2 & 3        Не имплементировано в протоколе FrSky           0.1V
*    CELL_4             mV(5)    Текущее значение на PIN_VOLTAGE_3 & 4        Не имплементировано в протоколе FrSky           0.1V
*    CELL_5             mV(5)    Текущее значение на PIN_VOLTAGE_4 & 5        Не имплементировано в протоколе FrSky           0.1V
*    CELL_6             mV(5)    Текущее значение на PIN_VOLTAGE_5 & 6        Не имплементировано в протоколе FrSky           0.1V
*    CELL_MIN           mV(5)    Минимальное значение из CELL_1 ... CELL_6    Не имплементировано в протоколе FrSky           0.1V
*    CELL_TOT           mV(5)    Суммарное значение VOLT1...VOLT6             Не имплементировано в протоколе FrSky           0.1V


*   (1) показания с первого датчика давления (MS5611)
*   (2) Показания со второго датчика давления (MS5611)
*   (3) PRANDTL_DTE - компенсированная вертикальная скорость (= изменение полной энергии).
*       Расчет основывается на вертикальной скорости по показаниям первого датчика давления с учетом коррекции по воздушной скорости.
*       Таким образом, этот параметр подразумевает наличие датчика давления и датчика воздушной скорости с трубкой Прандтля (см. п.3 и п.4).
*   (4) Когда oXs вычитсяет 2 вертикальные скорости (при помощи двух датчиков давления или одного датчика давления и датчика воздушной скорости), пользователь может переключаться между двумя значениями.
*       Это требует настройки PWM и опции SWITCH_VARIO_WITH_PPM - см. п.3.
*   (5) Размерность зависит от параметров калибровки (например, при использовании датчика температуры, размерность будет в градусах)
*       Когда используется для измерения напряжений, калибровка должна быть выполнена для размерности миллиВольт
*   (6) Для приемников серии D протокол не позволяет передавать поле "airspeed". При этом oXs отправляет данные в поле "Gps speed".
*   (7) Усредненное значение показаний первого и второго датчиков давления (MS5611)
* 
* Примечание: когда DEFAULTFIELD обозначен как "Возможно" или "Запрещено", Вы можете самостоятельно выбрать поле, в котором будут передаваться данные (например, параметр SENSITIVITY может отправляться как T1 или T2 , или ...) 
*
*
*******************************   Поля телеметрии в протоколе FrSky (= назвавния полей на аппаратуре) *******************
*-- Поле в OpenTx ----------- Соответствующий параметр oXs ------------------------
*    Код   Размерность
*          (metric)
*   Alt     m            ALTIMETER
*   VSpd    m/s          VERTICAL_SPEED или VERTICAL_SPEED_2 или PRANDTL_DTE или PPM_VSPEED
*   Curr    A            CURRENTMA
*   Vfas    V            Один из VOLT1, VOLT2,...VOLT6
*   T1                   Может быть использован как один из VOLT1, VOLT2,...VOLT6 или sensitivity, PPM, ...
*   T2                   Может быть использован как один из VOLT1, VOLT2,...VOLT6 или sensitivity, PPM, ...
*   Rpm                  RPM
*   Fuel                 MILLIAH
*   AccX                 Может быть использован как один из VOLT1, VOLT2,...VOLT6 или sensitivity, PPM, ...
*   AccY                 Может быть использован как один из VOLT1, VOLT2,...VOLT6 или sensitivity, PPM, ...
*   AccZ                 Может быть использован как один из VOLT1, VOLT2,...VOLT6 или sensitivity, PPM, ...
*   A3                   Недоступен для приемников серии D, Может быть использован как один из VOLT1, VOLT2,...VOLT6 или sensitivity, PPM, ...
*   A4                   Недоступен для приемников серии D, Может быть использован как один из VOLT1, VOLT2,...VOLT6 или sensitivity, PPM, ...
*   ASpd 1/10 of knot    AIR_SPEED , Недоступен для приемников серии D
*   Cell & Cells         CELLS_1_2 & CELLS_3_4 & CELLS_5_6
*
************** Настройка передаваемых параметров ***********************************************
*     На одной строке может быть указан только один параметр
*     Формат строк различается для протоколов Multiplex и FrSky.
* 9.1 Multiplex protocol : каждая строка должна иметь следующий формат:
*        -  1 : номер строки, в которой параметр будет отображен на экране. Допустимые значения: от 2 до 15, номера строк повторяться не могут
*        -  2 : запятая
*        -  3 : название параметра oXs для передачи в этом поле (например, "VOLT1")  (см. примечание (2) ниже)
*        -  4 : запятая
*        -  5 : множитель (поставьте "1" чтобы не менять рассчитанное значение, 10 чтобы увеличить в 10 раз, ...) (см. примечание (3))
*        -  6 : запятая
*        -  7 : делитель (поставьте "1" чтобы не менять рассчитанное значение, 10 чтобы уменьшить в 10 раз, ...) (см. примечание (3))
*        -  8 : запятая
*        -  9 : смещение (поставьте "0" чтобы не менять рассчитанное значение, "100" чтобы увеличить на 100, ...)
*        - 10 : запятая
*        - 11 : Тревога - нижнее значение (см. примечание (4))
*        - 12 : запятая
*        - 13 : Тревога - верхнее значение (см. примечание (4))
*        - 14 : запятая и символ "\" если это не последняя строка настройки параметров (на последней строке символ "\" добавлять не надо);
*                  ВНИМАНИЕ: символ "\" должен быть ПОСЛЕДНИМ символом в строке (после него недопускаются даже пробелы)
*                  ВНИМАНИЕ: в этом разделе комментарии ("*...") между строками недопустимы
* 9.2 FrSky protocol : каждая строка должна иметь следующий формат:
*        -  1 : название поля телеметрии (например, "Alt" ) или DEFAULTFIELD (когда допустимо) (!! см. примечение (1) ниже)
*        -  2 : запятая
*        -  3 : название параметра oXs для передачи в этом поле (например, "VOLT1")  (см. примечание (2))
*        -  4 : запятая
*        -  5 : множитель (поставьте "1" чтобы не менять рассчитанное значение, 10 чтобы увеличить в 10 раз, ...) (см. примечание (3))
*        -  6 : запятая
*        -  7 : делитель (поставьте "1" чтобы не менять рассчитанное значение, 10 чтобы уменьшить в 10 раз, ...) (см. примечание (3))
*        -  8 : запятая
*        -  9 : смещение ((поставьте "0" чтобы не менять рассчитанное значение, "100" чтобы увеличить на 100, ...)
*        - 10 : запятая и символ "\" если это не последняя строка настройки параметров (на последней строке символ "\" добавлять не надо);
*                  ВНИМАНИЕ: символ "\" должен быть ПОСЛЕДНИМ символом в строке (после него недопускаются даже пробелы)
*                  ВНИМАНИЕ: в этом разделе комментарии ("*...") между строками недопустимы
*
* Примечание (1) : Во многих случаях (см. списки выше) Вы можете или даже должны указать значение "DEFAULTFIELD". Это означает, что oXs будет передавать данные в наиболее подходящем поле.
*            Однако, в некоторых случаях использование DEFAULTFIELD невозможно, т.к. показания oXs не имеют заранее определенного поля в прошивке аппаратуры. Тогда Вы должны указать поле вручную.
*            Учтите, что некоторые названия полей на аппаратуре (такие как A3, A4, ASpd) недоступны при использовании ресиверов серии D из-за отстутствия соответствующей поддержки в протоколе FrSky.
*            За исключением DEFAULTFIELD, названия полей (например "T1" ) не могут использоваться более одного раза в этом разделе, другими словами каждое поле может отображать только один параметр.
*            Местоположение рядов друг относительно друга значения не имеет.
* Примечание (2) : Название параметра oXs (например, VOLT1) может использоваться только один раз.
* Примечание (3) : Множитель, делитель и смещение должны быть целыми числами (использование дробей недопустимо); они могут быть отрицательными (например, "-100").
*            Множитель и делитель могут быть полезны:
*              - для перевода в другую систему мер (метры <> футы)
*              - для перевода в % (например множитель = 100 и делитель = 4000 дадут показания израсходованной емкости в % от 4000 мАч АКБ)
*              - для корректировки количества цифр, отображаемых на телеметрийном экране аппаратуры.
*              - чтобы показания fuel (уровень топлива) начинались на 100 (в процентах) и уменьшались до 0 по мере расходования (в этом случае Вы должны использовать отрицательныый множитель и смещение = 100%).
*            Множитель/делитель/смещение должны быть указаны всегда, однако они не всегда будут учитываться oXs. Например, они не учитываются для:
*              - CELLS_1_2, CELLS_3_4, CELLS_5_6 (т.к. эти поля имеют специальный формат и обрабатываются на стороне, принимающей телеметрию)
* Примечание (4) : значения, задающие пределы "Тревоги" должны быть целочисленными. Они могут быть отрицательными (например, "-100"). 
*                Чтобы настроить "Тревогу" в соответствии с протоколом Multiplex, oXs делает следующее:
*                 - адаптирует количество знаков после запятой (т.к. большинство значений, вычисляемых oXs, имеют больше знаков после запятой, чем допускается протоколом Multiplex)
*                 - применяет параметры множителя/делителя/смещения
*                 - сравнивает результат с заданными границами (нижней и верхней) "Тревоги"
*               Пределы должны устанавливаться с учетом всех цифр, отображаемых на экране телеметрии.
*                  например, напряжения отображаются с точностью 0.1 В. Если Вы хотите, чтобы "Тревога" включалась когда напряжение равно или ниже 11.2В, Вы должны установить нижнее значение Тревоги = 112.
*              Чтобы отключить "Тревогу", установите нижнее значение = -16384 и/или верхнее значение = 16383 (в соответствии с 15 битами в протоколе Multiplex)
*   
* Пример настройки протокола Multiplex:
*     - В строке 3: показания относительной высоты
*     - В строке 6: показания вертикальной скорости (с запуском "Тревоги" если скорость превышает 50 м/с)
*            #define SETUP_MULTIPLEX_DATA_TO_SEND    \
*                       3 , ALTIMETER , 1 , 1 , 0 , -16384 , 16383,\
*                       6 , VERTICAL_SPEED , 1 , 1 , -500 , 500
*
* Пример настройки протокола FrSky:
*    - поле Altitude : текущее показание высоты
*    - поле Vertical speed : текущее показание вертикальной скорости
*    - поле Current : текущее показание тока
*    - поле Fuel : расход энергии в % для АКБ емкостью 4000мАч, уменьшаясь от 100% 
*    - поле Temperature T1 : текущее показание VOLT6, разделенное на 100
*               #define SETUP_FRSKY_DATA_TO_SEND    \
*                        DEFAULTFIELD , ALTIMETER , 1 , 1 , 0 ,\
*                        DEFAULTFIELD , VERTICAL_SPEED , 1 , 1 ,0 ,\
*                        DEFAULTFIELD , CURRENTMA , 1 , 1 , 0,\
*                        Fuel , MILLIAH , -100 , 4000 ,0, \
*                        T1 , VOLT6, 1 , 100, 0
* Напряжения отдельных "банок" АКБ передаются в протоколе FrSky SPORT группами по 2.
*    Для целостности внутренней обработки, эти напряжения вычисляются и сохраняются парами также и для протокола HUB, насмотря на то, что в данном протоколе они передаются одним фреймом.
*    Поэтому в обоих случаях количество строк, которые Вы должны задать для отображения напряжений, равняется количеству "банок", разделенному на два и округленному до ближайшего большего значения.
*    Например, для LiPo с тремя "банками" (3S), Вы должны указать: 3 / 2 = 1.5 => 2 строки. 
*         В каждой из них используйте параметр DEFAULTFIELD, но в первой строке укажите CELLS_1_2, а во второй - CELLS_3_4.
*         Нет необходимости добавлять строку, содержащую CELLS_5_6.
* **********************************************************************************************************************
*  ВАЖНО: всегда оставляйте строку "#define SETUP_DATA_TO_SEND    \"  как есть, а также не добавляйте комментариев в этом разделе.

**** 10 - Sequencer (ON/OFF) для цифровых портов *****************************************************************************
* oXs позволяет контролировать (HIGH/LOW) до 6 цифровых портов Arduino в соответствии с последовательностями, задаваемыми пользователем.
* Каждая последовательность может состоять из одного или из нескольких шагов; каждый шаг определяет как долго (длительность) и какие выходы должны быть ВКЛЮЧЕНЫ, а какие - ВЫКЛЮЧЕНЫ.
* Обычно oXs определяет последовательность, которую он должен воспроизвести, исходя из PWM-сигнала, полученного от приемника (для настройки PWM см. п.3). 
* Однако, есть два исключения:
*    При включении, либо в отсутствии PWM-сигнала, oXs будет по-умолчанию воспроизводить последовательность #define SEQUENCE_m100 (см. ниже)
*    Если настроена сигнализация о низком напряжении батареи (см. ниже) и если напряжение падает до этого уровня, oXs будет воспроизводить последовательность #define SEQUENCE_100 (см. ниже) пока напряжение батареи не станет выше установленного предела.
*По окончании воспроизведения последовательности, oXs может либо повторять ее, либо просто ждать команды на воспроизведение следующей последовательности. Это задается в настройках самой последовательности.
* Каждый раз при получении нового (= отличного от текущего значения) PWM сигнала, oXs незамедлительно запустит соответствующую последовательность (даже если текущая последовательность не пройдена до конца).
* - Чтобы использовать функционал Sequencer'а, Вы должны задать номера портов, которые он будет контролировать.
*     Допустимые порты Arduino: 13, 12, 11, 10, 9 и 8.
*     Это настраивается строкой вида : #define SEQUENCE_OUTPUTS 0b100100
*     Каждый бит (1 или 0, идущие после "b") отвечают за определенный порт; наименее значащий бит соответствует порту 8, бит, стоящий слева от него - порту 9, и т.д., до порта 13.
*     Поставьте 1, если порт должен управляться Sequencer'ом, и 0 - если не должен. В примере выше, Sequencer будет управлять только портами 13 и 10.
*     Примечание: если строка #define SEQUENCE_OUTPUTS xxxx удалена или закомментирована, Sequencer не будет активирован.
*           Не используйте один и тот же порт для Sequencer'а и для какой-либо другой функции.
*           Если при настройке портов какой-либо порт задан как 0 (= не управляется oXs), он никогда не будет включаться или выключаться Sequencer'ом, даже если в какой-либо последовательности он будет задействован.
*           При активированной функции Sequencer'а (т.е. при задании SEQUENCE_OUTPUTS ), PWM сигнал будет использоваться ТОЛЬКО для управления последовательностями. Таким образом, у Вас не будет возможности использовать его для контроля чувствительности вариометра и др.
*           Ток, протекающий через порты Arduino, не пожет превышать 40мА на порт, или же 100мА в целом.
*               В случае, если Вы хотите подключить существенную нагрузку (такую как светодиоды высокой мощности, светодиодные сборки и др.), Вы должны добавить к Arduino выходные каскады на транзисторах. Соответствующие схемы можно найти в Google.
* - Вы можете указать шаг (минимальный интервал), используемый при вычислении длительности вкл/выкл.
*       По-умолчанию, минимальный шаг длительности равен десяти миллисекундам (10 мс). Вы можете увеличить это значение, если требуется, с шагом в 10мс.
*       Например, строкой #define SEQUENCE_UNIT 50, Вы увеличите минимальный шаг до 500мс (= 50 * 10).
*       Примечание: этот параметр должен быть целым числом между 1 и 1000. Значения менее 10мс недоступны.
*             Если эта строка отсутствует или закомментирована, будет использовано значение по-умолчанию (1 = 10мс).
* - Затем Вы должны задать последовательности для каждого значения PWM-сигнала.
*       Вы можете указать в общей сложности до 9 последовательностей.
*       Последовательность задается строкой вида : #define SEQUENCE_m50    200 , 0b100000 , 300 , 0b000000 , 100 , 0b100100
*       Каждая последовательность в своем названии включает значение PWM-сигнала, который будет ее активировать. Суффикс "m100" означает, что последовательность будет активирована при PWM-сигнале около "-100", "m75" = "-75", ... "75" = "75", и т.д.
*       Суффиксы заданы с шагом в 25, поэтому допустимы суффиксы:  m100, m75, m50, m25, 0, 25, 50, 75 и 100
*       Каждая последовательность состоит из нескольких шагов (от 1 до 126, или даже больше), разделенных символом "," (запятая).
*          Каждый шаг состоит из 2 параметров (также разделенных запятой): длительность и комбинация ВКЛ/ВЫКЛ выходов.
*             - "Длительность" может принимать любое значение между 0 и 255.
*               Это значение определяет время, в течение которого будет применена соответствующая комбинация выходов. Длительность (в мс) = число * SEQUENCE_UNIT * 10
*               Например, при SEQUENCE_UNIT = 50, значение длительности "2" будет означать время = 1сек.
*               Значение длительности = 0 в данном случае подразумевает бесконечность. Когда oXs доходит до длительности = 0, он применяет указанную комбинацию и оставляет ее до тех пор, пока не получит команду на воспроизведение другой последовательности.
*               Это позволяет оставлять выходы в требуемом состоянии в конце воспроизведения последовательности.
*               Если используется длительность = 0, то этот шаг должен стоять в конце последовательности (т.к. шаги, следующие за этим, не будут выполнены).
*               Если первый же шаг будет с длительностью = 0, то oXs сразу же установит заданную комбинацию.
*               Если последовательность не имеет шага с длительностью = 0, то, после исполнения последнего шага, oXs начнет воспроизведение последовательности заново.
*               Примечание: если Вам нужна длительность больше, чем максимально возможная длительность (= 255 * SEQUENCE_UNIT * 10мс), Вы можете задать несколько шагов подряд с одинаковой комбинацией выходов.   
*             - Комбинация выходов (ВКЛ/ВЫКЛ) определяет состояние портов, которое будет задано на каждом шаге.
*               Комбинация задается в двоичном формате путем указания "1" или "0" сразу после "0b" (например, 0b100100). 
*               Здесь "1" соответствует ВКЛ (или же ВЫСОКИЙ уровень сигнала), а "0" - ВЫКЛ (или же НИЗКИЙ уровень сигнала) .
*               Меньший значащий бит соответствует порту 8, следующий бит слева от него - порту 9, ... и т.д., до порта 13.
*               Таким образом, если SEQUENCE_OUTPUTS = 0b110111, а шаг в последовательности задан 0b100100, то:
*                   - уровень портов 13 и 10 будет ВЫСОКИМ
*                   - уровень портов 9 и 8 будет НИЗКИМ
*                   - остальные порты (12 и 11) не будут менять своего состояния, т.к. Sequencer их не котролирует ( SEQUENCE_OUTPUTS = 0b100111 ).
*      В качестве примера разберем строку: #define SEQUENCE_m50    2 , 0b100000 , 3 , 0b000000 , 1 , 0b100100 
*        Предположив, что SEQUENCE_OUTPUTS = 0b100100 и SEQUENCE_UNIT = 50, мы получим следующую последовательность:
*            - В момент, когда PWM-сигнал будет в р-не "-50", oXs переведет порт 13 в ВЫСОКИЙ уровень (ВКЛ), а порт 10 - в НИЗКИЙ (ВЫКЛ) (= 0b100000)
*            - затем пауза: 2 * 50 * 10 = 1000 мс, т.е. состояние выходов останется неизменным в течение 1с.
*            - по прошествии 1с, порт 13 (и порт 10) будут переведены в НИЗКОЕ состояние (ВЫКЛ) (=0b000000) на 1.5с (3 * 50 * 10)
*            - по прошествии 1.5с, порты 13 и 10 будут переведены в ВЫСОКОЕ состояние (ВКЛ) на 0.5с (1 * 50 * 10)
*            - по прошествии 0.5с, первый шаг будет повторен (порт 13 ВКЛ на 1с)
*            - и т.д. 
* - Кроме этого, вы можете (по желанию) настроить условия для включения сигнализации о низком напряжении АКБ. При этом, когда напряжение падает ниже заданного предела, oXs запустит специальную последовательность SEQUENCE_LOW (независимо от текущего значения управляющего PWM-сигнала).
*     Проверка напряжения АКБ может быть выполнена по 1 или по 2 контрольным точкам:
*         Контрольная точка 1: напряжение на порту Arduino, заданному как PIN_VOLTAGE_6; в этом случае настройка должна быть такой: #define SEQUENCE_MIN_VOLT_6 6000 где 6000 - это нижний порог напряжения, заданный в миллиВольтах.
*           Примечание: если Вы пользуетесь данной опцией, не забудьте настроить параметр PIN_VOLTAGE_6, а также соответствующие ему OFFSET_6 и MVOLT_PER_STEP_6        
*                 Порт, заданный в качестве PIN_VOLTAGE_6, может совпадать с каким-либо другим PIN_VOLTAGE; это может быть полезно, если Вы хотите использовать также вторую контрольную точку.
*         Контрольная точка 2: наименьшее напряжение любой "банки" LiPo; в этом случае настройка должна быть такой: #define SEQUENCE_MIN_CELL 3000 где 3000 - это нижний порог напряжения, заданный в миллиВольтах.
*           Примечание: если Вы пользуетесь данной опцией, не забудьте настроить параметры PIN_VOLTAGE_1 , OFFSET_1 , MVOLT_PER_STEP_1 , PIN_VOLTAGE_2 , OFFSET_2 , MVOLT_PER_STEP_2 , и т.д., а также параметр NUMBEROFCELLS
*     Примечание:  когда ни одна контрольная точка не задана, oXs не будет контролировать напряжение АКБ и атоматически запускать SEQUENCE_LOW.
*            Когда заданы обе точки, последовательность SEQUENCE_LOW будет запущена, как только выполнится любое из заданных условий.
*            Если Вы хотите чтобы oXs отслеживал и сигнализировал о низком уровне напряжения АКБ, не забудьте задать последовательность SEQUENCE_LOW (иначе oXs просто переведет все контролируемые им порты в НИЗКОЕ состояние (ВЫКЛ))
*            Если Вы пользуетесь телеметрией, Вы можете контролировать напряжение АКБ на аппаратуре и настроить условие, которое будет включать определенную последовательность посредством PWM-сигнала.
*               В этом случае нет необходимости настраивать мониторинг АКБ на стороне oXs, а также один датчик может быть использован с различными моделями (с разной конфигурацией АКБ).************************************************************************************************************************
//#define DEBUG


**** 11 - Reserved for developer / Зарезервировано для разработчиков ***************************************************
* DEBUG must be activated here when you want to debug one or several functions in some other files.
* You can then select the parts that you want to debug by uncommenting the specifics DEBUG parameters you want in each file
* Note: oXs allows to transmit 3 fields named TEST1, TEST2, TEST3. You can fill those fields with whatever you want where you want if you want to transmit additional data to the Tx.
* Just fill in test1Value (or 2, 3) with an int32_t and test1ValueAvailable (or 2, 3) with true and add those oXs measurements in the data to be sent section. 
************************************************************************************************************************
//#define DEBUG


