
.def	Counter = r17

EeInit:

	ldz 0			;check EE signature
	call ReadEeprom
	adiw z, 1
	cpi t, 0x19
	brne eei1

	call ReadEeprom
	adiw z, 1
	cpi t, 0x03
	brne eei1

	call ReadEeprom
	adiw z, 1
	cpi t, 0x73
	brne eei1

	call ReadEeprom
	adiw z, 1
	cpi t, 0xA0
	brne eei1

	ldz eeUserAccepted	;show the usage warning and disclaimer unless it has already been accepted
	call ReadEeprom
	brflagtrue t, eei2

	call ShowUsageWarningAndDisclaimer
	rvsetflagtrue Mode	;set flag to skip ESC calibration

eei2:	ret

eei1:				;initalize

	ldz EeMixerTable	;Mixertable
	ldx 0
	ldi Counter, 64
eei3:	call StoreEeVariable8
	dec Counter
	brne eei3

	ldx EeParameterTable	;ParameterTable
	ldy eei4 * 2
	ldi Counter, 24
eei5:	movw z, y
	lpm t, z
	movw z, x
	call WriteEeprom
	adiw x, 1
	adiw y, 1
	dec Counter
	brne eei5

	ldx EeStickScaleRoll	;Stick Scaling
	ldy eei7 * 2
	ldi Counter, 8
eei8:	movw z, y
	lpm t, z
	movw z, x
	call WriteEeprom
	adiw x, 1
	adiw y, 1
	dec Counter
	brne eei8


	ldx 10
	ldz eeEscLowLimit
	call StoreEeVariable16

	ldx 0x24
	ldz eeLcdContrast
	call StoreEeVariable16


	ldx 60
	ldz eeSelflevelPgain
	call StoreEeVariable16

	ldx 20
	ldz eeSelflevelPlimit
	call StoreEeVariable16

	clr xl
	ldz eeSlPgainRate
	call StoreEeVariable8


	ldx 0
	ldz eeHeightDampeningGain
	call StoreEeVariable16

	ldx 30
	ldz eeHeightDampeningLimit
	call StoreEeVariable16

	ldx 0
	ldz eeBattAlarmVoltage
	call StoreEeVariable16

	ldx 50
	ldz eeServoFilter
	call StoreEeVariable16


	ldx 0
	ldz eeAccTrimRoll
	call StoreEeVariable16

	ldx 0
	ldz eeAccTrimPitch
	call StoreEeVariable16

	ldx 1 
	ldz eeCppmRoll
	call StoreEeVariable8
	ldx 2
	ldz eeCppmPitch
	call StoreEeVariable8
	ldx 3
	ldz eeCppmThrottle
	call StoreEeVariable8
	ldx 4
	ldz eeCppmYaw
	call StoreEeVariable8
	ldx 5
	ldz eeCppmAux
	call StoreEeVariable8

	ldx 0
	ldz eeCamRollGain
	call StoreEeVariable16

	ldx 0
	ldz eeCamPitchGain
	call StoreEeVariable16

	setflagtrue xl
	ldz eeLinkRollPitch
	call StoreEeVariable8

	setflagtrue xl
	ldz eeAutoDisarm
	call StoreEeVariable8

	setflagtrue xl
	ldz eeButtonBeep
	call StoreEeVariable8

	setflagtrue xl
	ldz eeArmingBeeps
	call StoreEeVariable8

	setflagfalse xl
	ldz eeCamServoMixing
	call StoreEeVariable8

	setflagfalse xl
	ldz eeSensorsCalibrated
	call StoreEeVariable8
	
	setflagfalse xl
	ldz eeMotorLayoutOk
	call StoreEeVariable8

	setflagfalse xl
	ldz eeUserAccepted
	call StoreEeVariable8

	ldz 0			;EE signature
	ldi t, 0x19
	call WriteEeprom
	adiw z, 1
	ldi t, 0x03
	call WriteEeprom
	adiw z, 1
	ldi t, 0x73
	call WriteEeprom
	adiw z, 1
	ldi t, 0xA0
	call WriteEeprom
	adiw z, 1

	ldi Counter, 5
eei6:	call Beep
	ldi yl, 0
	call wms
	dec Counter
	brne eei6


	;--- Usage warning ---

ShowUsageWarningAndDisclaimer:

	call LcdClear12x16

	lrv X1, 22				;warning
	ldz war1*2
	call PrintString

	lrv FontSelector, f6x8

	lrv X1, 0				;print the warning text
	lrv Y1, 17
	clr t

saf12:	push t
	ldz saf10*2
	call PrintFromStringArray
	lrv X1, 0
	rvadd Y1, 9
	pop t
	inc t
	cpi t, 4
	brne saf12

	;footer
	lrv X1, 0
	lrv Y1, 57
	ldz ok*2
	call PrintString

	call LcdUpdate

saf11:	call GetButtonsBlocking
	cpi t, 0x08				;OK?
	brne saf11

	call Beep
	call ReleaseButtons

	call LcdClear				;clear the display
	call LcdUpdate

	ldx 1000				;1 sec. delay
	call WaitXms


	;--- Disclaimer ---

	call LcdClear12x16

	lrv X1, 14				;reminder
	ldz eew1*2
	call PrintString

	lrv FontSelector, f6x8

	lrv X1, 0				;print disclaimer text
	lrv Y1, 17
	clr t

eew12:	push t
	ldz eew10*2
	call PrintFromStringArray
	lrv X1, 0
	rvadd Y1, 9
	pop t
	inc t
	cpi t, 4
	brne eew12

	;footer
	call PrintOkFooter

	call LcdUpdate

eew11:	call GetButtonsBlocking
	cpi t, 0x01				;OK?
	brne eew11

	ldz eeUserAccepted
	ser t
	call WriteEeprom

	call Beep
	call ReleaseButtons			;make sure buttons are released
	rvsetflagtrue Mode			;set flag to skip ESC calibration
	ret





eei4:	.dw 50,100,25,20
	.dw 50,100,25,20
	.dw 50,20,50,10


eei7:	.dw 30, 30, 50, 90


eew1:	.db 68, 60, 65, 63, 66, 59, 60, 68, 0, 0;the text "REMINDER" in the mangled 12x16 font

eew2:	.db "YOU USE THIS FIRMWARE", 0
eew3:	.db "AT YOUR OWN RISK!", 0
eew4:	.db "Read the instructions", 0
eew5:	.db "carefully.", 0, 0

eew10:	.dw eew2*2, eew3*2, eew4*2, eew5*2

saf2:	.db "SAFETY NOTICE: Do not", 0
saf3:	.db "use this firmware if", 0, 0
saf4:	.db "any button on your", 0, 0
saf5:	.db "KK2 board is damaged!", 0

saf10:	.dw saf2*2, saf3*2, saf4*2, saf5*2

.undef Counter
