
Logic:

	;--- Live update ---

	rvbrflagtrue flagArmed, liv1		;skip this section if armed	

	b16dec LiveUpdateTimer			;set flagLcdUpdate every second
	b16clr Temp
	b16cmp LiveUpdateTimer, Temp
	brge liv1

	rvsetflagtrue flagLcdUpdate
	b16ldi LiveUpdateTimer, 400

liv1:

	;--- Activate functions based on AUX switch position ---

	lds t, AuxSwitchPosition		;skip this section if the AUX switch position is unchanged
	lds xl, AuxSwitchPositionOld
	cp t, xl
	brne asp1

	rjmp asp20

asp1:	sts AuxSwitchPositionOld, t

	ldx AuxPos1Function			;calculate the address of the variable holding the function ID
	add xl, t
	brcc asp2

	inc xh

asp2:	clr t					;reset flags and values
	sts flagSlOn, t
	sts flagSlStickMixing, t
	sts flagAlarmOn, t

	ld t, x					;check the function ID
	tst t					;off?
	breq asp20

	cpi t, 5				;alarm?
	brne asp4

	rvsetflagtrue flagAlarmOn		;yes, set flag and re-initialize the delay counter
	ser t
	sts AuxBeepDelay, t
	rjmp asp20

asp4:	cpi t, 4				;normal SL?
	brne asp3

	rvsetflagtrue flagSlOn			;yes
	rjmp asp20

asp3:	ser xl					;SL Stick Mixing is active
	sts flagSlStickMixing, xl
	andi t, 3
	sts SlStickMixingMode, t
	cpi t, 1				;low?
	breq asp5

	cpi t, 3				;high?
	breq asp10

	b16ldi SelflevelPgainRate, 0.1		;neither, setting SL P-gain rate to MEDIUM
	rjmp asp20

asp5:	b16ldi SelflevelPgainRate, 0.05		;setting SL P-gain rate to LOW
	rjmp asp20

asp10:	b16ldi SelflevelPgainRate, 0.2		;setting SL P-gain rate to HIGH

asp20:


	;--- LED flashing in sync with the LVA beeps ---

	rvbrflagtrue flagLvaBuzzerOn, led2



	;--- Turn on LED if armed ---

	rvbrflagtrue flagArmed, led1

led2:	LedOff
	ret

led1:	LedOn
	ret

