
.def Item = r17

GimbalSettings:

	call LoadMixerTable		;display a warning if output type on M7/M8 is set to 'ESC'
	call UpdateOutputTypeAndRate
	lds t, OutputTypeBitmask
	andi t, 0xC0
	breq cam11

	rcall ShowEscWarning

cam11:	call LcdClear6x8

	ldz cam1*2			;roll gain
	call PrintString
	ldz eeCamRollGain
	rcall PrintCamStabValue

	ldz cam3*2			;pitch gain
	call PrintString
	ldz eeCamPitchGain
	rcall PrintCamStabValue

	ldz cam5*2			;mixing (none or differential)
	call PrintString
	lds t, CamServoMixing
	andi t, 0x01
	ldz mix*2
	call PrintFromStringArray

	;footer
	call PrintStdFooter

	;print selector
	ldzarray cam7*2, 4, Item
	call PrintSelector

	call LcdUpdate

	call GetButtonsBlocking

	cpi t, 0x08			;BACK?
	brne cam8
	ret	

cam8:	cpi t, 0x04			;PREV?
	brne cam9

	dec Item
	brpl cam10

	ldi Item, 2
cam10:	rjmp cam11	

cam9:	cpi t, 0x02			;NEXT?
	brne cam12

	inc Item
	cpi Item, 3
	brlt cam13

	clr Item
cam13:	rjmp cam11	

cam12:	cpi t, 0x01			;CHANGE?
	brne cam14

	cpi Item, 2			;change mixing mode?
	brne cam30

	;toggle mixing mode
	lds xl, CamServoMixing
	ser t
	eor xl, t
	sts CamServoMixing, xl
	ldz eeCamServoMixing
	call StoreEeVariable8
	rjmp cam11

	;edit selected gain value
cam30:	tst Item
	brne cam31

	ldz eeCamRollGain
	rjmp cam32

cam31:	ldz eeCamPitchGain
cam32:	pushz
	call GetEeVariable16
	ldy -32000			;lower limit
	ldz 32000			;upper limit
	call NumberEdit
	mov xl, r0
	mov xh, r1
	popz
	call StoreEeVariable16
cam14:	rjmp cam11



	;--- Print 16bit value and set cursor position ---

PrintCamStabValue:

	lrv X1, 72
	call GetEeVariable16
	call Print16Signed
	lrv X1, 0
	rvadd Y1, 9
	ret



	;--- ESC warning dialogue ---

ShowEscWarning:

	call LcdClear12x16

	lrv X1, 22			;warning
	ldz war1*2
	call PrintString

	lrv FontSelector, f6x8

	lrv X1, 0			;print warning text
	lrv Y1, 17
	clr t

sew12:	push t
	ldz sew10*2
	call PrintFromStringArray
	lrv X1, 0
	rvadd Y1, 9
	pop t
	inc t
	cpi t, 3
	brne sew12

	;footer
	call PrintOkFooter

	call LcdUpdate

sew11:	call GetButtonsBlocking
	cpi t, 0x01			;OK?
	brne sew11

	call Beep
	call ReleaseButtons
	ret




cam1:	.db "Roll gain : ", 0, 0
cam3:	.db "Pitch gain: ", 0, 0
cam5:	.db "Mixing    : ", 0, 0
cam5a:	.db "None", 0, 0
cam5b:	.db "Diff", 0, 0

mix:	.dw cam5a*2, cam5b*2


cam7:	.db 71, 0, 98, 9
	.db 71, 9, 98, 18
	.db 71, 18, 98, 27


sew1:	.db "Output type is set to", 0
sew2:	.db "ESC for M7 and/or M8.", 0
sew3:	.db "Check Mixer Editor.", 0

sew10:	.dw sew1*2, sew2*2, sew3*2


.undef Item






CameraStab:

	b16clr Temp					;gimbal will be deactivated if one of the gains are zero. This allow OCTOs to be used
	b16cmp CamRollGain, Temp
	brne cam23
	ret

cam23:	b16cmp CamPitchGain, Temp
	brne cam22
	ret

cam22:	lds t, TuningMode				;use center offset position when tuning mode is active
	tst t
	breq cam21

	b16clr RxAux2
	b16clr RxAux3

cam21:	b16ldi Temp, 100.0				;utilize the full input range.by adding 100 and dividing by 2
	b16add RxAux2, RxAux2, Temp
	b16add RxAux3, RxAux3, Temp

	b16ldi Temp, 22.2				; = 44.4 / 2  (modified to utilize the full input range)
	b16mul CamRollOffset, RxAux2, Temp
	b16mul CamPitchOffset, RxAux3, Temp

	b16mul CamRoll, EulerAngleRoll, CamRollGain	;calculate camera angles
	b16mul CamPitch, EulerAnglePitch, CamPitchGain

	rvbrflagtrue CamServoMixing, cam20
	rjmp cam24					;jump for regular output

cam20:	b16mov Temp, CamRoll				;differential mixing
	b16sub CamRoll, CamRoll, CamPitch
	b16add CamPitch, CamPitch, Temp

	b16mov Temp, CamRollOffset
	b16sub CamRollOffset, CamRollOffset, CamPitchOffset
	b16add CamPitchOffset, CamPitchOffset, Temp

	b16ldi Temp, 2220.0				; = 1000 * 2.22 (compensate for differential offset)
	b16add CamRollOffset, CamRollOffset, Temp
	b16sub CamPitchOffset, CamPitchOffset, Temp

cam24:	b16add Out7, CamRoll, CamRollOffset		;outputs will be set only when FC is armed and throttle is applied
	b16add Out8, CamPitch, CamPitchOffset

	b16mov Offset7, Out7				;makes it possible to adjust the gimbal in 'SAFE' mode also
	b16mov Offset8, Out8				;(offset is used in 'SAFE' mode and in 'ARMED' mode until throttle is applied)
	ret
