
.def Counter	=r17

LoadMixer:

loa13:	ldy loa1 * 2

	lds xl, LoadMenuListYposSave
	lds xh, LoadMenuCursorYposSave

	ldi t, 19		;menu items (i.e. motor layouts)
	call Menu

	sts LoadMenuListYposSave, yl
	sts LoadMenuCursorYposSave, yh

	brcs loa22		;BACK pressed?
	ret			;Yes, return


loa22:	call ShowConfirmationDlg

	cpi t, 0x01		;YES?
	breq loa18

	rjmp loa13		;CANCEL was pressed


loa18:	BuzzerOn

	ldzarray mod0 * 2, 64, xl
	movw X, Z
	ldy eeMixerTable
	ldi Counter, 64
	
loa19:	movw Z, X		;copy mixertable to EEPROM
	lpm t, Z
	movw Z, Y
	call WriteEeprom
	adiw X, 1
	adiw Y, 1
	dec Counter
	brne loa19

	setflagtrue xl		;set flag to indicate that a motor layout has been selected
	ldz eeMotorLayoutOK
	call StoreEeVariable8
	
	BuzzerOff		
	
	call FlightInit		;update RAM with new table

	call MotorLayout

	rjmp loa13

.undef Counter



loa1:	.db "SingleCopter 2M 2S  "
	.db "SingleCopter 1M 4S  "
	.db "DualCopter          "
	.db "TriCopter           "
	.db "QuadroCopter x mode "
	.db "QuadroCopter + mode "
	.db "V-Tail              "
	.db "Y4                  "
	.db "HexaCopter   x mode "
	.db "HexaCopter   + mode "
	.db "H6                  "
	.db "V6                  "
	.db "Y6                  "
	.db "OctoCopter   x mode "
	.db "OctoCopter   + mode "
	.db "H8                  "
	.db "V8                  "
	.db "X8           x mode "
	.db "X8           + mode "




mod0:
	;    thr roll pitch yaw offs flags unused			SingleCopter 2M 2S
	.db  100, 0  , 0  , 100, 0  , 3  , 0  , 0	;m1
	.db  100, 0  , 0  ,-100, 0  , 3  , 0  , 0	;m2
	.db  0  , 100, 0  , 0  , 50 , 0  , 0  , 0	;m3
	.db  0  , 0  , 100, 0  , 50 , 0  , 0  , 0	;m4
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m5
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			SingleCopter 1M 4S
	.db  100, 0  , 0  , 0  , 0  , 3  , 0  , 0	;m1
	.db  0  , 100, 0  , 100, 50 , 0  , 0  , 0	;m2
	.db  0  , 0  , 100, 100, 50 , 0  , 0  , 0	;m3
	.db  0  ,-100, 0  , 100, 50 , 0  , 0  , 0	;m4
	.db  0  , 0  ,-100, 100, 50 , 0  , 0  , 0	;m5
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			DualCopter
	.db  100, 100, 0  , -1 , 0  , 3  , 0  , 0	;m1
	.db  100,-100, 0  , 0  , 0  , 3  , 0  , 0	;m2
	.db  0  , 0  , 100, 100, 0  , 0  , 0  , 0	;m3
	.db  0  , 0  ,-100, 100, 0  , 0  , 0  , 0	;m4
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m5
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			TriCopter
	.db  100,-87 , 50 , 0  , 0  , 3  , 0  , 0	;m1
	.db  100, 87 , 50 ,-1  , 0  , 3  , 0  , 0	;m2
	.db  100, 0  ,-100, 0  , 0  , 3  , 0  , 0	;m3
	.db  0  , 0  , 0  , 100, 50 , 0  , 0  , 0	;m4
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m5
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			QuadroCopter x mode
	.db  100,-71 , 71 , 100, 0  , 3  , 0  , 0	;m1
	.db  100, 71 , 71 ,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 71 ,-71 , 100, 0  , 3  , 0  , 0	;m3
	.db  100,-71 ,-71 ,-100, 0  , 3  , 0  , 0	;m4
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m5
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			QuadroCopter + mode
	.db  100, 0  , 100, 100, 0  , 3  , 0  , 0	;m1
	.db  100, 100, 0  ,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 0  ,-100, 100, 0  , 3  , 0  , 0	;m3
	.db  100,-100, 0  ,-100, 0  , 3  , 0  , 0	;m4
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m5
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			V-Tail
	.db  100,-71 , 71 , 0  , 0  , 3  , 0  , 0	;m1
	.db  100, 71 , 71 ,-1  , 0  , 3  , 0  , 0	;m2
	.db  120, 0  ,-90 , 100, 0  , 3  , 0  , 0	;m3
	.db  120, 0  ,-90 ,-100, 0  , 3  , 0  , 0	;m4
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m5
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			Y4
	.db  100,-71 , 71 , 100, 0  , 3  , 0  , 0	;m1
	.db  100, 71 , 71 ,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 0  ,-100, 100, 0  , 3  , 0  , 0	;m3
	.db  100, 0  ,-100,-100, 0  , 3  , 0  , 0	;m4
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m5
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			HexaCopter x mode
	.db  100, 50 , 87 , 100, 0  , 3  , 0  , 0	;m1
	.db  100, 100, 0  ,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 50 ,-87 , 100, 0  , 3  , 0  , 0	;m3
	.db  100,-50 ,-87 ,-100, 0  , 3  , 0  , 0	;m4
	.db  100,-100, 0  , 100, 0  , 3  , 0  , 0	;m5
	.db  100,-50 , 87 ,-100, 0  , 3  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			HexaCopter + mode
	.db  100, 0  , 100, 100, 0  , 3  , 0  , 0	;m1
	.db  100, 87 , 50 ,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 87 ,-50 , 100, 0  , 3  , 0  , 0	;m3
	.db  100, 0  ,-100,-100, 0  , 3  , 0  , 0	;m4
	.db  100,-87 ,-50 , 100, 0  , 3  , 0  , 0	;m5
	.db  100,-87 , 50 ,-100, 0  , 3  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			H6
	.db  100, 71 , 71 , 100, 0  , 3  , 0  , 0	;m1
	.db  100, 71 , 0  ,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 71 ,-71 , 100, 0  , 3  , 0  , 0	;m3
	.db  100,-71 ,-71 ,-100, 0  , 3  , 0  , 0	;m4
	.db  100,-71 , 0  , 100, 0  , 3  , 0  , 0	;m5
	.db  100,-71 , 71 ,-100, 0  , 3  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			V6
	.db  100, 100, 71 , 100, 0  , 3  , 0  , 0	;m1
	.db  100, 71 , 0  ,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 42 ,-71 , 100, 0  , 3  , 0  , 0	;m3
	.db  100,-42 ,-71 ,-100, 0  , 3  , 0  , 0	;m4
	.db  100,-71 , 0  , 100, 0  , 3  , 0  , 0	;m5
	.db  100,-100, 71 ,-100, 0  , 3  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			Y6
	.db  100,-87 , 50 , 100, 0  , 3  , 0  , 0	;m1
	.db  100,-87 , 50 ,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 87 , 50 , 100, 0  , 3  , 0  , 0	;m3
	.db  100, 87 , 50 ,-100, 0  , 3  , 0  , 0	;m4
	.db  100, 0  ,-100, 100, 0  , 3  , 0  , 0	;m5
	.db  100, 0  ,-100,-100, 0  , 3  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			OctoCopter x mode
	.db  100, 38 , 92 , 100, 0  , 3  , 0  , 0	;m1
	.db  100, 92 , 38 ,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 92 ,-38 , 100, 0  , 3  , 0  , 0	;m3
	.db  100, 38 ,-92 ,-100, 0  , 3  , 0  , 0	;m4
	.db  100,-38 ,-92 , 100, 0  , 3  , 0  , 0	;m5
	.db  100,-92 ,-38 ,-100, 0  , 3  , 0  , 0	;m6
	.db  100,-92 , 38 , 100, 0  , 3  , 0  , 0	;m7
	.db  100,-38 , 92 ,-100, 0  , 3  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			OctoCopter + mode
	.db  100, 0  , 100, 100, 0  , 3  , 0  , 0	;m1
	.db  100, 71 , 71 ,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 100, 0  , 100, 0  , 3  , 0  , 0	;m3
	.db  100, 71 ,-71 ,-100, 0  , 3  , 0  , 0	;m4
	.db  100, 0  ,-100, 100, 0  , 3  , 0  , 0	;m5
	.db  100,-71 ,-71 ,-100, 0  , 3  , 0  , 0	;m6
	.db  100,-100, 0  , 100, 0  , 3  , 0  , 0	;m7
	.db  100,-71 , 71 ,-100, 0  , 3  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			H8
	.db  100, 71 , 71 , 100, 0  , 3  , 0  , 0	;m1
	.db  100, 71 , 24 ,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 71 ,-24 , 100, 0  , 3  , 0  , 0	;m3
	.db  100, 71 ,-71 ,-100, 0  , 3  , 0  , 0	;m4
	.db  100,-71 ,-71 , 100, 0  , 3  , 0  , 0	;m5
	.db  100,-71 ,-24 ,-100, 0  , 3  , 0  , 0	;m6
	.db  100,-71 , 24 , 100, 0  , 3  , 0  , 0	;m7
	.db  100,-71 , 71 ,-100, 0  , 3  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			V8
	.db  100, 100, 71 , 100, 0  , 3  , 0  , 0	;m1
	.db  100, 81 , 24 ,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 61 ,-24 , 100, 0  , 3  , 0  , 0	;m3
	.db  100, 42 ,-71 ,-100, 0  , 3  , 0  , 0	;m4
	.db  100,-42 ,-71 , 100, 0  , 3  , 0  , 0	;m5
	.db  100,-61 ,-24 ,-100, 0  , 3  , 0  , 0	;m6
	.db  100,-81 , 24 , 100, 0  , 3  , 0  , 0	;m7
	.db  100,-100, 71 ,-100, 0  , 3  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			X8 x mode
	.db  100,-71 , 71 , 100, 0  , 3  , 0  , 0	;m1
	.db  100,-71 , 71 ,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 71 , 71 , 100, 0  , 3  , 0  , 0	;m3
	.db  100, 71 , 71 ,-100, 0  , 3  , 0  , 0	;m4
	.db  100, 71 ,-71 , 100, 0  , 3  , 0  , 0	;m5
	.db  100, 71 ,-71 ,-100, 0  , 3  , 0  , 0	;m6
	.db  100,-71 ,-71 , 100, 0  , 3  , 0  , 0	;m7
	.db  100,-71 ,-71 ,-100, 0  , 3  , 0  , 0	;m8

	;    thr roll pitch yaw offs flags unused			X8 + mode
	.db  100, 0  , 100, 100, 0  , 3  , 0  , 0	;m1
	.db  100, 0  , 100,-100, 0  , 3  , 0  , 0	;m2
	.db  100, 100, 0  , 100, 0  , 3  , 0  , 0	;m3
	.db  100, 100, 0  ,-100, 0  , 3  , 0  , 0	;m4
	.db  100, 0  ,-100, 100, 0  , 3  , 0  , 0	;m5
	.db  100, 0  ,-100,-100, 0  , 3  , 0  , 0	;m6
	.db  100,-100, 0  , 100, 0  , 3  , 0  , 0	;m7
	.db  100,-100, 0  ,-100, 0  , 3  , 0  , 0	;m8
/*
	;    thr roll pitch yaw offs flags unused
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m1
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m2
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m3
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m4
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m5
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m6
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m7
	.db  0  , 0  , 0  , 0  , 0  , 0  , 0  , 0	;m8

*/


