/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui;

import avr8_burn_o_mat.AVR;
import avr8_burn_o_mat.AvrdudeProgrammer;
import avr8_burn_o_mat.InterfaceTextOutput;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.utils.ArduinoUpload;
import de.lazyzero.kkMulticopterFlashTool.utils.Firmware;
import de.lazyzero.kkMulticopterFlashTool.utils.PortScanner;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import lu.tudor.santec.i18n.Translatrix;

public class ArduinoUSBLinkerUploader {
    public static final String ARDUINO = "arduino";
    private static final String ATMEGA328p = "ATmega328p";
    private static final String ATMEGA168 = "atmega168";
    private static final String ATMEGA328p_CAPTION = "m328p";
    private static final String ATMEGA168_CAPTION = "m168";
    private static Logger logger = KKMulticopterFlashTool.getLogger();
    private LinkedHashMap<String, ArduinoUpload> arduinos = new LinkedHashMap();
    private String arduinoPort = "";
    private Firmware firmware;
    private KKMulticopterFlashTool kkflashtool;
    private InterfaceTextOutput textOutput;

    public ArduinoUSBLinkerUploader(KKMulticopterFlashTool parent) {
        this.kkflashtool = parent;
        this.textOutput = parent;
        this.init();
    }

    private void init() {
        for (Firmware firmware : this.kkflashtool.getFirmwares()) {
            if (!firmware.getController().equals(ARDUINO.toLowerCase())) continue;
            this.firmware = firmware;
            break;
        }
        this.arduinos.put("Arduino Uno", new ArduinoUpload("Arduino Uno", new AVR(ARDUINO, ATMEGA328p_CAPTION), new AvrdudeProgrammer(ARDUINO, ARDUINO, ""), 115200));
        this.arduinos.put("Arduino Duemilanove w/ ATmega328", new ArduinoUpload("Arduino Duemilanove w/ ATmega328", new AVR(ARDUINO, ATMEGA328p_CAPTION), new AvrdudeProgrammer(ARDUINO, ARDUINO, ""), 57600));
        this.arduinos.put("Arduino Diecimila or Duemilanove w/ ATmega168", new ArduinoUpload("Arduino Diecimila or Duemilanove w/ ATmega168", new AVR(ATMEGA168, ATMEGA168_CAPTION), new AvrdudeProgrammer(ARDUINO, ARDUINO, ""), 19200));
        this.arduinos.put("Arduino Nano w/ ATmega328", new ArduinoUpload("Arduino Nano w/ ATmega328", new AVR(ATMEGA328p, ATMEGA328p_CAPTION), new AvrdudeProgrammer(ARDUINO, ARDUINO, ""), 57600));
        this.arduinos.put("Arduino Nano w/ ATmega168", new ArduinoUpload("Arduino Nano w/ ATmega168", new AVR(ATMEGA168, ATMEGA168_CAPTION), new AvrdudeProgrammer(ARDUINO, ARDUINO, ""), 19200));
        this.arduinos.put("Arduino Mini w/ ATmega328", new ArduinoUpload("Arduino Mini w/ ATmega328", new AVR(ATMEGA328p, ATMEGA328p_CAPTION), new AvrdudeProgrammer(ARDUINO, ARDUINO, ""), 115200));
        this.arduinos.put("Arduino Mini w/ ATmega168", new ArduinoUpload("Arduino Mini w/ ATmega168", new AVR(ATMEGA168, ATMEGA168_CAPTION), new AvrdudeProgrammer(ARDUINO, ARDUINO, ""), 19200));
        this.arduinos.put("Arduino Pro or Pro Mini w/ ATmega328", new ArduinoUpload("Arduino Pro or Pro Mini w/ ATmega328", new AVR(ATMEGA328p, ATMEGA328p_CAPTION), new AvrdudeProgrammer(ARDUINO, ARDUINO, ""), 115200));
        this.arduinos.put("Arduino Pro or Pro Mini w/ ATmega168", new ArduinoUpload("Arduino Pro or Pro Mini w/ ATmega168", new AVR(ATMEGA168, ATMEGA168_CAPTION), new AvrdudeProgrammer(ARDUINO, ARDUINO, ""), 19200));
    }

    public Iterator<String> getArduinos() {
        return this.arduinos.keySet().iterator();
    }

    public void upload(String name) {
        ArduinoUpload uploader = this.arduinos.get(name);
        logger.info("Flash ArduinoUSBLinker to " + name);
        logger.info(uploader.toString());
        this.textOutput.clearText();
        if (this.detectArduino()) {
            logger.info("now flash the ArduinoUSBLinker hex to the detected Arduino.");
            logger.info("firmware" + this.firmware);
            this.textOutput.println(Translatrix._("arduinousblinker.logAutodetect"));
            this.textOutput.println(String.valueOf(Translatrix._("port")) + ": " + this.arduinoPort);
            this.textOutput.print(String.valueOf(Translatrix._("firmware")) + ": " + this.firmware.getName() + " " + Translatrix._("by") + " ");
            this.textOutput.println(String.valueOf(Translatrix._("author")) + ": " + this.firmware.getAuthor());
            this.kkflashtool.flashArduino(this.arduinos.get(name), this.firmware, this.arduinoPort);
        } else {
            logger.warning("No Arduino connected during search phase.");
            this.textOutput.err(Translatrix._("arduinousblinker.LogNoArduinoConnected"));
            JOptionPane.showMessageDialog(null, Translatrix._("arduinousblinker.noArduinoConnected"));
        }
    }

    private boolean detectArduino() {
        boolean arduinoDetected = false;
        Vector<String> availablePorts = PortScanner.listSerialPorts();
        JOptionPane.showMessageDialog(null, Translatrix._("arduinousblinker.connectArduino"));
        Vector<String> newPorts = PortScanner.listSerialPorts();
        for (String port : newPorts) {
            if (availablePorts.contains(port)) continue;
            JOptionPane.showMessageDialog(null, String.valueOf(Translatrix._("arduinousblinker.arduinoDetected")) + " " + port);
            this.arduinoPort = port;
            arduinoDetected = true;
            return arduinoDetected;
        }
        return arduinoDetected;
    }
}

