/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEprom;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEpromListener;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import lu.tudor.santec.i18n.Translatrix;

public class EEpromResetPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
EEpromListener {
    private static final long serialVersionUID = 1L;
    private KKMulticopterFlashTool parent;
    private CellConstraints cc;
    private Logger logger = KKMulticopterFlashTool.getLogger();
    private EEprom eeprom;
    private JLabel warning;
    private JButton resetButton;

    public EEpromResetPanel(KKMulticopterFlashTool parent) {
        this.parent = parent;
        this.init();
        this.addPropertyChangeListener(this);
    }

    private void init() {
        this.cc = new CellConstraints();
        String panelColumns = "3dlu,fill:pref:grow,3dlu,pref,3dlu";
        String panelRows = "pref";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.setBorder(new TitledBorder(Translatrix._("EEpromResetPanel.title")));
        this.warning = new JLabel(Translatrix._("EEpromResetPanel.warning"));
        this.resetButton = new JButton(Translatrix._("EEpromResetPanel.resetButton"));
        this.resetButton.addActionListener(this);
        this.add((Component)this.warning, this.cc.xy(2, 1));
        this.add((Component)this.resetButton, this.cc.xy(4, 1));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("controllerChanged")) {
            this.eeprom = new EEprom(this.parent.getController().getEepromSize());
            this.logger.info("EEprom size set to: " + this.parent.getController().getEepromSize());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.resetButton)) {
            this.logger.info("RESET the EEprom!!!");
            this.parent.clearText();
            this.eeprom.writeRawEEprom();
            this.parent.flashEEprom(this);
        }
    }

    public static void main(String[] args) {
    }

    @Override
    public void EEpromState(int state) {
        if (state < 0) {
            this.parent.setSelectedTabIndex(0);
        }
    }
}

