/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.EEpromFirmwareSettings;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.FirmwareSettings.KKQuadSettings;
import de.lazyzero.kkMulticopterFlashTool.utils.Icons;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import lu.tudor.santec.i18n.Translatrix;

public class EEpromSettingsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private CellConstraints cc;
    private JButton load;
    private JButton save;
    private JComboBox firmwares;
    private KKMulticopterFlashTool parent;
    private JPanel settings;

    public EEpromSettingsPanel(KKMulticopterFlashTool parent) {
        this.parent = parent;
        this.initGUI(0);
    }

    private void initGUI(int selectionIndex) {
        this.cc = new CellConstraints();
        String panelColumns = "3dlu,fill:pref:grow,3dlu,pref,3dlu";
        String panelRows = "3dlu,pref,3dlu,pref,3dlu,top:122dlu,3dlu,pref,3dlu";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.setBorder(new TitledBorder(Translatrix._("EEPromSettingsPanel.title")));
        this.firmwares = new JComboBox();
        this.firmwares.addItem(Translatrix._("EEPromSettingsPanel.makeSelection"));
        this.firmwares.addItem(new KKQuadSettings(this.parent));
        this.firmwares.setSelectedIndex(selectionIndex);
        this.firmwares.addActionListener(this);
        this.load = new JButton(Translatrix._("EEPromSettingsPanel.load"), Icons.getIcon16("kcmmemory.png"));
        this.load.setEnabled(false);
        this.load.addActionListener(this);
        this.save = new JButton(Translatrix._("EEPromSettingsPanel.save"), Icons.getIcon16("runit.png"));
        this.save.setEnabled(false);
        this.save.addActionListener(this);
        this.add((Component)new JLabel(Translatrix._("EEPromSettingsPanel.warning"), Icons.getIcon48("error.png"), 0), this.cc.xyw(2, 2, 3));
        this.add((Component)this.firmwares, this.cc.xy(2, 4));
        this.add((Component)this.load, this.cc.xy(4, 4));
        this.add((Component)this.save, this.cc.xy(4, 8));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean hasSettingsLoaded = false;
        if (e.getSource().equals(this.load)) {
            if (this.firmwares.getSelectedIndex() > 0) {
                this.settings = null;
                this.removeAll();
                this.initGUI(this.firmwares.getSelectedIndex());
                this.settings = ((EEpromFirmwareSettings)this.firmwares.getSelectedItem()).getPanel();
                hasSettingsLoaded = ((EEpromFirmwareSettings)this.firmwares.getSelectedItem()).hasSettingsLoaded();
                this.add((Component)this.settings, this.cc.xyw(2, 6, 3));
                this.validate();
                if (hasSettingsLoaded) {
                    this.save.setEnabled(true);
                }
                this.load.setEnabled(true);
            } else {
                this.save.setEnabled(false);
                this.load.setEnabled(true);
            }
        } else if (e.getSource().equals(this.save)) {
            ((EEpromFirmwareSettings)this.firmwares.getSelectedItem()).flashSettings();
        } else if (e.getSource().equals(this.firmwares)) {
            if (this.firmwares.getSelectedIndex() > 0) {
                this.load.setEnabled(true);
            } else {
                this.load.setEnabled(false);
            }
        }
    }
}

