/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.utils.Firmware;
import de.lazyzero.kkMulticopterFlashTool.utils.download.Download;
import de.lazyzero.kkMulticopterFlashTool.utils.download.DownloadsTableModel;
import de.lazyzero.kkMulticopterFlashTool.utils.download.ProgressRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lu.tudor.santec.i18n.Translatrix;
import org.concord.swing.SpringUtilities;

public class FirmwareDownloadFrame
extends JDialog
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private Vector<Firmware> firmwares;
    private JPanel panel;
    private CellConstraints cc;
    private Dimension preferredSize = new Dimension(450, 550);
    private DownloadsTableModel downloadTableModel;
    private JTable table;
    private JPanel downloadsPanel;
    private JButton closeButton;
    private JButton downloadButton;
    private HashMap<String, Boolean> firmwareTyps;

    public FirmwareDownloadFrame(Vector<Firmware> firmwares) {
        this.firmwares = firmwares;
        this.initGUI();
        this.pack();
        this.setModal(true);
        this.setVisible(true);
    }

    private void initGUI() {
        this.panel = new JPanel();
        this.cc = new CellConstraints();
        String panelColumns = "3dlu,fill:pref:grow,3dlu,pref,3dlu,pref,3dlu";
        String panelRows = "3dlu,pref:grow,3dlu,fill:pref,3dlu,pref,3dlu";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.panel.setLayout((LayoutManager)panelLayout);
        this.downloadTableModel = new DownloadsTableModel();
        this.table = new JTable(this.downloadTableModel);
        ProgressRenderer renderer = new ProgressRenderer(0, 100);
        renderer.setStringPainted(true);
        this.table.setDefaultRenderer(JProgressBar.class, renderer);
        this.table.setForeground(Color.WHITE);
        this.table.setRowHeight((int)renderer.getPreferredSize().getHeight());
        this.downloadsPanel = new JPanel();
        this.downloadsPanel.setPreferredSize(new Dimension(this.preferredSize.width, 200));
        this.downloadsPanel.setBorder(BorderFactory.createTitledBorder(Translatrix._("downloads.downloads")));
        this.downloadsPanel.setLayout(new BorderLayout());
        this.downloadsPanel.add((Component)new JScrollPane(this.table), "Center");
        this.closeButton = new JButton(Translatrix._("close"));
        this.closeButton.addActionListener(this);
        this.downloadButton = new JButton(Translatrix._("downloads.download"));
        this.downloadButton.addActionListener(this);
        this.panel.add((Component)this.getFirmwareTypePanel(), this.cc.xyw(2, 2, 5));
        this.panel.add((Component)this.downloadsPanel, this.cc.xyw(2, 4, 5));
        this.panel.add((Component)this.downloadButton, this.cc.xy(4, 6));
        this.panel.add((Component)this.closeButton, this.cc.xy(6, 6));
        JScrollPane scrollPane = new JScrollPane(this.panel);
        this.add((Component)scrollPane, "Center");
        this.setTitle(Translatrix._("downloads.title"));
    }

    private JPanel getFirmwareTypePanel() {
        JPanel ftp = new JPanel();
        SpringLayout sl = new SpringLayout();
        ftp.setLayout(sl);
        ftp.setBorder(new TitledBorder(Translatrix._("firmware")));
        this.firmwareTyps = Firmware.getCategoriesBooleanHashMap(this.firmwares);
        TreeSet<String> sortedset = new TreeSet<String>(this.firmwareTyps.keySet());
        for (String type : sortedset) {
            JCheckBox cb = new JCheckBox(type);
            cb.setSelected(this.firmwareTyps.get(type));
            cb.addChangeListener(this);
            ftp.add(cb);
        }
        SpringUtilities.makeCompactGrid(ftp, this.firmwareTyps.size() / 4, 4, 2, 2, 2, 2);
        return ftp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.closeButton)) {
            this.dispose();
        }
        if (e.getSource().equals(this.downloadButton)) {
            this.downloadTableModel.clearAllDownloads();
            Vector<URL> downloadedURLs = new Vector<URL>();
            this.table.setModel(this.downloadTableModel);
            this.downloadsPanel.repaint();
            for (String type : this.firmwareTyps.keySet()) {
                int i = 0;
                while (i < this.firmwares.size()) {
                    if (this.firmwares.get(i).getName().equals(type) && this.firmwareTyps.get(type).booleanValue() && !downloadedURLs.contains(this.firmwares.get(i).getFileURL())) {
                        this.downloadTableModel.addDownload(new Download(this.firmwares.get(i).getZipURL() != null ? this.firmwares.get(i).getZipURL() : this.firmwares.get(i).getFileURL()));
                        downloadedURLs.add(this.firmwares.get(i).getFileURL());
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.firmwareTyps.containsKey(((JCheckBox)e.getSource()).getText())) {
            this.firmwareTyps.put(((JCheckBox)e.getSource()).getText(), ((JCheckBox)e.getSource()).isSelected());
        }
    }
}

