/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui;

import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitedTextArea
extends JTextArea {
    private static final long serialVersionUID = 1L;
    private int limit = 1000;

    public LimitedTextArea(int limit) {
        this.limit = limit;
        this.setLineWrap(true);
        this.init();
    }

    public LimitedTextArea(String text, int limit) {
        this.limit = limit;
        this.setText(text);
        this.setLineWrap(true);
        this.init();
    }

    private void init() {
        this.setDocument(new LimitValidation());
    }

    public class LimitValidation
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (this.getLength() + str.length() <= LimitedTextArea.this.limit) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

