/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui;

import avr8_burn_o_mat.AvrdudeProgrammer;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.gui.MultiFlashConfigDialog;
import de.lazyzero.kkMulticopterFlashTool.utils.MultiFlashSettings;
import de.lazyzero.kkMulticopterFlashTool.utils.PortScanner;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import lu.tudor.santec.i18n.Translatrix;

public class ProgrammerPanel
extends JPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    public static final String PROGRAMMER_CHANGED = "PROGRAMMER_CHANGED";
    private JComboBox programmerCombobox;
    private AvrdudeProgrammer programmer;
    private Vector<AvrdudeProgrammer> programmers;
    private String port;
    private String rate;
    private KKMulticopterFlashTool parent;
    private CellConstraints cc;
    private JLabel programmerLabel;
    private JLabel portLabel;
    private JComboBox portComboBox;
    private JTextField baudRateTextField;
    private JLabel baudRateLabel;
    private JCheckBox baudRateChangeCB;
    private JCheckBox multiFlashCB;
    private Vector<String> availablePorts;
    private JButton multiFlashButton;
    private boolean multiFlash = false;
    private MultiFlashSettings mfs;

    public ProgrammerPanel(KKMulticopterFlashTool parent, Vector<AvrdudeProgrammer> programmers) {
        this.parent = parent;
        this.programmers = programmers;
        this.init();
    }

    private void init() {
        this.mfs = new MultiFlashSettings();
        this.cc = new CellConstraints();
        String panelColumns = "pref,3dlu,80dlu,3dlu,pref,3dlu,50dlu,3dlu,pref,fill:pref:grow,3dlu,pref";
        String panelRows = "pref,3dlu,pref";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.setBorder(new TitledBorder(Translatrix._("programmer.settings")));
        this.programmerLabel = new JLabel(Translatrix._("programmer"));
        this.programmerCombobox = new JComboBox<AvrdudeProgrammer>(this.programmers);
        if (this.programmer != null) {
            this.programmerCombobox.setSelectedItem(this.programmer);
        } else {
            this.programmerCombobox.setSelectedIndex(0);
            this.programmer = (AvrdudeProgrammer)this.programmerCombobox.getSelectedItem();
            this.parent.setProgrammer(this.programmer);
        }
        this.programmerCombobox.addActionListener(this);
        this.portLabel = new JLabel(Translatrix._("port"));
        this.availablePorts = PortScanner.listProgrammerPorts();
        this.portComboBox = new JComboBox<String>(this.availablePorts);
        this.updateSerialPorts();
        this.portComboBox.addActionListener(this);
        this.baudRateChangeCB = new JCheckBox(Translatrix._("port.enableRate"), true);
        this.baudRateChangeCB.addActionListener(this);
        this.baudRateLabel = new JLabel(Translatrix._("port.rate"));
        this.baudRateTextField = new JTextField(this.rate);
        this.baudRateTextField.addFocusListener(this);
        if (!this.baudRateChangeCB.isSelected() && this.baudRateChangeCB.isEnabled()) {
            this.baudRateTextField.setEnabled(true);
        } else {
            this.baudRateTextField.setEnabled(false);
        }
        this.multiFlashCB = new JCheckBox(Translatrix._("multiflash.enable"), false);
        this.multiFlashCB.addActionListener(this);
        this.multiFlashButton = new JButton(Translatrix._("multiflash.configure"));
        this.multiFlashButton.addActionListener(this);
        this.multiFlashButton.setEnabled(false);
        this.add((Component)this.programmerLabel, this.cc.xy(1, 1));
        this.add((Component)this.programmerCombobox, this.cc.xyw(3, 1, 10));
        this.add((Component)this.portLabel, this.cc.xy(1, 3));
        this.add((Component)this.portComboBox, this.cc.xy(3, 3));
        this.add((Component)this.baudRateLabel, this.cc.xy(5, 3));
        this.add((Component)this.baudRateTextField, this.cc.xy(7, 3));
        this.add((Component)this.baudRateChangeCB, this.cc.xy(9, 3));
        this.add((Component)this.multiFlashCB, this.cc.xy(10, 3));
        this.add((Component)this.multiFlashButton, this.cc.xy(12, 3));
    }

    private void updateSerialPorts() {
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    String selectedItem = (String)ProgrammerPanel.this.portComboBox.getSelectedItem();
                    Vector<String> list = PortScanner.listProgrammerPorts();
                    for (String port : list) {
                        if (ProgrammerPanel.this.availablePorts.contains(port)) continue;
                        System.out.println("add port to list: " + port);
                        ProgrammerPanel.this.availablePorts.add(port);
                        ProgrammerPanel.this.portComboBox.setModel(new DefaultComboBoxModel(ProgrammerPanel.this.availablePorts));
                        ProgrammerPanel.this.portComboBox.setSelectedItem(selectedItem);
                    }
                    try {
                        1.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        t.start();
    }

    private void openMultiFlashConfigDialog() {
        MultiFlashConfigDialog mfd = new MultiFlashConfigDialog(this.mfs);
        mfd.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        mfd.setVisible(true);
    }

    public JPanel getPanel() {
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getSource().equals(this.programmerCombobox)) {
            this.programmer = (AvrdudeProgrammer)this.programmerCombobox.getSelectedItem();
            this.parent.setProgrammer(this.programmer);
            this.parent.firePropertyChange(PROGRAMMER_CHANGED, 0L, 1L);
            System.out.println("Programmer switched to: " + this.programmer.getType());
            System.out.println(this.programmer.getId());
            System.out.println(this.programmer.getType());
            System.out.println(this.programmer.getDesc());
            if (this.programmer.getId().equals("arduinousblinker")) {
                this.multiFlashCB.setEnabled(true);
                this.multiFlashButton.setEnabled(this.multiFlashCB.isSelected());
                this.setMultiFlash(this.multiFlashCB.isSelected());
            } else {
                this.multiFlashButton.setEnabled(false);
                this.multiFlashCB.setEnabled(false);
                this.setMultiFlash(false);
            }
        } else if (action.getSource().equals(this.baudRateChangeCB)) {
            if (!this.baudRateChangeCB.isSelected() && this.baudRateChangeCB.isEnabled()) {
                this.baudRateTextField.setEnabled(true);
            } else {
                this.baudRateTextField.setEnabled(false);
            }
        } else if (action.getSource().equals(this.portComboBox)) {
            this.port = (String)this.portComboBox.getSelectedItem();
            if (!this.port.equals("usb")) {
                this.baudRateChangeCB.setEnabled(true);
            } else {
                this.baudRateChangeCB.setEnabled(false);
            }
            if (!this.baudRateChangeCB.isSelected() && this.baudRateChangeCB.isEnabled()) {
                this.baudRateTextField.setEnabled(true);
            } else {
                this.baudRateTextField.setEnabled(false);
            }
            System.out.println("port is now: " + this.port);
        } else if (action.getSource().equals(this.multiFlashCB)) {
            this.multiFlashButton.setEnabled(this.multiFlashCB.isSelected());
            this.setMultiFlash(this.multiFlashCB.isSelected());
        } else if (action.getSource().equals(this.multiFlashButton)) {
            this.openMultiFlashConfigDialog();
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent focus) {
        if (focus.getSource().equals(this.portComboBox)) {
            this.port = (String)this.portComboBox.getSelectedItem();
            if (!this.port.equals("usb")) {
                this.baudRateChangeCB.setEnabled(true);
            } else {
                this.baudRateChangeCB.setEnabled(false);
            }
            if (!this.baudRateChangeCB.isSelected() && this.baudRateChangeCB.isEnabled()) {
                this.baudRateTextField.setEnabled(true);
            } else {
                this.baudRateTextField.setEnabled(false);
            }
            System.out.println("port is now: " + this.port);
        } else if (focus.getSource().equals(this.baudRateTextField)) {
            this.rate = this.baudRateTextField.getText();
            System.out.println("rate is now: " + this.rate);
        }
    }

    public void setPort(String port) {
        this.port = port.trim();
        this.portComboBox.setSelectedItem(port);
        if (!port.equals("usb")) {
            this.baudRateChangeCB.setEnabled(true);
        } else {
            this.baudRateChangeCB.setEnabled(false);
        }
        System.out.println("Port is set to: " + port);
    }

    public String getPort() {
        return this.port;
    }

    public void setRate(String rate) {
        this.rate = rate.trim();
        this.baudRateTextField.setText(this.rate);
        System.out.println("Rate is set to: " + rate);
    }

    public String getRate() {
        return this.rate;
    }

    public void setDefaultRate(boolean b) {
        this.baudRateChangeCB.setSelected(b);
        if (!this.baudRateChangeCB.isSelected() && this.baudRateChangeCB.isEnabled()) {
            this.baudRateTextField.setEnabled(true);
        } else {
            this.baudRateTextField.setEnabled(false);
        }
    }

    private void setMultiFlash(boolean selected) {
        this.multiFlash = selected;
    }

    public boolean isMultiFlash() {
        return this.multiFlash;
    }

    public boolean isDefaultRate() {
        return this.baudRateChangeCB.isSelected();
    }

    public boolean useBaudRate() {
        return !this.baudRateChangeCB.isSelected() && this.baudRateChangeCB.isEnabled();
    }

    public void setProgrammer(String id) {
        for (AvrdudeProgrammer progger : this.programmers) {
            if (!progger.getId().equals(id)) continue;
            this.programmer = progger;
            this.parent.setProgrammer(this.programmer);
            this.programmerCombobox.setSelectedItem(this.programmer);
        }
    }
}

