/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.gui.SeriealListener;
import de.lazyzero.kkMulticopterFlashTool.gui.kkMenu;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.GyroEvaluationPanel;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.PotEvaluationPanel;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.ReceiverEvaluationPanel;
import de.lazyzero.kkMulticopterFlashTool.utils.Icons;
import de.lazyzero.kkMulticopterFlashTool.utils.SendLogFile;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import lu.tudor.santec.i18n.Translatrix;

public class TestEvaluationPanel
extends JPanel
implements ActionListener,
SeriealListener {
    private static final long serialVersionUID = 1L;
    private CellConstraints cc;
    private JLabel testFirmwareLabel;
    private JTextField testFirmwareVersionTextField;
    private JLabel authorLabel;
    private JTextField authorTextField;
    private JLabel submitDescriptionLabel;
    private JButton submitButton;
    private JLabel instructionLabel;
    private JButton instructionButton;
    private ReceiverEvaluationPanel receiverEvaluationPanel;
    private PotEvaluationPanel potEvaluationPanel;
    private GyroEvaluationPanel gyroEvaluationPanel;
    private LinkedHashMap<String, String> data;

    public TestEvaluationPanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.cc = new CellConstraints();
        String panelColumns = "3dlu,pref,3dlu,pref,3dlu,pref:grow,3dlu,pref:grow,3dlu,pref:grow,3dlu";
        String panelRows = "3dlu,pref,3dlu,pref,3dlu,pref,3dlu,pref,3dlu,pref,3dlu,pref,3dlu,fill:pref,3dlu";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.setBorder(new TitledBorder(Translatrix._("TestEvaluationPanel.title")));
        this.testFirmwareLabel = new JLabel(String.valueOf(Translatrix._("TestEvaluationPanel.testFirmwareLabel")) + ":");
        this.testFirmwareVersionTextField = new JTextField();
        this.testFirmwareVersionTextField.setEditable(false);
        this.testFirmwareVersionTextField.setHorizontalAlignment(4);
        this.authorLabel = new JLabel(String.valueOf(Translatrix._("TestEvaluationPanel.authorLabel")) + ":");
        this.authorTextField = new JTextField();
        this.authorTextField.setEditable(false);
        this.authorTextField.setHorizontalAlignment(4);
        this.submitDescriptionLabel = new JLabel(Translatrix._("TestEvaluationPanel.submitDescriptionLabel"));
        this.submitButton = new JButton(Translatrix._("submit"), Icons.getIcon16("mail.png"));
        this.submitButton.addActionListener(this);
        this.instructionLabel = new JLabel(Translatrix._("TestEvaluationPanel.instructionLabel"));
        this.instructionButton = new JButton(Translatrix._("TestEvaluationPanel.instructionButton"), Icons.getIcon16("info.png"));
        this.instructionButton.addActionListener(this);
        this.receiverEvaluationPanel = new ReceiverEvaluationPanel();
        this.potEvaluationPanel = new PotEvaluationPanel();
        this.gyroEvaluationPanel = new GyroEvaluationPanel();
        this.add((Component)this.testFirmwareLabel, this.cc.xy(2, 2));
        this.add((Component)this.testFirmwareVersionTextField, this.cc.xy(4, 2));
        this.add((Component)this.authorLabel, this.cc.xy(2, 4));
        this.add((Component)this.authorTextField, this.cc.xy(4, 4));
        this.add((Component)this.submitDescriptionLabel, this.cc.xyw(2, 6, 3));
        this.add((Component)this.submitButton, this.cc.xy(4, 8));
        this.add((Component)this.instructionLabel, this.cc.xyw(2, 10, 3));
        this.add((Component)this.instructionButton, this.cc.xy(4, 12));
        this.add((Component)this.receiverEvaluationPanel, this.cc.xywh(6, 2, 1, 13));
        this.add((Component)this.potEvaluationPanel, this.cc.xywh(8, 2, 1, 13));
        this.add((Component)this.gyroEvaluationPanel, this.cc.xywh(10, 2, 1, 13));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.instructionButton)) {
            kkMenu.openURL("http://www.lazyzero.de/en/modellbau/kkmulticopterflashtool/manual#hardware_test");
        } else if (event.getSource().equals(this.submitButton)) {
            SendLogFile slf = new SendLogFile();
            if (this.data != null) {
                slf.sendMail(this.data);
            } else {
                JOptionPane.showMessageDialog(this, Translatrix._("TestEvaluationPanel.measureFirstMessage"));
            }
        }
    }

    @Override
    public void dataReceived(LinkedHashMap<String, String> data) {
        this.data = data;
        Set<String> keys = data.keySet();
        for (String key : keys) {
            if (key.equals("Author")) {
                this.authorTextField.setText(data.get(key).replace("_", " "));
                continue;
            }
            if (key.equals("version")) {
                this.testFirmwareVersionTextField.setText(data.get(key));
                continue;
            }
            if (key.equals("rxRoll")) {
                this.receiverEvaluationPanel.setRoll(data.get(key));
                continue;
            }
            if (key.equals("rxPitch")) {
                this.receiverEvaluationPanel.setPitch(data.get(key));
                continue;
            }
            if (key.equals("rxColl")) {
                this.receiverEvaluationPanel.setThrottle(data.get(key));
                continue;
            }
            if (key.equals("rxYaw")) {
                this.receiverEvaluationPanel.setYaw(data.get(key));
                continue;
            }
            if (key.equals("adcRollPot")) {
                this.potEvaluationPanel.setRollPot(data.get(key));
                continue;
            }
            if (key.equals("adcPitchPot")) {
                this.potEvaluationPanel.setPitchPot(data.get(key));
                continue;
            }
            if (key.equals("adcYawPot")) {
                this.potEvaluationPanel.setYawPot(data.get(key));
                continue;
            }
            if (key.equals("adcRollGyro")) {
                this.gyroEvaluationPanel.setRollGyro(data.get(key));
                continue;
            }
            if (key.equals("adcPitchGyro")) {
                this.gyroEvaluationPanel.setPitchGyro(data.get(key));
                continue;
            }
            if (key.equals("adcYawGyro")) {
                this.gyroEvaluationPanel.setYawGyro(data.get(key));
                continue;
            }
            System.out.println(String.valueOf(key) + "==" + data.get(key));
        }
    }
}

