/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui.widgets;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEprom;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEpromListener;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.logging.Logger;
import javax.swing.JPanel;

public abstract class EEpromFirmwareSettings
implements EEpromListener {
    private Logger logger = KKMulticopterFlashTool.getLogger();
    protected JPanel panel;
    private KKMulticopterFlashTool parent;
    protected EEprom eeprom;
    private CellConstraints panelCC;
    private boolean hasSettingsLoaded = false;

    public EEpromFirmwareSettings(KKMulticopterFlashTool parent) {
        this.parent = parent;
    }

    public abstract String toString();

    protected abstract JPanel addEEpromDataItems();

    public abstract void flashSettings();

    public JPanel getPanel() {
        this.panel = new JPanel();
        this.panelCC = new CellConstraints();
        String panelColumns = "3dlu,pref:grow,3dlu,pref,3dlu";
        String panelRows = "3dlu,pref,3dlu,pref,3dlu";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.panel.setLayout((LayoutManager)panelLayout);
        this.panel.add((Component)this.addEEpromDataItems(), this.panelCC.xyw(2, 4, 3));
        this.panel.revalidate();
        return this.panel;
    }

    protected void readEEprom(EEpromListener listener) {
        this.parent.readEEprom(listener);
    }

    protected void writeEEprom(EEpromListener listener) {
        this.parent.flashEEprom(listener);
    }

    @Override
    public void EEpromState(int state) {
        this.logger.info(String.valueOf(state) + " :EEPROM read. Building GUI for KK Quad");
        if (state == 0) {
            this.hasSettingsLoaded = true;
            this.eeprom = new EEprom();
        } else if (state == -1) {
            this.hasSettingsLoaded = false;
            this.eeprom = null;
        } else if (state == -3) {
            this.parent.setSelectedTabIndex(0);
        }
    }

    protected void wait4EEprom() {
        int timeout = 10;
        while (timeout != 0) {
            if (this.eeprom != null) break;
            try {
                this.logger.info("timeout = " + timeout);
                Thread.sleep(300L);
                --timeout;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean hasSettingsLoaded() {
        return this.hasSettingsLoaded;
    }
}

