/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui.widgets;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.utils.ButtonsStateListener;
import de.lazyzero.kkMulticopterFlashTool.utils.Firmware;
import de.lazyzero.kkMulticopterFlashTool.utils.Icons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import lu.tudor.santec.i18n.Translatrix;

public class FirmwareFilePanel
extends JPanel
implements ActionListener,
ButtonsStateListener {
    private static final long serialVersionUID = 1L;
    private KKMulticopterFlashTool parent;
    private CellConstraints cc;
    private JTextField firmwareFileField;
    private JButton flashFile;
    private JLabel firmwareFileLabel;
    private JButton load;
    private JFileChooser fc;
    private FileFilter ffilter;
    private File firmwareFile;
    private Logger logger = KKMulticopterFlashTool.getLogger();
    private boolean buttonsEnabled = true;

    public FirmwareFilePanel(KKMulticopterFlashTool parent) {
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.fc = new JFileChooser(this.parent.getSettings().getProperty("last.dir", "%HOME%"));
        this.fc.setFileSelectionMode(0);
        this.ffilter = new FileFilter(){

            @Override
            public String getDescription() {
                return "Hex-File (.hex)";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getAbsoluteFile().toString().toLowerCase().endsWith(".hex");
            }
        };
        this.fc.setFileFilter(this.ffilter);
        this.cc = new CellConstraints();
        String panelColumns = "pref,3dlu,fill:pref:grow,3dlu,pref,3dlu,pref";
        String panelRows = "pref,3dlu,pref,3dlu,pref:grow,3dlu,top:pref:grow";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.firmwareFileLabel = new JLabel(Translatrix._("firmware.file"));
        this.firmwareFileLabel.setToolTipText(Translatrix._("firmware.load.tip"));
        this.firmwareFileField = new JTextField();
        this.firmwareFileField.setToolTipText(Translatrix._("firmware.load.tip"));
        this.load = new JButton(Icons.getIcon16("floppy_unmount.png"));
        this.load.setMnemonic(76);
        this.load.addActionListener(this);
        this.load.setToolTipText(Translatrix._("firmware.load.tip"));
        this.setBorder(new TitledBorder(Translatrix._("firmware.settings")));
        this.flashFile = new JButton(Icons.getIcon16("runit.png"));
        this.flashFile.setMnemonic(70);
        this.flashFile.addActionListener(this);
        this.flashFile.setEnabled(false);
        this.flashFile.setToolTipText(Translatrix._("firmware.flashFile.tip"));
        this.add((Component)this.firmwareFileLabel, this.cc.xy(1, 3));
        this.add((Component)this.firmwareFileField, this.cc.xy(3, 3));
        this.add((Component)this.load, this.cc.xy(5, 3));
        this.add((Component)this.flashFile, this.cc.xy(7, 3));
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getSource().equals(this.load)) {
            int returnVal = this.fc.showOpenDialog(this);
            if (returnVal == 0) {
                this.firmwareFile = this.fc.getSelectedFile();
                this.firmwareFileField.setText(this.firmwareFile.getName());
                this.parent.setFirmware(new Firmware(this.firmwareFile));
                this.parent.clearText();
                this.parent.println(Translatrix._("messages.loadFile"));
                this.flashFile.setEnabled(true);
            } else {
                this.firmwareFileField.setText("");
                this.parent.clearText();
                this.parent.println(Translatrix._("messages.nothingLoad"));
                this.flashFile.setEnabled(false);
            }
        } else if (action.getSource().equals(this.flashFile)) {
            this.parent.clearText();
            this.parent.println(Translatrix._("messages.flashFile"));
            if (KKMulticopterFlashTool.getCountdown() > 0) {
                this.countdown(KKMulticopterFlashTool.getCountdown());
            } else {
                this.parent.flashAVR();
            }
        }
    }

    private void countdown(int countdown) {
        this.logger.log(Level.INFO, "start Countdown from " + countdown);
        final JPanel glass = (JPanel)this.parent.getMainframe().getGlassPane();
        glass.setLayout(new GridBagLayout());
        final JLabel number = new JLabel("countdown");
        number.setForeground(Color.RED);
        number.setFont(new Font("SansSerif", 1, 120));
        number.setOpaque(false);
        glass.add(number);
        glass.setVisible(true);
        Timer timer = new Timer();
        TimerTask task = new TimerTask(countdown){
            int count;
            {
                this.count = n;
            }

            @Override
            public void run() {
                if (this.count == -1) {
                    this.cancel();
                    glass.setVisible(false);
                    FirmwareFilePanel.this.parent.flashAVR();
                }
                glass.removeAll();
                number.setText(String.valueOf(this.count));
                glass.add(number);
                number.repaint();
                FirmwareFilePanel.this.logger.log(Level.INFO, String.valueOf(this.count));
                --this.count;
            }
        };
        timer.schedule(task, 0L, 1000L);
        try {
            timer.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.parent.getMainframe().repaint();
    }

    @Override
    public void setButtonsEnabled(boolean b) {
        this.buttonsEnabled = b;
    }

    @Override
    public void updateButtons() {
        this.load.setEnabled(this.buttonsEnabled);
        this.flashFile.setEnabled(!this.buttonsEnabled ? false : this.firmwareFileField.getText().length() != 0);
    }
}

