/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui.widgets;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class JNamedIntMenuItem
extends JPanel {
    private static final long serialVersionUID = 1L;
    private CellConstraints cc;
    private String label;
    private JLabel marker;
    private JFormattedTextField valueField;
    private MaskFormatter mf;
    private FocusListener listener;

    public JNamedIntMenuItem(String label, FocusListener listener) {
        this.label = label;
        this.listener = listener;
        this.init();
    }

    private void init() {
        this.cc = new CellConstraints();
        String panelColumns = "pref,3dlu,fill:pref:grow";
        String panelRows = "pref";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.marker = new JLabel(String.valueOf(this.label) + ":");
        this.valueField = new JFormattedTextField();
        if (this.valueField.getBackground().equals(Color.BLACK)) {
            this.valueField.setBackground(Color.WHITE);
        }
        try {
            this.mf = new MaskFormatter("##");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        DefaultFormatterFactory dff = new DefaultFormatterFactory(this.mf);
        this.valueField.setFormatterFactory(dff);
        this.valueField.addFocusListener(this.listener);
        this.add((Component)this.marker, this.cc.xy(1, 1));
        this.add((Component)this.valueField, this.cc.xy(3, 1));
    }

    public void setValue(int value) {
        this.valueField.setText(String.valueOf(value));
    }

    public int getValue() {
        return Integer.parseInt(this.valueField.getText().trim());
    }
}

