/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils;

import de.lazyzero.kkMulticopterFlashTool.utils.SerialWriter;
import java.io.IOException;
import java.util.LinkedHashMap;

public class ArduinoUSBLinker {
    public static String D2 = "D2";
    public static String D3 = "D3";
    public static String D4 = "D4";
    public static String D5 = "D5";
    public static String D6 = "D6";
    public static String D7 = "D7";
    public static String D8 = "D8";
    public static String D9 = "D9";
    public static String D10 = "D10";
    public static String D11 = "D11";
    public static String D12 = "D12";
    public static String D13 = "D13";
    public static String A0 = "A0";
    public static String A1 = "A1";
    public static String A2 = "A2";
    public static String A3 = "A3";
    public static String A4 = "A4";
    public static String A5 = "A5";
    private static String command_base = "$M<";
    private static String command_pin = String.valueOf(command_base) + "P";
    private static String command_signalRate = String.valueOf(command_base) + "B";
    private static String command_baudrate = String.valueOf(command_base) + "R";
    private static String command_write2EEPROM = String.valueOf(command_base) + "W";
    private int default_baud;
    private int baud;
    private int default_signalrate;
    private int signalrate;
    private SerialWriter serialWriter;
    public static LinkedHashMap<String, Integer> pins = new LinkedHashMap();

    public ArduinoUSBLinker() {
        this.baud = this.default_baud = 19200;
        this.signalrate = this.default_signalrate = 32;
        this.init();
        this.initPins();
    }

    private void init() {
        pins.put(D2, 18);
        pins.put(D3, 19);
        pins.put(D4, 20);
        pins.put(D5, 21);
        pins.put(D6, 22);
        pins.put(D7, 23);
        pins.put(D8, 0);
        pins.put(D9, 1);
        pins.put(D10, 2);
        pins.put(D11, 3);
        pins.put(D12, 4);
        pins.put(D13, 5);
        pins.put(A0, 8);
        pins.put(A1, 9);
        pins.put(A2, 10);
        pins.put(A3, 11);
        pins.put(A4, 12);
        pins.put(A5, 13);
    }

    private void initPins() {
        for (Integer pin : pins.values()) {
            try {
                this.serialWriter.sendCommand(String.valueOf(command_pin) + pin);
                this.serialWriter.sendCommand(command_write2EEPROM);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setPin(String pin) throws IOException {
        this.serialWriter.sendCommand(String.valueOf(command_pin) + pins.get(pin));
        this.serialWriter.sendCommand(command_write2EEPROM);
    }

    public SerialWriter getSerialWriter() {
        return this.serialWriter;
    }

    public void setSerialWriter(SerialWriter serialWriter) {
        this.serialWriter = serialWriter;
    }

    public void setBaud(int baud) throws IOException {
        this.serialWriter.sendCommand(String.valueOf(command_baudrate) + baud);
        this.serialWriter.sendCommand(command_write2EEPROM);
        this.baud = baud;
    }

    public int getBaud() {
        return this.baud;
    }

    public void setSignalrate(int signalrate) throws IOException {
        if (signalrate > 4 && signalrate < 136) {
            this.serialWriter.sendCommand(String.valueOf(command_signalRate) + signalrate);
            this.serialWriter.sendCommand(command_write2EEPROM);
            this.signalrate = signalrate;
            return;
        }
        this.signalrate = this.default_signalrate;
    }

    public int getSignalrate() {
        return this.signalrate;
    }
}

