/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils.EEprom;

import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEpromBooleanItem;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEpromValueException;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.logging.Logger;

public class EEprom {
    static boolean DEBUG = false;
    Logger logger = KKMulticopterFlashTool.getLogger();
    private Vector<Short> eeprom = new Vector();
    private String ifileName = String.valueOf(KKMulticopterFlashTool.getTempFolder()) + "tmp_i_eeprom.txt";
    private String ofileName = String.valueOf(KKMulticopterFlashTool.getTempFolder()) + "tmp_o_eeprom.txt";

    public EEprom() {
        this.readEEprom(this.ifileName);
    }

    public EEprom(String ifileName) {
        this.ifileName = ifileName;
        this.readEEprom(this.ifileName);
    }

    public EEprom(int size) {
        int i = 0;
        while (i < size) {
            short s = Short.decode("0xff");
            this.eeprom.add(s);
            if (DEBUG) {
                System.out.println(String.valueOf(i) + " : " + s + " : " + String.format("0x%02x", s));
            }
            ++i;
        }
    }

    private void readEEprom(String ifileName) {
        String rom = new String();
        try {
            int s;
            FileInputStream fs = new FileInputStream(ifileName);
            DataInputStream in = new DataInputStream(fs);
            while ((s = in.read()) != -1) {
                if (DEBUG) {
                    System.out.println(s);
                }
                rom = rom.concat(String.valueOf(s) + ",");
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.decodeRawEEprom(rom);
    }

    public void writeRawEEprom() {
        this.writeRawEEprom(this.ofileName);
    }

    public void writeEEprom() {
        this.writeEEprom(this.ofileName);
    }

    private void writeEEprom(String ofileName) {
        try {
            FileOutputStream fos = new FileOutputStream(ofileName);
            String cells = this.encodeEEprom();
            fos.write(cells.getBytes());
            fos.write(System.getProperty("line.separator").getBytes());
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeRawEEprom(String ofileName) {
        try {
            FileOutputStream fos = new FileOutputStream(ofileName);
            byte[] cells = this.encodeRawEEprom();
            fos.write(cells);
            fos.write(System.getProperty("line.separator").getBytes());
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void decodeRawEEprom(String rom) {
        this.logger.info("decode raw eeprom");
        this.eeprom = new Vector();
        String[] cells = rom.split(",");
        System.out.println("cells: " + cells.length);
        int i = 0;
        while (i < cells.length) {
            short s = Short.decode(cells[i]);
            this.eeprom.add(s);
            if (DEBUG) {
                System.out.println(String.valueOf(i) + " : " + s + " : " + String.format("0x%02x", s));
            }
            ++i;
        }
        System.out.println();
    }

    private void decodeEEprom(String rom) {
        this.eeprom = new Vector();
        String[] cells = rom.split(",");
        int i = 0;
        while (i < cells.length) {
            short s = Short.decode(cells[i]);
            this.eeprom.add(s);
            if (DEBUG) {
                System.out.println(String.valueOf(i) + " : " + s + " : " + String.format("0x%02x", s));
            }
            ++i;
        }
    }

    private byte[] encodeRawEEprom() {
        byte[] cells = new byte[this.eeprom.size()];
        int i = 0;
        while (i < this.eeprom.size()) {
            cells[i] = (byte)(this.eeprom.get(i) & 0xFF);
            ++i;
        }
        return cells;
    }

    private String encodeEEprom() {
        String cells = "";
        int i = 0;
        while (i < this.eeprom.size()) {
            cells = cells.concat(String.format("0x%02x", this.eeprom.get(i)));
            if (i < this.eeprom.size() - 1) {
                cells = cells.concat(",");
            }
            ++i;
        }
        return cells;
    }

    public Short[] getCells(int startAddress, int length) {
        Short[] s = new Short[length];
        int i = 0;
        while (i < length) {
            s[i] = this.eeprom.get(i + startAddress);
            ++i;
        }
        return s;
    }

    public static void main(String[] args) {
        DEBUG = true;
        EEprom eeprom = new EEprom();
        LinkedHashMap<Short, String> dataMapping = new LinkedHashMap<Short, String>();
        dataMapping.put((short)127, "true");
        dataMapping.put((short)255, "false");
        EEpromBooleanItem eeDataItem = new EEpromBooleanItem(eeprom, "Yaw gyro", 0, 1, EEpromBooleanItem.BOOLEAN, dataMapping, "invert");
        try {
            System.out.println(eeDataItem.getValue());
        }
        catch (EEpromValueException e) {
            e.printStackTrace();
        }
    }

    public String getOutputFile() {
        return this.ofileName;
    }

    public static String getDefaultInputFile() {
        return String.valueOf(KKMulticopterFlashTool.getTempFolder()) + "tmp_i_eeprom.txt";
    }

    public void setCell(int index, Short value) {
        this.eeprom.set(index, value);
    }

    public static String getDefaultOutputFile() {
        return String.valueOf(KKMulticopterFlashTool.getTempFolder()) + "tmp_o_eeprom.txt";
    }
}

