/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils;

import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVN {
    private String url;
    private String file;
    private String name = "anonymous";
    private String password = "anonymous";
    private long startRevision = 0L;
    private long endRevision = -1L;
    private SVNRepository repository;
    private Logger logger = KKMulticopterFlashTool.getLogger();
    private String stateOpenRepositorySuccessfull;
    private String stateNumbersFirmware;
    private String stateFetchRepositorySuccessfull;
    private String stateOpenRepositoryFailed;
    private String stateFetchRevisionFailed;
    private String stateFetchChangelogFailed;
    private String stateFirmwareNotFound;
    private String stateFirmwareDownloadFailed;
    private String stateFirmwareStartDownload;
    private String stateFirmwareFinishedDownload;
    private String stateFirmwareSaveFailed;
    private String stateFirmwareCRCfailed;
    private String svnCRC;
    private KKMulticopterFlashTool instance;

    public SVN(String url, String file) throws Exception {
        this.url = url;
        this.file = file;
        this.instance = KKMulticopterFlashTool.getInstance();
        DAVRepositoryFactory.setup();
        long time = System.currentTimeMillis();
        this.openRepository();
        this.logger.log(Level.INFO, "openRepostiory [ms]: " + (System.currentTimeMillis() - time));
        try {
            this.endRevision = this.repository.getLatestRevision();
            this.logger.log(Level.INFO, "latest Revision is: " + this.endRevision);
            this.instance.println("latest Revision is: " + this.endRevision);
        }
        catch (SVNException svne) {
            this.logger.log(Level.WARNING, "error while fetching the latest repository revision: " + svne.getMessage(), true);
            this.instance.println("Can't fetch latest revision!!!");
            throw new Exception("Can't fetch latest revision!!!");
        }
        this.logger.log(Level.INFO, "fetchRevisions [ms]: " + (System.currentTimeMillis() - time));
    }

    private void openRepository() throws Exception {
        this.repository = null;
        try {
            this.repository = SVNRepositoryFactory.create(SVNURL.parseURIEncoded(this.url));
        }
        catch (SVNException svne) {
            this.logger.log(Level.WARNING, "error while creating an SVNRepository for the location '" + this.url + "': " + svne.getMessage(), true);
            throw new Exception("Can't access svn!!!");
        }
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager(this.name, this.password);
        this.repository.setAuthenticationManager(authManager);
    }

    public File getFile() {
        File svnFile;
        ByteArrayOutputStream baos;
        SVNProperties fileProperties;
        block7: {
            SVNNodeKind nodeKind;
            block6: {
                fileProperties = new SVNProperties();
                baos = new ByteArrayOutputStream();
                svnFile = new File(this.file);
                try {
                    nodeKind = this.repository.checkPath(svnFile.getPath(), -1L);
                    if (nodeKind != SVNNodeKind.NONE) break block6;
                    this.logger.log(Level.WARNING, "There is no entry at '" + this.url + "'.");
                    return null;
                }
                catch (SVNException svne) {
                    this.logger.log(Level.WARNING, "error while fetching the file contents and properties: " + svne.getMessage());
                    return null;
                }
            }
            if (nodeKind != SVNNodeKind.DIR) break block7;
            this.logger.log(Level.WARNING, "The entry at '" + this.url + "' is a directory while a file was expected.");
            return null;
        }
        this.repository.getFile(svnFile.getPath(), this.endRevision, fileProperties, baos);
        System.out.println("SVN File PAth: " + svnFile.getPath());
        String[] splitUrl = this.url.split("/");
        String folder = splitUrl[splitUrl.length - 1];
        new File(String.valueOf(KKMulticopterFlashTool.getTempFolder()) + File.separatorChar + folder).mkdir();
        File saveFile = new File(String.valueOf(KKMulticopterFlashTool.getTempFolder()) + File.separatorChar + folder + File.separatorChar + this.file);
        System.out.println("saveFile: " + saveFile.getPath());
        try {
            FileOutputStream fos = new FileOutputStream(saveFile);
            baos.writeTo(fos);
            fos.close();
            this.logger.log(Level.INFO, "File saved: " + saveFile);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.svnCRC = fileProperties.getStringValue("svn:entry:checksum");
        this.instance.println("File " + saveFile.getName() + " downloaded. SVN file revision is r" + this.endRevision);
        return saveFile;
    }

    public String getFileMD5() {
        return this.svnCRC;
    }
}

