/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.OutputStream;

public class SerialWriter {
    private SerialPort serialPort;
    private OutputStream out;
    private int baud = 9600;
    private String port;

    public SerialWriter(int baud, String port) {
        this.baud = baud;
        this.port = port;
        try {
            this.openPort();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendCommand(String command) throws IOException {
        this.out.write(command.getBytes());
        this.out.flush();
    }

    private void openPort() throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(this.port);
        CommPort commPort = portIdentifier.open("LightController", 2000);
        if (commPort instanceof SerialPort) {
            this.serialPort = (SerialPort)commPort;
            this.serialPort.setSerialPortParams(this.baud, 8, 1, 0);
            this.out = this.serialPort.getOutputStream();
        }
    }

    public void close() throws IOException {
        this.out.flush();
        this.out.close();
        this.serialPort.removeEventListener();
        this.serialPort.close();
    }
}

