/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils;

import de.lazyzero.kkMulticopterFlashTool.utils.FirmwareCommit;
import java.awt.Desktop;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLwriter {
    private static Logger logger = Logger.getLogger(XMLwriter.class.getName());
    private Document doc;
    String ENCODING = "UTF-8";
    private Desktop desktop;

    public XMLwriter(FirmwareCommit fc) {
        try {
            DocumentBuilderFactory docBFac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuild = docBFac.newDocumentBuilder();
            this.doc = docBuild.newDocument();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "not able to creat XML");
        }
        if (this.doc != null) {
            Element root = this.doc.createElement("firmware");
            root.setAttribute("name", fc.getType());
            root.setAttribute("value", fc.getVersion());
            Element author = this.doc.createElement("author");
            author.setAttribute("name", fc.getAuthor());
            root.appendChild(author);
            Element controller = this.doc.createElement("controller");
            controller.setAttribute("name", fc.getController().getCaption());
            root.appendChild(controller);
            Element zipfile = this.doc.createElement("zipfile");
            zipfile.setAttribute("url", fc.getZipfile());
            root.appendChild(zipfile);
            Element file = this.doc.createElement("file");
            file.setAttribute("url", fc.getFilename());
            root.appendChild(file);
            Element md5 = this.doc.createElement("md5");
            md5.setAttribute("value", fc.getMd5());
            root.appendChild(md5);
            Element commentURL = this.doc.createElement("commenturl");
            commentURL.setAttribute("url", fc.getCommentURL());
            root.appendChild(commentURL);
            Element comment = this.doc.createElement("comment");
            comment.appendChild(this.doc.createTextNode(fc.getComment()));
            root.appendChild(comment);
            this.doc.appendChild(root);
        }
    }

    public boolean saveXML(OutputStream out) {
        try {
            DOMSource domSource = new DOMSource(this.doc);
            StreamResult streamResult = new StreamResult(out);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", this.ENCODING);
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(domSource, streamResult);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void printDOMTree(Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.printDOMTree(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                System.out.print("<");
                System.out.print(node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    Node attr = attrs.item(i);
                    System.out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
                    ++i;
                }
                System.out.print(">");
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                int i2 = 0;
                while (i2 < len) {
                    this.printDOMTree(children.item(i2));
                    ++i2;
                }
                break;
            }
            case 5: {
                System.out.print("&");
                System.out.print(node.getNodeName());
                System.out.println(";");
                break;
            }
            case 4: {
                System.out.print("<![CDATA[");
                System.out.print(node.getNodeValue());
                System.out.println("]]>");
                break;
            }
            case 3: {
                System.out.print(node.getNodeValue());
                break;
            }
            case 7: {
                System.out.println("<?");
                System.out.print(node.getNodeName());
                String data = node.getNodeValue();
                System.out.print(" ");
                System.out.print(data);
                System.out.println("?>");
            }
        }
        if (type == 1) {
            System.out.print("</");
            System.out.print(node.getNodeName());
            System.out.println('>');
        }
    }

    public void sendByEmail() {
        if (Desktop.isDesktopSupported()) {
            this.desktop = Desktop.getDesktop();
        }
        String xml = "";
        DOMSource domSource = new DOMSource(this.doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(domSource, result);
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        xml = writer.toString();
        try {
            URI mailtoURI = new URI("mailto", "christian@chrmoll.de?SUBJECT=KKmulticopterFlashTool: commit firmware&BODY=" + xml, null);
            this.desktop.mail(mailtoURI);
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }
}

