/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils.download;

import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Observable;

public class Download
extends Observable
implements Runnable {
    private static final int MAX_BUFFER_SIZE = 1024;
    public static final String[] STATUSES = new String[]{"Downloading", "Paused", "Complete", "Cancelled", "Error"};
    public static final int DOWNLOADING = 0;
    public static final int PAUSED = 1;
    public static final int COMPLETE = 2;
    public static final int CANCELLED = 3;
    public static final int ERROR = 4;
    private URL url;
    private String name;
    private int size;
    private int downloaded;
    private int status;

    public Download(URL url) {
        this.url = url;
        this.size = -1;
        this.downloaded = 0;
        this.status = 0;
        this.name = this.url.getFile();
        this.name = (String)this.name.subSequence(this.name.lastIndexOf("/") + 1, this.name.length());
        this.download();
    }

    public Download(URL url, String name) {
        this.url = url;
        this.size = -1;
        this.downloaded = 0;
        this.status = 0;
        this.name = name;
        this.download();
    }

    public String getUrl() {
        return this.url.toString();
    }

    public int getSize() {
        return this.size;
    }

    public float getProgress() {
        return (float)this.downloaded / (float)this.size * 100.0f;
    }

    public int getStatus() {
        return this.status;
    }

    public void pause() {
        this.status = 1;
        this.stateChanged();
    }

    public void resume() {
        this.status = 0;
        this.stateChanged();
        this.download();
    }

    public void cancel() {
        this.status = 3;
        this.stateChanged();
    }

    private void error() {
        this.status = 4;
        this.stateChanged();
    }

    private void download() {
        Thread thread = new Thread(this);
        thread.start();
    }

    private String getFileName(URL url) {
        String fileName = url.getFile();
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    @Override
    public void run() {
        block25: {
            RandomAccessFile file = null;
            InputStream stream = null;
            try {
                try {
                    int contentLength;
                    HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
                    connection.setRequestProperty("Range", "bytes=" + this.downloaded + "-");
                    connection.connect();
                    if (connection.getResponseCode() / 100 != 2) {
                        this.error();
                    }
                    if ((contentLength = connection.getContentLength()) < 1) {
                        this.error();
                    }
                    if (this.size == -1) {
                        this.size = contentLength;
                        this.stateChanged();
                    }
                    file = new RandomAccessFile(String.valueOf(KKMulticopterFlashTool.getTempFolder()) + this.getFileName(this.url), "rw");
                    file.seek(this.downloaded);
                    stream = connection.getInputStream();
                    while (this.status == 0) {
                        byte[] buffer = this.size - this.downloaded > 1024 ? new byte[1024] : new byte[this.size - this.downloaded];
                        int read = stream.read(buffer);
                        if (read == -1) break;
                        file.write(buffer, 0, read);
                        this.downloaded += read;
                        this.stateChanged();
                    }
                    if (this.status == 0) {
                        this.status = 2;
                        this.stateChanged();
                    }
                }
                catch (Exception e) {
                    this.error();
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (stream == null) break block25;
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void stateChanged() {
        this.setChanged();
        this.notifyObservers();
    }

    public double getSpeed() {
        int d1 = new Integer(this.downloaded);
        Date t1 = new Date();
        while (new Date().getTime() - t1.getTime() < 500L) {
        }
        int d2 = new Integer(this.downloaded);
        return (double)(d2 - d1) / 512.0;
    }

    public String getName() {
        return this.name;
    }
}

