/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils.download;

import de.lazyzero.kkMulticopterFlashTool.utils.download.Download;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JProgressBar;
import javax.swing.table.AbstractTableModel;

public class DownloadsTableModel
extends AbstractTableModel
implements Observer {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{"Name", "Size", "Speed", "Progress", "Status"};
    private static final Class[] columnClasses = new Class[]{String.class, String.class, String.class, JProgressBar.class, String.class};
    private ArrayList downloadList = new ArrayList();

    public void addDownload(Download download) {
        download.addObserver(this);
        this.downloadList.add(download);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public Download getDownload(int row) {
        return (Download)this.downloadList.get(row);
    }

    public void clearDownload(int row) {
        this.downloadList.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Class getColumnClass(int col) {
        return columnClasses[col];
    }

    @Override
    public int getRowCount() {
        return this.downloadList.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        DecimalFormat formatter = new DecimalFormat("#.#");
        String unit = " Byte";
        Download download = (Download)this.downloadList.get(row);
        switch (col) {
            case 0: {
                return download.getName();
            }
            case 1: {
                double size = download.getSize();
                if (size > 999999.0) {
                    size /= 1048576.0;
                    unit = " MB";
                } else if (size > 999.0) {
                    size /= 1024.0;
                    unit = " kB";
                }
                return String.valueOf(size == -1.0 ? "" : formatter.format(size)) + unit;
            }
            case 2: {
                return String.valueOf(formatter.format(download.getSpeed())) + " kB/sec";
            }
            case 3: {
                return new Float(download.getProgress());
            }
            case 4: {
                return Download.STATUSES[download.getStatus()];
            }
        }
        return "";
    }

    @Override
    public void update(Observable o, Object arg) {
        int index = this.downloadList.indexOf(o);
        this.fireTableRowsUpdated(index, index);
    }

    public void clearAllDownloads() {
        try {
            this.downloadList.clear();
            this.fireTableRowsDeleted(0, this.downloadList.size() - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

