/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.concord.swing.AbstractFileFinder;

public class AbstractFile
extends File {
    public static final String FOLDER_EXT = ".folder";
    public static final String JAR_EXT = ".jar";
    public static final String ZIP_EXT = ".zip";
    protected AbstractFileFinder abstractFileFinder = new AbstractFileFinder();
    protected URL abstractURL;
    protected TreeMap directoryMap;
    protected AbstractFile abstractFileParent;

    public static File createFile(File parent, String name, URI uri) {
        return new AbstractFile(parent, name, uri);
    }

    public static File createFile(File parent, String name) {
        if (parent instanceof AbstractFile) {
            return new AbstractFile((AbstractFile)parent, name);
        }
        return null;
    }

    protected static String getRootName(URI uri) {
        String schemePart = uri.getSchemeSpecificPart();
        StringTokenizer tokens = new StringTokenizer(schemePart, "/");
        int n = tokens.countTokens();
        String[] parts = new String[n];
        int i = 0;
        while (i < n) {
            parts[i] = tokens.nextToken();
            ++i;
        }
        return parts[parts.length - 1];
    }

    public static File createFile(File folderFile) {
        String uriString = null;
        Properties folder = new Properties();
        try {
            if (folderFile.getName().endsWith(FOLDER_EXT)) {
                folder.load(new FileInputStream(folderFile));
                uriString = folder.getProperty("folder.uri", "");
            } else if (folderFile.getName().endsWith(JAR_EXT) || folderFile.getName().endsWith(ZIP_EXT)) {
                uriString = folderFile.toURL().toString();
                uriString = "jar:" + uriString + "!/";
            }
            if (uriString != null) {
                uriString = uriString.replace(' ', '+');
                URI uri = new URI(uriString);
                File filePath = new File(AbstractFile.getRootName(uri));
                return new AbstractFile(folderFile.getParentFile(), filePath.getName(), new URI(uriString));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected AbstractFile(File parent, String name, URI uri) {
        super(parent, String.valueOf(name) + FOLDER_EXT);
        try {
            this.abstractURL = new URL(uri.toString().replace('+', ' '));
            this.directoryMap = new TreeMap();
            this.abstractFileFinder.setDirectoryMap(this.directoryMap);
            this.abstractFileFinder.setAbstractDirectory(this.abstractURL);
            if (!name.endsWith(".jar!") && !name.endsWith(".zip!")) {
                Properties folder = new Properties();
                folder.setProperty("folder.uri", uri.toString());
                folder.store(new FileOutputStream(this), "");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected AbstractFile(AbstractFile parent, String name) {
        super(parent, name);
        this.abstractFileParent = parent;
        this.directoryMap = this.abstractFileParent.directoryMap;
        try {
            this.abstractURL = new URL(this.abstractFileParent.abstractURL, name);
            if (name.endsWith("/")) {
                this.abstractFileFinder.setDirectoryMap(this.directoryMap);
                this.abstractFileFinder.setAbstractDirectory(this.abstractURL);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public URL getURL() {
        return this.abstractURL;
    }

    @Override
    public File getCanonicalFile() {
        return this;
    }

    public File[] getAbstractFiles() {
        Vector list = new Vector();
        String dirName = String.valueOf(this.getName()) + "/";
        String urlString = this.abstractURL.toString();
        if (urlString.endsWith(dirName)) {
            dirName = "";
        }
        this.abstractFileFinder.collectEntries(dirName, list);
        File[] abstractFiles = new File[list.size()];
        int i = 0;
        while (i < abstractFiles.length) {
            abstractFiles[i] = new AbstractFile(this, (String)list.get(i));
            ++i;
        }
        return abstractFiles;
    }

    public File getAbstractFileParent() {
        return this.abstractFileParent;
    }

    @Override
    public boolean isDirectory() {
        return this.abstractFileFinder.getAbstractDirectory() != null;
    }

    public TreeMap getDirectoryMap() {
        return this.directoryMap;
    }

    public void setDirectoryMap(TreeMap map) {
        this.directoryMap = map;
    }

    @Override
    public boolean exists() {
        return this.abstractURL != null;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name.endsWith(FOLDER_EXT)) {
            name = name.substring(0, name.length() - FOLDER_EXT.length());
        }
        return name;
    }
}

