/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileSystemView;
import org.concord.swing.AbstractFile;

public class AbstractSystemView
extends FileSystemView {
    protected URI abstractRoot;
    protected File abstractRootParent;
    protected Icon folderIcon;

    public AbstractSystemView() {
    }

    public AbstractSystemView(URI rootURI) {
        this.abstractRoot = rootURI;
        this.folderIcon = this.getSystemIcon(this.getHomeDirectory());
    }

    @Override
    public boolean isFileSystem(File file) {
        if (file instanceof AbstractFile) {
            return false;
        }
        return super.isFileSystem(file);
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir instanceof AbstractFile) {
            return null;
        }
        this.abstractRootParent = containingDir;
        File filePath = new File(this.abstractRoot.getPath());
        return AbstractFile.createFile(this.abstractRootParent, filePath.getName(), this.abstractRoot);
    }

    @Override
    public Boolean isTraversable(File dir) {
        if (dir instanceof AbstractFile) {
            return dir.isDirectory();
        }
        return super.isTraversable(dir);
    }

    @Override
    public File getParentDirectory(File dir) {
        if (dir instanceof AbstractFile) {
            File parentDir = ((AbstractFile)dir).getAbstractFileParent();
            if (parentDir == null) {
                parentDir = this.getHomeDirectory();
            }
            return parentDir;
        }
        return super.getParentDirectory(dir);
    }

    @Override
    public Icon getSystemIcon(File file) {
        if (file instanceof AbstractFile) {
            if (file.isDirectory()) {
                return UIManager.getIcon("FileView.directoryIcon");
            }
            return UIManager.getIcon("FileView.fileIcon");
        }
        if (file.getName().endsWith(".jar!") || file.getName().endsWith(".zip!")) {
            return UIManager.getIcon("FileView.directoryIcon");
        }
        return super.getSystemIcon(file);
    }

    @Override
    public String getSystemDisplayName(File file) {
        if (file instanceof AbstractFile) {
            return file.getName();
        }
        return super.getSystemDisplayName(file);
    }

    @Override
    public File[] getFiles(File dir, boolean hiding) {
        if (dir instanceof AbstractFile) {
            AbstractFile abstractFile = (AbstractFile)dir;
            return abstractFile.getAbstractFiles();
        }
        File[] files = super.getFiles(dir, hiding);
        int i = 0;
        while (i < files.length) {
            File abstractFile = AbstractFile.createFile(files[i]);
            if (abstractFile != null) {
                files[i] = abstractFile;
            }
            ++i;
        }
        return files;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e1) {
            e1.printStackTrace();
        }
        JFileChooser chooser = new JFileChooser();
        try {
            URI uri = new URI(args[0]);
            AbstractSystemView systemView = new AbstractSystemView(uri);
            chooser.setFileSystemView(systemView);
            int result = chooser.showOpenDialog(null);
            switch (result) {
                case 1: {
                    break;
                }
                case 0: {
                    break;
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

