/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.concord.swing.ModifyValueDialog;
import org.concord.swing.VariableDialog;

public class ArrayDialog
extends VariableDialog {
    public ArrayDialog(JFrame frame, Hashtable variables) {
        super(frame, "Add and Remove Array Objects", variables);
    }

    @Override
    public ModifyValueDialog createModifyValueDialog(JFrame frame) {
        return new ModifyArrayDialog(frame);
    }

    class ModifyArrayDialog
    extends ModifyValueDialog
    implements ActionListener {
        protected JList sinkList;
        protected JList sourceList;
        protected JScrollPane sinkListScroll;
        protected JScrollPane sourceListScroll;
        protected JPanel buttonPanel;
        protected JPanel editListPanel;
        protected JButton addButton;
        protected JButton removeButton;
        protected final Vector EMPTY;

        public ModifyArrayDialog(JFrame frame) {
            super(frame, "Modify Array Object");
            this.sinkList = new JList();
            this.sourceList = new JList();
            this.sinkListScroll = new JScrollPane(this.sinkList);
            this.sourceListScroll = new JScrollPane(this.sourceList);
            this.buttonPanel = new JPanel();
            this.editListPanel = new JPanel();
            this.addButton = new JButton("Add");
            this.removeButton = new JButton("Remove");
            this.EMPTY = new Vector();
            this.editListPanel.setLayout(new BorderLayout());
            this.buttonPanel.setLayout(new FlowLayout());
            this.editListPanel.add((Component)this.sinkListScroll, "West");
            this.editListPanel.add((Component)this.sourceListScroll, "East");
            this.editListPanel.add((Component)this.buttonPanel, "Center");
            this.sinkList.setSelectionMode(0);
            this.sourceList.setSelectionMode(0);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
        }

        public void setSourceList(Vector values) {
            this.sourceList.setListData(values);
            this.sinkList.setListData(this.EMPTY);
        }

        @Override
        public void setValue(Object value) {
            super.setValue(value);
            Vector arrayValues = (Vector)value;
            this.sinkList.setListData(arrayValues);
        }
    }
}

