/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.io.File;
import java.io.FilenameFilter;

public class CCFilenameFilter
implements FilenameFilter {
    public static final int DIRECTORY_AND_FILE = 1;
    public static final int DIRECTORY_ONLY = 2;
    private String acceptableExtension = null;

    public CCFilenameFilter() {
    }

    public CCFilenameFilter(String extension) {
        this.setAcceptableExtension(extension);
    }

    public void setAcceptableExtension(String extension) {
        this.acceptableExtension = extension;
    }

    public String getAcceptableExtension() {
        return this.acceptableExtension;
    }

    @Override
    public boolean accept(File arg0, String arg1) {
        File file = new File(arg0 + File.separator + arg1);
        if (this.acceptableExtension == null || this.acceptableExtension.equals("*")) {
            return true;
        }
        if (file.isDirectory()) {
            return true;
        }
        String ext = this.getExtension(file);
        if (ext == null) {
            return false;
        }
        return ext.equalsIgnoreCase(this.acceptableExtension);
    }

    public String getExtension(File file) {
        String filename = file.getName();
        if (filename.length() == 0) {
            return null;
        }
        if (filename.lastIndexOf(".") == -1) {
            return null;
        }
        String ext = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
        return ext;
    }
}

