/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.concord.swing.CCJCheckBoxRenderer;

public class CCJCheckBoxTree
extends JTree
implements TreeSelectionListener {
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private Vector allNodes = new Vector();
    private HashMap nodesMap = new HashMap();
    private TreePath lastSelectedPath = null;
    private MouseListener[] mouseListeners;

    public CCJCheckBoxTree() {
        this(new DefaultMutableTreeNode());
    }

    public CCJCheckBoxTree(TreeNode node) {
        this(node, false);
    }

    public CCJCheckBoxTree(String rootName) {
        this(new DefaultMutableTreeNode(new NodeHolder(rootName), true));
    }

    public CCJCheckBoxTree(TreeNode node, boolean asksAllowsChildren) {
        super(node, asksAllowsChildren);
        this.rootNode = (DefaultMutableTreeNode)node;
        NodeHolder rootBox = (NodeHolder)this.rootNode.getUserObject();
        this.allNodes.addElement(rootBox);
        this.nodesMap.put(rootBox, this.rootNode);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.cellRenderer = new CCJCheckBoxRenderer();
        this.setModel(this.treeModel);
        this.setCellRenderer(this.cellRenderer);
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(true);
        this.setToolTipText("Click to select; double-click to check/uncheck");
        this.mouseListeners = this.getMouseListeners();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int i = 0;
                while (i < CCJCheckBoxTree.this.mouseListeners.length) {
                    CCJCheckBoxTree.this.removeMouseListener(CCJCheckBoxTree.this.mouseListeners[i]);
                    ++i;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TreePath path = CCJCheckBoxTree.this.getPathForLocation(e.getX(), e.getY());
                Rectangle bounds = CCJCheckBoxTree.this.getPathBounds(path);
                if (path != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    Object obj = node.getUserObject();
                    if (obj instanceof NodeHolder) {
                        NodeHolder nodeHolder = (NodeHolder)obj;
                        if (e.getX() < bounds.x + 20 && e.getX() > bounds.x && (double)e.getY() < bounds.getCenterY() + (double)(bounds.height / 2) && (double)e.getY() > bounds.getCenterY() - (double)(bounds.height / 2)) {
                            boolean bl = nodeHolder.checked = !nodeHolder.checked;
                            if (!nodeHolder.checked) {
                                if (CCJCheckBoxTree.this.lastSelectedPath == path) {
                                    CCJCheckBoxTree.this.lastSelectedPath = null;
                                }
                            } else if (CCJCheckBoxTree.this.lastSelectedPath == null) {
                                CCJCheckBoxTree.this.lastSelectedPath = path;
                            }
                            CCJCheckBoxTree.this.setSelectionPath(CCJCheckBoxTree.this.lastSelectedPath);
                        } else if (e.getX() > bounds.x + 20 && (double)e.getX() < (double)bounds.x + bounds.getWidth() && (double)e.getY() < bounds.getCenterY() + (double)(bounds.height / 2) && (double)e.getY() > bounds.getCenterY() - (double)(bounds.height / 2)) {
                            int i = 0;
                            while (i < CCJCheckBoxTree.this.mouseListeners.length) {
                                CCJCheckBoxTree.this.addMouseListener(CCJCheckBoxTree.this.mouseListeners[i]);
                                ++i;
                            }
                            if (!nodeHolder.checked) {
                                nodeHolder.checked = true;
                            }
                            CCJCheckBoxTree.this.lastSelectedPath = path;
                            CCJCheckBoxTree.this.setSelectionPath(CCJCheckBoxTree.this.lastSelectedPath);
                        } else {
                            int i = 0;
                            while (i < CCJCheckBoxTree.this.mouseListeners.length) {
                                CCJCheckBoxTree.this.addMouseListener(CCJCheckBoxTree.this.mouseListeners[i]);
                                ++i;
                            }
                            if ((double)e.getY() > CCJCheckBoxTree.this.getVisibleHeight()) {
                                CCJCheckBoxTree.this.lastSelectedPath = null;
                            } else {
                                CCJCheckBoxTree.this.lastSelectedPath = path;
                            }
                            CCJCheckBoxTree.this.setSelectionPath(CCJCheckBoxTree.this.lastSelectedPath);
                        }
                        CCJCheckBoxTree.this.checkRelatedNodeFor(node);
                    }
                    CCJCheckBoxTree.this.repaint();
                } else {
                    int i = 0;
                    while (i < CCJCheckBoxTree.this.mouseListeners.length) {
                        CCJCheckBoxTree.this.addMouseListener(CCJCheckBoxTree.this.mouseListeners[i]);
                        ++i;
                    }
                    CCJCheckBoxTree.this.lastSelectedPath = null;
                    CCJCheckBoxTree.this.setSelectionPath(CCJCheckBoxTree.this.lastSelectedPath);
                }
            }
        });
    }

    public String renameCurrentNode() {
        String name = null;
        TreePath currentSelection = this.getSelectionPath();
        if (currentSelection != null) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent();
            NodeHolder box = (NodeHolder)currentNode.getUserObject();
            String newText = JOptionPane.showInputDialog(this, "Enter new name", box.name);
            if (newText != null && newText.trim().length() > 0) {
                box.name = newText;
                name = newText;
                this.repaint();
            }
        }
        return name;
    }

    public Object removeCurrentNode() {
        DefaultMutableTreeNode currentNode;
        MutableTreeNode parent;
        this.getUI().cancelEditing(this);
        TreePath currentSelection = this.getSelectionPath();
        if (currentSelection != null && (parent = (MutableTreeNode)(currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent()).getParent()) != null) {
            Object obj = currentNode.getUserObject();
            this.treeModel.removeNodeFromParent(currentNode);
            this.allNodes.removeElement(obj);
            this.nodesMap.remove(obj);
            return obj;
        }
        this.toolkit.beep();
        return null;
    }

    public DefaultMutableTreeNode addObject(Object child) {
        DefaultMutableTreeNode parentNode = null;
        TreePath parentPath = this.getSelectionPath();
        parentNode = parentPath == null ? this.rootNode : (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        NodeHolder nodeHolder = null;
        nodeHolder = !(child instanceof NodeHolder) ? new NodeHolder(child.toString()) : (NodeHolder)child;
        return this.addObject(parentNode, nodeHolder, true);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child) {
        return this.addObject(parent, child, false);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        this.allNodes.addElement(child);
        this.nodesMap.put(child, childNode);
        return childNode;
    }

    public Vector getCheckedNodes() {
        int size = this.allNodes.size();
        Vector<NodeHolder> checkedBoxes = new Vector<NodeHolder>();
        int i = 0;
        while (i < size) {
            NodeHolder box = (NodeHolder)this.allNodes.elementAt(i);
            if (box.checked) {
                checkedBoxes.addElement(box);
            }
            ++i;
        }
        return checkedBoxes;
    }

    public Vector getAllNodes() {
        return this.allNodes;
    }

    public HashMap getNodesMap() {
        return this.nodesMap;
    }

    private void checkRelatedNodeFor(DefaultMutableTreeNode node) {
        block3: {
            NodeHolder nodeHolder;
            block2: {
                Object obj = node.getUserObject();
                nodeHolder = (NodeHolder)obj;
                if (!nodeHolder.checked) break block2;
                Enumeration<TreeNode> enu = node.depthFirstEnumeration();
                while (enu.hasMoreElements()) {
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)enu.nextElement();
                    ((NodeHolder)childNode.getUserObject()).checked = nodeHolder.checked;
                }
                break block3;
            }
            TreeNode[] parents = node.getPath();
            if (parents == null || parents.length <= 0) break block3;
            int i = 0;
            while (i < parents.length) {
                DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)parents[i];
                ((NodeHolder)newNode.getUserObject()).checked = nodeHolder.checked;
                ++i;
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        System.out.println(path.getClass());
        if (path instanceof NodeHolder) {
            ((NodeHolder)((Object)path)).checked = !((NodeHolder)((Object)path)).checked;
        }
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public double getVisibleHeight() {
        Rectangle rect = this.getPathBounds(this.getPathForRow(this.getRowCount() - 1));
        if (rect != null) {
            return rect.getCenterY() + (double)(rect.height / 2);
        }
        return 0.0;
    }

    public void setPathChecked(TreePath path, boolean checked) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(0);
        NodeHolder holder = (NodeHolder)node.getUserObject();
        holder.checked = checked;
    }

    public boolean isPathChecked(TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        NodeHolder holder = (NodeHolder)node.getUserObject();
        return holder.checked;
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
            try {
                int index = e.getChildIndices()[0];
                node = (DefaultMutableTreeNode)node.getChildAt(index);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            System.out.println("node inserted");
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            System.out.println("node deleted");
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            System.out.println("tree changed");
        }
    }

    public static class NodeHolder
    extends JPanel {
        public String name;
        public boolean checked;
        public Color color;

        public NodeHolder(String name, boolean checked, Color color) {
            this.name = name;
            this.checked = checked;
            this.color = color;
        }

        public NodeHolder(String name, boolean checked) {
            this(name, checked, Color.BLACK);
        }

        public NodeHolder(String name) {
            this(name, false);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

