/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

public class CCJFileChooser
extends JFileChooser {
    String preferencesKey;
    static final String PREFERENCE_DOMAIN = "org/concord/swing/CCFileDialog";
    static final String DEFAULT_NAME = "org.concord.swing.CCFileDialog";
    private boolean preferencesKeyWasSet = false;

    public CCJFileChooser() {
        this(DEFAULT_NAME);
    }

    public CCJFileChooser(String preferencesKey) {
        this.setPreferencesKey(preferencesKey);
        this.checkingPreferences();
    }

    public CCJFileChooser(String currentDirectoryPath, String preferencesKey) {
        super(currentDirectoryPath);
        this.setPreferencesKey(preferencesKey);
        this.settingPreferences();
    }

    public CCJFileChooser(File currentDirectory, String preferencesKey) {
        super(currentDirectory);
        this.setPreferencesKey(preferencesKey);
        this.settingPreferences();
    }

    public CCJFileChooser(FileSystemView fsv, String preferencesKey) {
        super(fsv);
        this.setPreferencesKey(preferencesKey);
        this.settingPreferences();
    }

    public CCJFileChooser(File currentDirectory, FileSystemView fsv, String preferencesKey) {
        super(currentDirectory, fsv);
        this.setPreferencesKey(preferencesKey);
        this.settingPreferences();
    }

    public CCJFileChooser(String currentDirectoryPath, FileSystemView fsv, String preferencesKey) {
        super(currentDirectoryPath, fsv);
        this.setPreferencesKey(preferencesKey);
        this.settingPreferences();
    }

    @Override
    public void setCurrentDirectory(File dir) {
        super.setCurrentDirectory(dir);
        if (this.preferencesKeyWasSet) {
            this.settingPreferences();
        }
    }

    protected void setPreferencesKey(String preferencesKey) {
        this.preferencesKey = preferencesKey == null ? DEFAULT_NAME : preferencesKey;
        this.preferencesKeyWasSet = true;
    }

    protected void checkingPreferences() {
        File suggestedFile;
        Preferences userPreferences = Preferences.userRoot();
        Preferences dialogPreferences = null;
        try {
            dialogPreferences = userPreferences.node(PREFERENCE_DOMAIN);
        }
        catch (Throwable t) {
            dialogPreferences = null;
        }
        if (dialogPreferences == null) {
            return;
        }
        String suggestedPath = dialogPreferences.get(this.preferencesKey, null);
        if (suggestedPath == null) {
            try {
                suggestedPath = this.getCurrentDirectory().getCanonicalPath();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (suggestedPath == null) {
                suggestedPath = System.getProperty("user.dir");
            }
        }
        if ((suggestedFile = new File(suggestedPath)) != null && suggestedFile.exists() && suggestedFile.isDirectory()) {
            super.setCurrentDirectory(suggestedFile);
        }
    }

    protected void settingPreferences() {
        if (this.preferencesKey == null) {
            this.preferencesKey = DEFAULT_NAME;
        }
        File currDirectory = this.getCurrentDirectory();
        String canonicalPath = null;
        try {
            canonicalPath = currDirectory.getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (canonicalPath == null) {
            canonicalPath = System.getProperty("user.dir");
        }
        Preferences userPreferences = Preferences.userRoot();
        Preferences dialogPreferences = null;
        try {
            dialogPreferences = userPreferences.node(PREFERENCE_DOMAIN);
        }
        catch (Throwable t) {
            dialogPreferences = null;
        }
        if (dialogPreferences == null) {
            return;
        }
        dialogPreferences.put(this.preferencesKey, canonicalPath);
    }
}

