/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.concord.swing.AbstractSystemView;

public class ClassPathEditor
extends JPanel
implements ListSelectionListener,
ActionListener {
    public static final File JAVA_HOME = new File(System.getProperty("java.home"));
    public static final String BOOT_CLASS_PATH = System.getProperty("sun.boot.class.path");
    public static final String CLASS_PATH = System.getProperty("java.class.path");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String FOLDER_PREFIX = "!.folder";
    public static final String CLASS_SUFFIX = ".class";
    public final File userDir = new File(System.getProperty("user.dir"));
    public final File userHome = new File(System.getProperty("user.home"));
    protected LocalClassLoader localClassLoader = new LocalClassLoader();
    protected JFileChooser classFileChooser = new JFileChooser();
    protected JList jarList = new JList();
    protected JScrollPane jarListScroll = new JScrollPane(this.jarList);
    protected JDialog dialog;
    protected Map bootClassPathURLS = new TreeMap();
    protected Map classPathURLS = new TreeMap();
    protected String systemPrefix;
    protected Class selectedClass;

    public ClassPathEditor() {
        this.setLayout(new BorderLayout());
        this.classFileChooser.setFileSystemView(new AbstractSystemView());
        this.classFileChooser.setFileFilter(new ClassFileFilter());
        this.classFileChooser.addActionListener(this);
        this.systemPrefix = System.class.getResource("System.class").getPath();
        this.systemPrefix = this.systemPrefix.substring(0, this.systemPrefix.indexOf("!"));
        this.systemPrefix = this.systemPrefix.substring(0, this.systemPrefix.lastIndexOf("/") + 1);
        this.initializeClassPath(BOOT_CLASS_PATH, this.bootClassPathURLS);
        this.initializeClassPath(CLASS_PATH, this.classPathURLS);
        this.classPathURLS.putAll(this.bootClassPathURLS);
        Vector jars = new Vector(this.classPathURLS.keySet());
        this.jarList.setListData(jars);
        this.jarList.addListSelectionListener(this);
        this.jarList.setSelectedIndex(0);
        this.add((Component)this.jarListScroll, "Center");
        this.add((Component)this.classFileChooser, "South");
    }

    protected void initializeClassPath(String classPath, Map classPathMap) {
        StringTokenizer pathTokens = new StringTokenizer(classPath, PATH_SEPARATOR);
        while (pathTokens.hasMoreTokens()) {
            String fileName = pathTokens.nextToken();
            File file = new File(fileName);
            if (!fileName.endsWith(".jar") && !file.isDirectory() || !file.exists()) continue;
            try {
                URL pathURL = file.toURL();
                classPathMap.put(pathURL.toString(), file);
            }
            catch (IOException e) {
                System.out.println("File to URL failure: " + file.toString());
            }
        }
    }

    protected boolean isBootPathURL(URL url) {
        return this.bootClassPathURLS.get(url) instanceof URL;
    }

    public String chooseClassName() {
        String filePath;
        File file = this.classFileChooser.getSelectedFile();
        File classRoot = (File)this.classPathURLS.get(this.jarList.getSelectedValue());
        String rootPath = classRoot.toString();
        if (file != null && (filePath = file.toString()).startsWith(rootPath) && filePath.endsWith(CLASS_SUFFIX)) {
            filePath = filePath.substring(rootPath.length()).replace('\\', '/');
            filePath = filePath.replace('/', '.');
            if ((filePath = filePath.substring(0, filePath.length() - CLASS_SUFFIX.length())).startsWith(FOLDER_PREFIX)) {
                filePath = filePath.substring(FOLDER_PREFIX.length());
            }
            filePath = filePath.substring(1);
            return filePath;
        }
        return null;
    }

    public Class chooseClass() {
        String className = this.chooseClassName();
        if (className != null) {
            try {
                return this.localClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e1) {
            e1.printStackTrace();
        }
        ClassPathEditor classPathEditor = new ClassPathEditor();
        JDialog dialog = new JDialog(null, "Class Path Editor Test");
        classPathEditor.showClassPathEditor(dialog);
        System.out.println("Selected class = " + classPathEditor.getSelectedClass());
    }

    public void showClassPathEditor(JDialog dialog) {
        this.dialog = dialog;
        dialog.setModal(true);
        dialog.getContentPane().add(this);
        dialog.setBounds(50, 50, 800, 600);
        dialog.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object selection = this.jarList.getSelectedValue();
        File file = (File)this.classPathURLS.get(selection);
        this.classFileChooser.setSelectedFile(file);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selectedClass = this.chooseClass();
        this.dialog.setVisible(false);
    }

    public Class getSelectedClass() {
        return this.selectedClass;
    }

    public class ClassFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            if (file.getName().toLowerCase().endsWith(".jar!")) {
                return true;
            }
            if (file.getName().toLowerCase().endsWith(".zip!")) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(ClassPathEditor.CLASS_SUFFIX);
        }

        @Override
        public String getDescription() {
            return "Java class file (*.class)";
        }
    }

    public class LocalClassLoader
    extends URLClassLoader {
        public LocalClassLoader() {
            super(new URL[0], ClassPathEditor.class.getClassLoader());
        }

        public void addURLPathElement(URL url) {
            this.addURL(url);
        }
    }
}

