/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Console
extends JTextArea {
    protected static final WindowAdapter closer = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent event) {
            JFrame frame = (JFrame)event.getSource();
            frame.dispose();
        }
    };
    boolean running = false;
    protected Vector listeners = new Vector();
    protected Vector streamThreads = new Vector();
    protected Process process;
    protected Thread outputProcess;
    protected Thread errorProcess;
    protected Thread monitorProcess;

    public Console() {
        this((Process)null);
    }

    public Console(Process process) {
        this.setProcess(process);
    }

    public void setProcess(Process newProcess) {
        if (this.process instanceof Process) {
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.process = newProcess;
        if (this.process == null) {
            return;
        }
        this.setText("");
        this.streamThreads.removeAllElements();
        this.addInputStream(this.process.getInputStream(), "stdout");
        this.addInputStream(this.process.getErrorStream(), "stderr");
        this.monitorProcess = new Thread(){

            @Override
            public void run() {
                try {
                    if (Console.this.process instanceof Process) {
                        Console.this.process.waitFor();
                    }
                    Console.this.running = false;
                    Console.this.process = null;
                    if (Console.this.listeners.size() > 0) {
                        ChangeEvent changeEvent = new ChangeEvent(Console.this);
                        int i = 0;
                        while (i < Console.this.listeners.size()) {
                            ChangeListener listener = (ChangeListener)Console.this.listeners.elementAt(i);
                            listener.stateChanged(changeEvent);
                            ++i;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.start();
        this.monitorProcess.setPriority(1);
        this.monitorProcess.start();
    }

    public void start() {
        this.running = true;
        int i = 0;
        while (i < this.streamThreads.size()) {
            Thread thread = (Thread)this.streamThreads.elementAt(i);
            thread.start();
            ++i;
        }
    }

    public void addInputStream(InputStream stream, String name) {
        StreamThread thread = new StreamThread(stream, name);
        this.streamThreads.addElement(thread);
    }

    public PrintStream getPrintStream() {
        return new PrintStream(new ConsoleOutputStream(), true);
    }

    public Process getProcess() {
        return this.process;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.removeElement(listener);
    }

    class ConsoleOutputStream
    extends OutputStream {
        byte[] bytes = new byte[1];

        ConsoleOutputStream() {
        }

        @Override
        public void write(int b) {
            this.bytes[0] = (byte)b;
            Console.this.append(new String(this.bytes));
        }

        @Override
        public void write(byte[] b) {
            Console.this.append(new String(b));
        }

        @Override
        public void write(byte[] b, int off, int len) {
            Console.this.append(new String(b, off, len));
        }
    }

    class StreamThread
    extends Thread {
        InputStream stream;
        String name;

        StreamThread(InputStream stream, String name) {
            super(name);
            this.stream = stream;
            this.name = name;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            while (Console.this.running) {
                try {
                    int n = this.stream.read(buffer);
                    while (n > 0) {
                        String strDebug = new String(buffer, 0, n);
                        if (System.getProperty("os.name").equals("Mac OS")) {
                            strDebug = strDebug.replace('\r', '\n');
                        }
                        Console.this.append(strDebug);
                        n = this.stream.read(buffer);
                    }
                }
                catch (Exception e) {
                    Console.this.append(e.toString());
                }
            }
        }
    }
}

