/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class CustomDialog
extends JDialog
implements ActionListener {
    protected JComponent middlePanel;
    protected JPanel buttonPanel;
    protected Dimension defaultButtonSize;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    public static final int APPLY_OPTION = -10;
    public static final int CLOSED_OPTION = -1;
    private int returnCode = -1;
    protected Vector actionListeners;

    public CustomDialog(Frame parentComponent) {
        super(parentComponent);
        this.getContentPane().setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.getContentPane().add((Component)this.buttonPanel, "South");
        try {
            this.setLocationRelativeTo(parentComponent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int showOKCancelDialog(Component parentComponent, JComponent middlePanel, String title) {
        return CustomDialog.showOKCancelDialog(parentComponent, middlePanel, title, false, true);
    }

    public static int showOKCancelDialog(Component parentComponent, JComponent middlePanel, String title, boolean resizable, boolean modal) {
        CustomDialog dialog = CustomDialog.createOKCancelDialog(parentComponent, middlePanel, title, resizable, modal);
        if (dialog == null) {
            return -1;
        }
        dialog.pack();
        dialog.show();
        return dialog.getReturnCode();
    }

    public static int showOKCancelApplyDialog(Component parentComponent, JComponent middlePanel, String title, boolean resizable, boolean modal) {
        return CustomDialog.showOKCancelApplyDialog(parentComponent, middlePanel, title, resizable, modal, null);
    }

    public static int showOKCancelApplyDialog(Component parentComponent, JComponent middlePanel, String title, boolean resizable, boolean modal, ActionListener actionListener) {
        CustomDialog dialog = CustomDialog.createOKCancelDialog(parentComponent, middlePanel, title, resizable, modal);
        if (dialog == null) {
            return -1;
        }
        dialog.addButton("Apply", -10);
        if (actionListener != null) {
            dialog.addActionListener(actionListener);
        }
        dialog.pack();
        dialog.show();
        return dialog.getReturnCode();
    }

    public static CustomDialog createOKCancelDialog(Component parentComponent, JComponent middlePanel, String title, boolean resizable, boolean modal) {
        Component c = null;
        c = parentComponent;
        while (c != null && !(c instanceof Frame)) {
            c = c.getParent();
        }
        if (c == null) {
            return null;
        }
        CustomDialog dialog = new CustomDialog((Frame)c);
        dialog.setTitle(title);
        dialog.setMiddlePanel(middlePanel);
        dialog.addDefaultButtonsPanel();
        dialog.setModal(modal);
        dialog.setResizable(resizable);
        return dialog;
    }

    public static void main(String[] args) {
    }

    public JComponent getMiddlePanel() {
        return this.middlePanel;
    }

    public void setMiddlePanel(JComponent middlePanel) {
        this.middlePanel = middlePanel;
        this.getContentPane().add(middlePanel);
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    protected void addDefaultButtonsPanel() {
        JButton cancelButton = this.createButton("Cancel", 2);
        this.defaultButtonSize = cancelButton.getPreferredSize();
        JButton okButton = this.createButton("OK", 0);
        this.buttonPanel.add(okButton);
        this.buttonPanel.add(cancelButton);
    }

    public void setButtonPanel(JPanel buttonPanel) {
        this.buttonPanel = buttonPanel;
    }

    public void addButton(String text, int actionCommand) {
        JPanel p = this.getButtonPanel();
        p.add(this.createButton(text, actionCommand));
    }

    protected JButton createButton(String text, int actionCommand) {
        JButton b = new JButton(text);
        if (this.defaultButtonSize != null) {
            b.setPreferredSize(this.defaultButtonSize);
        }
        b.setActionCommand(Integer.toString(actionCommand));
        b.addActionListener(this);
        return b;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.returnCode = Integer.parseInt(e.getActionCommand());
        }
        catch (Throwable ex) {
            System.err.println("Warning: Action command " + e.getActionCommand() + " is not an integer");
            ex.printStackTrace();
            return;
        }
        if (this.returnCode == 0 || this.returnCode == 2 || this.returnCode == -1) {
            this.hide();
        }
        this.notifyActionListeners(this.returnCode);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void addActionListener(ActionListener l) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        if (!this.actionListeners.contains(l)) {
            this.actionListeners.add(l);
        }
    }

    public void removeActionListener(ActionListener l) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.remove(l);
    }

    protected void notifyActionListeners(int retcode) {
        if (this.actionListeners == null) {
            return;
        }
        ActionEvent evt = new ActionEvent(this, 1001, String.valueOf(retcode));
        int i = 0;
        while (i < this.actionListeners.size()) {
            ActionListener l = (ActionListener)this.actionListeners.elementAt(i);
            l.actionPerformed(evt);
            ++i;
        }
    }
}

