/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpView
extends JPanel {
    protected JEditorPane helpHTML;
    protected JEditorPane glossaryHTML;
    protected JScrollPane helpScroll;

    public HelpView() {
        this.setLayout(new BorderLayout());
        this.helpHTML = new JEditorPane();
        this.helpScroll = new JScrollPane(this.helpHTML);
        this.add((Component)this.helpScroll, "Center");
        this.glossaryHTML = new JEditorPane();
        this.glossaryHTML.setContentType("text/html");
        this.glossaryHTML.setEditable(false);
        this.add((Component)this.glossaryHTML, "South");
        this.glossaryHTML.setBackground(new Color(200, 200, 200));
        LocalHyperlinkAdapter listener = new LocalHyperlinkAdapter();
        this.helpHTML.addHyperlinkListener(listener);
    }

    public void setPage(URL url) {
        try {
            this.helpHTML.setPage(url);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test HelpView");
        frame.addWindowListener(new WindowCloser());
        HelpView view = new HelpView();
        try {
            view.setPage(new URL(args[0]));
            frame.getContentPane().add((Component)view, "Center");
            frame.setSize(800, 600);
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class LocalHyperlinkAdapter
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            try {
                HelpView.this.glossaryHTML.setVisible(false);
                if (event.getEventType().equals(HyperlinkEvent.EventType.ENTERED) || event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    HelpView.this.glossaryHTML.setPage(event.getURL());
                    HelpView.this.glossaryHTML.setVisible(true);
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    static class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            System.exit(0);
        }
    }
}

