/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.DefaultPersistenceDelegate;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.concord.swing.AnnotationImageAction;
import org.concord.swing.AnnotationImageFileFilter;
import org.concord.swing.CCJFileChooser;
import org.concord.swing.ImageFileFilter;
import org.concord.swing.JAnnotationImage;
import org.concord.swing.JAnnotationImageModel;
import org.concord.swing.StateOwner;
import org.concord.swing.util.ComponentScreenshot;

public class JAnnotationImageContainer
extends JPanel
implements StateOwner {
    private static final Border SELECTED_BORDER = BorderFactory.createLoweredBevelBorder();
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder();
    private static final Border UNSELECTED_BORDER = BorderFactory.createRaisedBevelBorder();
    public static final int NONE_TOOLBAR_MASK = 0;
    public static final int RECTANGLE_TOOLBAR_MASK = 1;
    public static final int ELLIPSE_TOOLBAR_MASK = 2;
    public static final int POLYGON_TOOLBAR_MASK = 4;
    public static final int DOTS_TOOLBAR_MASK = 8;
    public static final int ALL_TOOLBAR_MASK = 15;
    JAnnotationImage annotationImage;
    ImageContainerState state;
    HashMap availableImageFormats;
    static ResourceBundle resbundle = ResourceBundle.getBundle("org.concord.swing.annotationimage.localization.JAnnotationImageContainer", Locale.getDefault());
    static ImageIcon barHeader = new ImageIcon(JAnnotationImageContainer.class.getResource("/org/concord/swing/images/ToolBarHeaderBar.gif"));
    static ImageIcon iconSeparator = new ImageIcon(JAnnotationImageContainer.class.getResource("/org/concord/swing/images/ToolBarSeparator.gif"));
    JLayeredPane layeredPane = new JLayeredPane(){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            JAnnotationImageContainer.this.paintInLayeredPane(g);
        }
    };
    public int toolBarMask = 15;
    HashMap actions = new HashMap();
    JToolBar toolBar;
    ButtonGroup choosingModeButtonGroup = new ButtonGroup();
    static final int RECT_TOP = 0;
    static final int RECT_RIGHT = 1;
    static final int RECT_BOTTOM = 2;
    static final int RECT_LEFT = 3;
    static BufferedImage testImage = null;
    static final boolean DEFAULT_HTML_SUPPORT = false;
    static JFrame frame;
    static JAnnotationImageContainer imageContainer;

    public JAnnotationImageContainer() {
        this(null, null);
    }

    public JAnnotationImageContainer(InputStream is) {
        this(null, null);
        this.restoreFromStream(is);
    }

    public JAnnotationImageContainer(Object state) {
        this.setLayeredContainer();
        this.setOpaque(true);
        this.setState(state);
        this.addKeyHandler();
    }

    public JAnnotationImageContainer(JAnnotationImage annotationImage) {
        this.setLayeredContainer();
        this.setOpaque(true);
        this.setAnnotationImage(annotationImage);
        this.setAnnotationImageLocation(1, 1);
        this.addKeyHandler();
    }

    public JAnnotationImageContainer(BufferedImage bim, String pathToSave) {
        this.setLayeredContainer();
        this.createAvailableOutImageFormats();
        this.setOpaque(true);
        if (bim != null) {
            this.setAnnotationImage(bim);
            if (pathToSave != null) {
                this.saveImage(bim, pathToSave);
            }
            this.setSize(bim.getWidth() + 2, bim.getHeight() + 2);
        } else {
            this.setSize(500, 500);
        }
        this.setAnnotationImageLocation(1, 1);
        this.addKeyHandler();
    }

    public JAnnotationImageContainer(BufferedImage bim) {
        this(bim, null);
    }

    public void setToolBarMask(int toolBarMask) {
        this.toolBarMask = toolBarMask;
        if (this.toolBar != null) {
            this.remove(this.toolBar);
            if (this.choosingModeButtonGroup != null) {
                int nComponents = this.toolBar.getComponentCount();
                int i = 0;
                while (i < nComponents) {
                    Component obj = this.toolBar.getComponent(i);
                    if (obj instanceof AbstractButton) {
                        this.choosingModeButtonGroup.remove((AbstractButton)obj);
                    }
                    ++i;
                }
            }
            this.toolBar.removeAll();
        }
        this.createToolBar();
    }

    public Component getRenderingComponent() {
        return this.layeredPane;
    }

    public BufferedImage getScreenShotWithRobot() {
        Point myLocation = new Point(this.getLocation());
        Dimension mySize = this.getSize();
        SwingUtilities.convertPointToScreen(myLocation, this.getParent());
        try {
            Robot robot = new Robot();
            BufferedImage snapShotImage = robot.createScreenCapture(new Rectangle(myLocation.x, myLocation.y, mySize.width, mySize.height));
            return snapShotImage;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public BufferedImage getScreenShot() {
        try {
            BufferedImage snapShotImage = ComponentScreenshot.getScreenshot(this);
            return snapShotImage;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void addKeyHandler() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (!JAnnotationImageContainer.this.isEditMode()) {
                    return;
                }
                int keyCode = evt.getKeyCode();
                if (keyCode == 127 || keyCode == 8) {
                    JAnnotationImageContainer.this.deleteSelectedSpot();
                }
            }
        });
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(JToolBar toolBar) {
        this.toolBar = toolBar;
    }

    protected JButton createActionButton(AnnotationImageAction aa) {
        return this.createActionButton(aa, true);
    }

    protected JButton createActionButton(AnnotationImageAction aa, boolean initState) {
        JButton button = new JButton(aa);
        button.setHorizontalAlignment(0);
        button.setFocusPainted(false);
        button.setBorderPainted(true);
        button.setRequestFocusEnabled(false);
        button.setVisible(initState);
        Icon icon = button.getIcon();
        if (icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            button.setPreferredSize(new Dimension(icon.getIconWidth() + 7, icon.getIconHeight() + 7));
        }
        return button;
    }

    protected void createActions() {
        AnnotationImageAction aa = new AnnotationImageAction(resbundle.getString("ToolbarSave"), resbundle.getString("ToolbarSave"), "/org/concord/swing/images/save.gif", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAnnotationImageContainer.this.saveAnnotationImage();
            }
        });
        this.actions.put("Save", aa);
        aa = new AnnotationImageAction(resbundle.getString("ToolbarOpen"), resbundle.getString("ToolbarOpen"), "/org/concord/swing/images/open.gif", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAnnotationImageContainer.this.importAnnotationImage();
            }
        });
        this.actions.put("Open", aa);
        aa = new AnnotationImageAction(null, resbundle.getString("ToolbarEllipse"), "/org/concord/swing/images/CallOutEllipse.gif", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAnnotationImageContainer.this.setChoosingMode(1);
            }
        });
        this.actions.put("Ellipse", aa);
        aa = new AnnotationImageAction(null, resbundle.getString("ToolbarRectangle"), "/org/concord/swing/images/CallOutRectangle.gif", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAnnotationImageContainer.this.setChoosingMode(0);
            }
        });
        this.actions.put("Rectangle", aa);
        aa = new AnnotationImageAction(null, resbundle.getString("ToolbarPolygon"), "/org/concord/swing/images/CallOutPolygon.gif", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAnnotationImageContainer.this.setChoosingMode(2);
            }
        });
        this.actions.put("Polygon", aa);
        aa = new AnnotationImageAction(null, resbundle.getString("ToolbarDots"), "/org/concord/swing/images/CallOutDots.gif", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAnnotationImageContainer.this.setChoosingMode(3);
            }
        });
        this.actions.put("Dots", aa);
        aa = new AnnotationImageAction(null, resbundle.getString("ToolbarSnapshot"), "/org/concord/swing/images/Album.gif", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        this.actions.put("Snapshot", aa);
        aa = new AnnotationImageAction(null, resbundle.getString("ToolbarAnnotate"), "/org/concord/swing/images/Annotate.gif", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAnnotationImageContainer.this.setEditMode(true);
            }
        });
        this.actions.put("Annotate", aa);
        aa = new AnnotationImageAction(null, resbundle.getString("ToolbarNoAnnotate"), "/org/concord/swing/images/NoAnnotate.gif", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAnnotationImageContainer.this.setEditMode(false);
            }
        });
        this.actions.put("NoAnnotate", aa);
        aa = new AnnotationImageAction(resbundle.getString("ToolbarAnnotateCheckBoxName"), resbundle.getString("ToolbarAnnotateCheckBox"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAnnotationImageContainer.this.setEditMode(!JAnnotationImageContainer.this.isEditMode());
            }
        });
        this.actions.put("AnnotateCheckBox", aa);
    }

    protected void createToolBar() {
        this.setToolBar(new JToolBar(0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setBorderPainted(true);
        this.toolBar.setLayout(new FlowLayout(0, 3, 0));
        this.toolBar.setPreferredSize(new Dimension(0, 30));
        this.toolBar.addSeparator(new Dimension(6, 0));
        JCheckBox annotationCheckBox = new JCheckBox((AnnotationImageAction)this.actions.get("AnnotateCheckBox"));
        annotationCheckBox.setHorizontalAlignment(0);
        annotationCheckBox.setSelected(this.isEditMode());
        this.toolBar.add(annotationCheckBox);
        this.toolBar.addSeparator(new Dimension(6, 0));
        JButton editButton = null;
        if ((this.toolBarMask & 1) != 0) {
            editButton = this.createActionButton((AnnotationImageAction)this.actions.get("Rectangle"));
            editButton.putClientProperty("CHOOSING_MODE", new Integer(0));
            this.choosingModeButtonGroup.add(editButton);
            this.toolBar.add(editButton);
        }
        if ((this.toolBarMask & 2) != 0) {
            editButton = this.createActionButton((AnnotationImageAction)this.actions.get("Ellipse"));
            editButton.putClientProperty("CHOOSING_MODE", new Integer(1));
            this.choosingModeButtonGroup.add(editButton);
            this.toolBar.add(editButton);
        }
        if ((this.toolBarMask & 4) != 0) {
            editButton = this.createActionButton((AnnotationImageAction)this.actions.get("Polygon"));
            editButton.putClientProperty("CHOOSING_MODE", new Integer(2));
            this.choosingModeButtonGroup.add(editButton);
            this.toolBar.add(editButton);
        }
        if ((this.toolBarMask & 8) != 0) {
            editButton = this.createActionButton((AnnotationImageAction)this.actions.get("Dots"));
            editButton.putClientProperty("CHOOSING_MODE", new Integer(3));
            this.choosingModeButtonGroup.add(editButton);
            this.toolBar.add(editButton);
        }
        this.add((Component)this.toolBar, "First");
        this.syncToolBarButtons();
    }

    protected void setLayeredContainer() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.layeredPane, "Center");
        this.createActions();
        this.createToolBar();
    }

    @Override
    public Object getState() {
        this.updateState();
        return this.state;
    }

    @Override
    public void setState(Object s) {
        if (!(s instanceof ImageContainerState)) {
            return;
        }
        this.state = (ImageContainerState)s;
        this.recreateFromState();
    }

    protected void updateState() {
        if (this.state == null) {
            this.state = new ImageContainerState();
        }
        this.state.containerBounds = this.getBounds();
        this.state.annotationImageBounds = this.annotationImage == null ? null : this.annotationImage.getBounds();
        this.state.modelState = this.annotationImage == null ? null : this.annotationImage.getModel().getState();
    }

    protected void recreateFromState() {
        LinkedList annotationSpots;
        if (this.state == null) {
            return;
        }
        JAnnotationImageModel imageModel = new JAnnotationImageModel(this.state.getModelState());
        boolean needEditMode = imageModel.isEditMode();
        this.setAnnotationImage(new JAnnotationImage(this, imageModel));
        this.setBounds(this.state.getContainerBounds());
        this.getAnnotationImage().setBounds(this.state.getAnnotationImageBounds());
        this.getAnnotationImage().checkAnnotationToolTips();
        if (needEditMode != this.getAnnotationImage().isEditMode()) {
            this.setEditMode(needEditMode);
        }
        if ((annotationSpots = this.annotationImage.getAnnotationSpots()) == null) {
            return;
        }
        ListIterator it = annotationSpots.listIterator();
        while (it.hasNext()) {
            JAnnotationImageModel.AnnotationSpot as = (JAnnotationImageModel.AnnotationSpot)it.next();
            as.setAnnotationImage(this.getAnnotationImage());
        }
    }

    public JAnnotationImage getAnnotationImage() {
        return this.annotationImage;
    }

    public void setAnnotationImage(JAnnotationImage annotationImage) {
        boolean fromEmpty;
        boolean bl = fromEmpty = this.annotationImage == null;
        if (annotationImage == this.annotationImage) {
            return;
        }
        boolean oldEditMode = this.isEditMode();
        int oldChoosingMode = this.getChoosingMode();
        Point oldLocation = this.annotationImage != null ? this.annotationImage.getLocation() : null;
        this.discardAnnotationImage();
        if (annotationImage == null) {
            return;
        }
        this.annotationImage = annotationImage;
        this.annotationImage.setEditMode(oldEditMode);
        Dimension id = annotationImage.getSize();
        Dimension d = this.getSize();
        if (oldLocation != null && !fromEmpty) {
            annotationImage.setLocation(oldLocation);
        } else {
            annotationImage.setLocation((d.width - id.width) / 2, (d.height - id.height) / 2);
            this.setAnnotationImageLocation(1, 1);
        }
        this.layeredPane.add(annotationImage);
        this.setChoosingMode(oldChoosingMode);
        this.repaint();
    }

    public void setAnnotationImage(BufferedImage bim) {
        this.setAnnotationImage(bim, null);
    }

    public void setAnnotationImage(BufferedImage bim, String pathToSave) {
        this.discardAnnotationImage();
        JAnnotationImage aim = new JAnnotationImage(this, bim);
        aim.setSize(bim.getWidth(), bim.getHeight());
        this.setAnnotationImage(aim);
        if (pathToSave != null) {
            this.saveImage(bim, pathToSave);
        }
        this.repaint();
    }

    public void setAnnotationImageLocation(Point pt) {
        if (this.annotationImage == null || pt == null) {
            return;
        }
        this.annotationImage.setLocation(pt);
    }

    public void setEditMode(boolean editMode) {
        if (this.annotationImage != null) {
            this.annotationImage.setEditMode(editMode);
        }
        this.syncToolBarButtons();
        this.revalidate();
    }

    protected void syncToolBarButtons() {
        if (this.toolBar == null) {
            return;
        }
        Component[] comps = this.toolBar.getComponents();
        if (comps == null) {
            return;
        }
        Enumeration<AbstractButton> e = this.choosingModeButtonGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            int mode = (Integer)button.getClientProperty("CHOOSING_MODE");
            button.setEnabled(this.isEditMode());
            button.setSelected(mode == this.getChoosingMode());
            if (button.isSelected()) {
                button.setBorder(SELECTED_BORDER);
                button.setBackground(Color.lightGray);
                continue;
            }
            button.setBorder(UNSELECTED_BORDER);
            button.setBackground(this.getBackground());
        }
    }

    public void setToolBarVisible(boolean value) {
        if (value == this.toolBar.isVisible()) {
            return;
        }
        this.toolBar.setVisible(value);
        this.syncToolBarButtons();
        this.layeredPane.revalidate();
    }

    public boolean isEditMode() {
        if (this.annotationImage != null) {
            return this.annotationImage.isEditMode();
        }
        return false;
    }

    public boolean getHtmlSupport() {
        return this.annotationImage == null ? false : this.annotationImage.getHtmlSupport();
    }

    public void setHtmlSupport(boolean htmlSupport) {
        if (this.annotationImage != null) {
            this.annotationImage.setHtmlSupport(htmlSupport);
        }
    }

    public void setChoosingMode(int choosingMode) {
        if (this.annotationImage != null) {
            this.annotationImage.setChoosingMode(choosingMode);
        }
        this.syncToolBarButtons();
    }

    public int getChoosingMode() {
        if (this.annotationImage != null) {
            return this.annotationImage.getChoosingMode();
        }
        return 0;
    }

    public void setToolTipMode(boolean toolTipMode) {
        if (this.annotationImage != null) {
            this.annotationImage.setToolTipMode(toolTipMode);
            this.repaint();
        }
    }

    public boolean isToolTipMode() {
        if (this.annotationImage != null) {
            return this.annotationImage.isToolTipMode();
        }
        return false;
    }

    public void clearAnnotationSpots() {
        if (this.annotationImage != null) {
            this.annotationImage.clearAnnotationSpots();
        }
        this.updateState();
        this.repaint();
    }

    public void deleteSelectedSpot() {
        if (this.annotationImage != null) {
            this.annotationImage.deleteSelectedSpot();
        }
        this.updateState();
        this.repaint();
    }

    public void setAnnotationImageLocation(int x, int y) {
        if (this.annotationImage != null) {
            this.annotationImage.setLocation(x, y);
        }
    }

    public Point getAnnotationImageLocation() {
        if (this.annotationImage != null) {
            return this.annotationImage.getLocation();
        }
        return null;
    }

    public void serializeJava(File file) {
        try {
            this.serializeJava(new FileOutputStream(file));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void serializeJava(OutputStream os) {
        if (this.annotationImage == null || this.annotationImage.getModel() == null) {
            return;
        }
        if (this.annotationImage.getModel().getImageResourceString() == null) {
            this.saveImage(this.getAnnotationImage().getModel().bim, null);
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(this.getState());
            oos.close();
        }
        catch (Throwable t) {
            System.out.println("container serializeJava  Throwable " + t);
            t.printStackTrace();
        }
    }

    public void serializeXML(File file) {
        try {
            this.serializeXML(new FileOutputStream(file));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void serializeXML(OutputStream os) {
        this.serializeXML(os, true);
    }

    public void serializeXML(OutputStream os, boolean askSaveImage) {
        if (this.annotationImage == null || this.annotationImage.getModel() == null) {
            return;
        }
        if (this.annotationImage.getModel().getImageResourceString() == null && askSaveImage) {
            this.saveImage(this.getAnnotationImage().getModel().bim, null);
        }
        try {
            XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(os));
            encoder.setExceptionListener(new ExceptionListener(){

                @Override
                public void exceptionThrown(Exception e) {
                    e.printStackTrace();
                }
            });
            encoder.setPersistenceDelegate(Point2D.Double.class, new DefaultPersistenceDelegate(new String[]{"x", "y"}));
            encoder.writeObject(this.getState());
            encoder.close();
        }
        catch (Throwable t) {
            System.out.println("serializeJava  Throwable " + t);
        }
    }

    public static JAnnotationImageContainer deserializeXML(File file) {
        try {
            return JAnnotationImageContainer.deserializeXML(new FileInputStream(file));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static JAnnotationImageContainer deserializeXML(InputStream is) {
        try {
            XMLDecoder decoder = new XMLDecoder(is);
            return new JAnnotationImageContainer(decoder.readObject());
        }
        catch (Throwable t) {
            System.out.println("deserializeXML Throwable " + t);
            return null;
        }
    }

    public static JAnnotationImageContainer deserializeJava(File file) {
        try {
            return JAnnotationImageContainer.deserializeJava(new FileInputStream(file));
        }
        catch (Throwable t) {
            System.out.println("deserializeJava Throwable " + t);
            return null;
        }
    }

    public static JAnnotationImageContainer deserializeJava(InputStream is) {
        try {
            ObjectInputStream decoder = new ObjectInputStream(is);
            return new JAnnotationImageContainer(decoder.readObject());
        }
        catch (Throwable t) {
            System.out.println("deserializeJava Throwable " + t);
            return null;
        }
    }

    public void dispose() {
        this.discardAnnotationImage();
    }

    protected void discardAnnotationImage() {
        if (this.annotationImage == null) {
            return;
        }
        this.layeredPane.remove(this.annotationImage);
        this.annotationImage.dispose();
    }

    protected void drawAnnotationImageConnections(Graphics g, JAnnotationImageModel.AnnotationSpot as) {
        Point pt = this.annotationImage.getLocation();
        Rectangle ras = as.getBounds();
        Point ptc = as.getAnnotationTipConnectionPoint();
        if (ptc.x == Integer.MIN_VALUE || ptc.y == Integer.MIN_VALUE) {
            return;
        }
        int xc = ptc.x + pt.x;
        int yc = ptc.y + pt.y;
        JComponent jc = as.getAnnotationToolTip();
        if (jc == null) {
            return;
        }
        Rectangle rjc = new Rectangle(jc.getBounds());
        if (rjc.contains(xc, yc)) {
            return;
        }
        Insets jci = jc.getInsets();
        if (jci == null) {
            jci = new Insets(0, 0, 0, 0);
        }
        Color lineColor = Color.gray;
        try {
            Method m = jc.getBorder().getClass().getMethod("getLineColor", null);
            lineColor = (Color)m.invoke((Object)jc.getBorder(), null);
        }
        catch (Throwable m) {
            // empty catch block
        }
        BasicStroke bs = new BasicStroke(1.2f);
        int x10 = jc.getLocation().x;
        int y10 = jc.getLocation().y - 5;
        int x1 = x10 + jci.left;
        int y1 = y10 + (jc.getSize().height - jci.bottom);
        int x2 = x1 + 5;
        int y2 = y1 + 5;
        boolean leftVisible = JAnnotationImageContainer.isVisibleFromPoint(rjc, xc, yc, 3);
        boolean topVisible = JAnnotationImageContainer.isVisibleFromPoint(rjc, xc, yc, 0);
        boolean rightVisible = JAnnotationImageContainer.isVisibleFromPoint(rjc, xc, yc, 1);
        boolean bottomVisible = JAnnotationImageContainer.isVisibleFromPoint(rjc, xc, yc, 2);
        rjc.x += jci.left;
        rjc.y += jci.top;
        rjc.width -= jci.left + jci.right;
        rjc.height -= jci.top + jci.bottom;
        Polygon gp = new Polygon();
        gp.addPoint(xc, yc);
        if (leftVisible && !topVisible && !rightVisible && !bottomVisible) {
            x1 = rjc.x;
            y1 = rjc.y + rjc.height / 2 - 5;
            x2 = rjc.x;
            y2 = rjc.y + rjc.height / 2 + 5;
            gp.addPoint(x1, y1);
            gp.addPoint(x2, y2);
        } else if (leftVisible && topVisible && !rightVisible && !bottomVisible) {
            x1 = rjc.x + 5;
            y1 = rjc.y;
            x2 = rjc.x;
            y2 = rjc.y + 5;
            gp.addPoint(x1, y1);
            gp.addPoint(x2, y1);
            gp.addPoint(x2, y2);
        } else if (!leftVisible && topVisible && !rightVisible && !bottomVisible) {
            x1 = rjc.x + rjc.width / 2 - 5;
            y1 = rjc.y;
            x2 = rjc.x + rjc.width / 2 + 5;
            y2 = rjc.y;
            gp.addPoint(x1, y1);
            gp.addPoint(x2, y2);
        } else if (!leftVisible && topVisible && rightVisible && !bottomVisible) {
            x1 = rjc.x + rjc.width - 5;
            y1 = rjc.y;
            x2 = rjc.x + rjc.width;
            y2 = rjc.y + 5;
            gp.addPoint(x1, y1);
            gp.addPoint(x2, y1);
            gp.addPoint(x2, y2);
        } else if (!leftVisible && !topVisible && rightVisible && !bottomVisible) {
            x1 = rjc.x + rjc.width;
            y1 = rjc.y + rjc.height / 2 - 5;
            x2 = rjc.x + rjc.width;
            y2 = rjc.y + rjc.height / 2 + 5;
            gp.addPoint(x1, y1);
            gp.addPoint(x2, y2);
        } else if (!leftVisible && !topVisible && rightVisible && bottomVisible) {
            x1 = rjc.x + rjc.width - 5;
            y1 = rjc.y + rjc.height;
            x2 = rjc.x + rjc.width;
            y2 = rjc.y + rjc.height - 5;
            gp.addPoint(x1, y1);
            gp.addPoint(x2, y1);
            gp.addPoint(x2, y2);
        } else if (!leftVisible && !topVisible && !rightVisible && bottomVisible) {
            x1 = rjc.x + rjc.width / 2 - 5;
            y1 = rjc.y + rjc.height;
            x2 = rjc.x + rjc.width / 2 + 5;
            y2 = rjc.y + rjc.height;
            gp.addPoint(x1, y1);
            gp.addPoint(x2, y2);
        } else if (leftVisible && !topVisible && !rightVisible && bottomVisible) {
            x1 = rjc.x + 5;
            y1 = rjc.y + rjc.height;
            x2 = rjc.x;
            y2 = rjc.y + rjc.height - 5;
            gp.addPoint(x1, y1);
            gp.addPoint(x2, y1);
            gp.addPoint(x2, y2);
        }
        gp.addPoint(xc, yc);
        Graphics2D gc = (Graphics2D)g.create();
        if (gc == null) {
            return;
        }
        Area clipArea = gc.getClip() != null ? new Area(gc.getClip()) : null;
        gc.setColor(jc.getBackground());
        gc.fillPolygon(gp);
        if (clipArea != null) {
            clipArea.subtract(new Area(rjc));
            gc.setClip(clipArea);
        }
        gc.setColor(lineColor);
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.drawLine(xc, yc, x1, y1);
        gc.drawLine(xc, yc, x2, y2);
        gc.dispose();
    }

    public void paintInLayeredPane(Graphics g) {
        if (this.annotationImage == null) {
            return;
        }
        LinkedList annotationSpots = this.annotationImage.getAnnotationSpots();
        if (annotationSpots == null) {
            return;
        }
        ListIterator it = annotationSpots.listIterator();
        while (it.hasNext()) {
            JAnnotationImageModel.AnnotationSpot as = (JAnnotationImageModel.AnnotationSpot)it.next();
            this.drawAnnotationImageConnections(g, as);
        }
    }

    static boolean isVisibleFromPoint(Rectangle r, int xp, int yp, int type) {
        Point[] pts;
        if (type < 0 || type > 3) {
            return false;
        }
        pts = new Point[]{new Point(r.x, r.y), new Point(r.x + r.width, r.y), new Point(r.x + r.width, r.y + r.height), new Point(r.x, r.y + r.height), pts[0]};
        int xk = (pts[type].x + pts[type + 1].x) / 2;
        int yk = (pts[type].y + pts[type + 1].y) / 2;
        boolean b = false;
        int i = 0;
        while (i < 4) {
            if (i != type && (b |= Line2D.linesIntersect(xp, yp, xk, yk, pts[i].x, pts[i].y, pts[i + 1].x, pts[i + 1].y))) break;
            ++i;
        }
        return !b;
    }

    public static void main(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        frame = new JFrame("Annotation Image");
        BufferedImage bim = null;
        try {
            Robot robot = new Robot();
            bim = robot.createScreenCapture(new Rectangle(0, 0, 500, 500));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        imageContainer = bim != null ? new JAnnotationImageContainer(bim) : new JAnnotationImageContainer();
        imageContainer.setHtmlSupport(false);
        imageContainer.setToolBarMask(15);
        frame.setSize(imageContainer.getSize());
        frame.getContentPane().add((Component)imageContainer, "Center");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent evt) {
                System.exit(0);
            }
        });
        imageContainer.populateMenuBar(frame);
        frame.setVisible(true);
    }

    public void populateMenuBar(JFrame frame) {
        final JAnnotationImageContainer ic = this;
        JFrame finalFrame = frame;
        JMenuBar menubar = new JMenuBar();
        frame.setJMenuBar(menubar);
        JMenu filemenu = new JMenu(resbundle.getString("MenuFile"));
        menubar.add(filemenu);
        AnnotationImageAction act = (AnnotationImageAction)this.actions.get("Open");
        JMenuItem openMenu = new JMenuItem((AnnotationImageAction)this.actions.get("Open"));
        JMenuItem saveMenu = new JMenuItem((AnnotationImageAction)this.actions.get("Save"));
        filemenu.add(openMenu);
        filemenu.add(saveMenu);
        JMenu toolsmenu = new JMenu(resbundle.getString("MenuTools"));
        menubar.add(toolsmenu);
        JMenu menu = new JMenu(resbundle.getString("SubMenuToolbar"));
        JMenuItem mi = new JMenuItem(resbundle.getString("MenuItemOn"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ic.setToolBarVisible(true);
            }
        });
        ((Container)menu).add(mi);
        mi = new JMenuItem(resbundle.getString("MenuItemOff"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ic.setToolBarVisible(false);
            }
        });
        ((Container)menu).add(mi);
        mi = new JMenuItem(resbundle.getString("MenuItemTest"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAnnotationImageContainer.this.getScreenShot();
            }
        });
        ((Container)menu).add(mi);
        toolsmenu.add(menu);
        menu = new JMenu(resbundle.getString("SubMenuEdit"));
        mi = new JMenuItem(resbundle.getString("SubMenuDeleteCurrentSpot"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ic.deleteSelectedSpot();
            }
        });
        ((Container)menu).add(mi);
        ((Container)menu).add(new JSeparator());
        mi = new JMenuItem(resbundle.getString("SubMenuClearAll"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ic.clearAnnotationSpots();
            }
        });
        ((Container)menu).add(mi);
        toolsmenu.add(menu);
        menu = new JMenu(resbundle.getString("SubMenuToolTipMode"));
        mi = new JMenuItem(resbundle.getString("MenuItemOn"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ic.setToolTipMode(true);
            }
        });
        ((Container)menu).add(mi);
        mi = new JMenuItem(resbundle.getString("MenuItemOff"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ic.setToolTipMode(false);
            }
        });
        ((Container)menu).add(mi);
        toolsmenu.add(menu);
    }

    static BufferedImage createBufferedImageFromFile(String imageURLString) {
        BufferedImage bim = null;
        Image image = null;
        try {
            URL imageURL = new URL(imageURLString);
            image = Toolkit.getDefaultToolkit().createImage(imageURL);
            MediaTracker tracker = new MediaTracker(new Component(){});
            tracker.addImage(image, 0);
            try {
                tracker.waitForAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            boolean hasAlpha = gc.getColorModel().hasAlpha();
            bim = hasAlpha ? gc.createCompatibleImage(width, height) : new BufferedImage(width, height, 2);
            Graphics2D g2d = bim.createGraphics();
            g2d.drawImage(image, 0, 0, null);
            g2d.dispose();
        }
        catch (Throwable t) {
            bim = null;
        }
        return bim;
    }

    void createAvailableOutImageFormats() {
        String[] imageNames;
        if (this.availableImageFormats == null) {
            this.availableImageFormats = new HashMap();
        }
        if ((imageNames = ImageIO.getWriterFormatNames()) == null || imageNames.length < 1) {
            return;
        }
        this.availableImageFormats = new HashMap();
        int i = 0;
        while (i < imageNames.length) {
            String key = imageNames[i].trim().toLowerCase();
            if (!this.availableImageFormats.containsKey(key)) {
                this.availableImageFormats.put(key, new ImageFileFilter(imageNames[i]));
            }
            ++i;
        }
    }

    void saveImage(BufferedImage bufferedImage, String pathToSave) {
        if (this.availableImageFormats == null || this.availableImageFormats.size() < 1) {
            return;
        }
        final File fileToSave = pathToSave == null ? null : new File(pathToSave);
        final BufferedImage bim = bufferedImage;
        if (bim == null) {
            return;
        }
        boolean dispatchThread = SwingUtilities.isEventDispatchThread();
        Runnable screenShotRunnable = new Runnable(){

            @Override
            public void run() {
                String fileExtension = null;
                File internalFileToSave = fileToSave;
                if (internalFileToSave != null) {
                    int index = internalFileToSave.getAbsolutePath().lastIndexOf(46);
                    if (index > 0) {
                        fileExtension = internalFileToSave.getAbsolutePath().substring(index + 1);
                    }
                } else {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setAcceptAllFileFilterUsed(false);
                    String userdir = System.getProperty("user.dir");
                    if (userdir != null) {
                        chooser.setCurrentDirectory(new File(userdir));
                    }
                    Iterator it = JAnnotationImageContainer.this.availableImageFormats.keySet().iterator();
                    while (it.hasNext()) {
                        chooser.addChoosableFileFilter((ImageFileFilter)JAnnotationImageContainer.this.availableImageFormats.get(it.next()));
                    }
                    int retValue = chooser.showSaveDialog(SwingUtilities.getRoot(JAnnotationImageContainer.this));
                    if (retValue == 0) {
                        internalFileToSave = chooser.getSelectedFile();
                        FileFilter ff = chooser.getFileFilter();
                        if (ff instanceof ImageFileFilter) {
                            fileExtension = ((ImageFileFilter)ff).fileType;
                        }
                        if (fileExtension == null) {
                            return;
                        }
                        String lowerfilename = internalFileToSave.getName().toLowerCase();
                        if (!lowerfilename.endsWith("." + fileExtension.toLowerCase())) {
                            internalFileToSave = new File(String.valueOf(internalFileToSave.getAbsolutePath()) + "." + fileExtension);
                        }
                    }
                }
                if (internalFileToSave != null && fileExtension != null && (!internalFileToSave.exists() || JAnnotationImageContainer.this.checkForReplace(internalFileToSave))) {
                    try {
                        FileOutputStream fos = new FileOutputStream(internalFileToSave);
                        ImageIO.write((RenderedImage)bim, fileExtension, fos);
                        fos.close();
                        JAnnotationImageContainer.this.getAnnotationImage().getModel().setImageResourceString1(internalFileToSave.getAbsolutePath());
                    }
                    catch (Throwable t) {
                        System.out.println("Save as image THROWABLE " + t);
                        t.printStackTrace();
                    }
                }
            }
        };
        if (dispatchThread) {
            screenShotRunnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(screenShotRunnable);
            }
            catch (Throwable t) {
                System.out.println("makeScreenShot throwable " + t);
            }
        }
    }

    boolean checkForReplace(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        Object[] options = new Object[]{"Yes", "No"};
        return JOptionPane.showOptionDialog(null, "The file '" + file.getName() + "' already exists.  " + "Replace existing file?", "Warning", 0, 2, null, options, options[1]) == 0;
    }

    void importAnnotationImage() {
        boolean dispatchThread = SwingUtilities.isEventDispatchThread();
        Runnable importRunnable = new Runnable(){

            @Override
            public void run() {
                int fileExtensionType = -1;
                File internalFileToSave = null;
                CCJFileChooser chooser = new CCJFileChooser("org/concord/swing/JAnnotationImageContainer");
                chooser.setMultiSelectionEnabled(false);
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.addChoosableFileFilter(new ImageFileFilter("png"));
                chooser.addChoosableFileFilter(new ImageFileFilter("gif"));
                chooser.addChoosableFileFilter(new ImageFileFilter("jpeg"));
                chooser.addChoosableFileFilter(new AnnotationImageFileFilter());
                int retValue = chooser.showOpenDialog(SwingUtilities.getRoot(JAnnotationImageContainer.this));
                if (retValue == 0) {
                    internalFileToSave = chooser.getSelectedFile();
                    FileFilter ff = chooser.getFileFilter();
                    if (ff instanceof ImageFileFilter) {
                        fileExtensionType = 0;
                    } else if (ff instanceof AnnotationImageFileFilter) {
                        fileExtensionType = 1;
                    }
                    if (fileExtensionType < 0) {
                        return;
                    }
                }
                if (internalFileToSave != null && fileExtensionType >= 0 && internalFileToSave.exists() && internalFileToSave.isFile()) {
                    try {
                        if (fileExtensionType == 0) {
                            BufferedImage bim = JAnnotationImageContainer.createBufferedImageFromFile("file:" + internalFileToSave.getCanonicalPath());
                            JAnnotationImageContainer.this.setAnnotationImage(bim);
                        } else if (fileExtensionType == 1) {
                            JAnnotationImageContainer.this.restoreFromFile(internalFileToSave);
                        }
                        JAnnotationImageContainer.this.setHtmlSupport(false);
                    }
                    catch (Throwable t) {
                        System.out.println("Import  image THROWABLE " + t);
                        t.printStackTrace();
                    }
                }
            }
        };
        if (dispatchThread) {
            importRunnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(importRunnable);
            }
            catch (Throwable t) {
                System.out.println("Import throwable " + t);
            }
        }
    }

    public void restoreFromURL(String urlString) {
        try {
            URL url = new URL(urlString);
            this.restoreFromStream(url.openStream());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void restoreFromStream(InputStream is) {
        try {
            byte[] buffer = new byte[1024];
            ZipInputStream zis = new ZipInputStream(is);
            boolean done = false;
            Object state = null;
            BufferedImage bim = null;
            while (!done) {
                try {
                    ZipEntry ze = zis.getNextEntry();
                    boolean bl = done = ze == null;
                    if (done) continue;
                    if (ze.getName().equals("bean.xml")) {
                        XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(this.getByteArrayFromStream(zis)));
                        state = decoder.readObject();
                    } else if (ze.getName().equals("image.png")) {
                        bim = ImageIO.read(new ByteArrayInputStream(this.getByteArrayFromStream(zis)));
                    }
                    done = state != null && bim != null;
                }
                catch (Throwable t) {
                    System.out.println("restoreFromFile from stream " + t);
                    done = true;
                }
            }
            if (state != null) {
                if (bim != null) {
                    Object modelState = ((ImageContainerState)state).getModelState();
                    ((JAnnotationImageModel.ModelState)modelState).imageResourceString = null;
                }
                this.setState(state);
            }
            if (bim != null && this.annotationImage != null && this.annotationImage.getModel() != null) {
                this.annotationImage.getModel().createImage(bim);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void restoreFromFile(File file) {
        try {
            this.restoreFromStream(new FileInputStream(file));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void saveAnnotationImage() {
        this.saveAnnotationImage(null);
    }

    public BufferedImage getImageFromState() {
        ImageContainerState ics;
        Object modelState;
        BufferedImage bimg = null;
        Object containerState = this.getState();
        if (containerState instanceof ImageContainerState && (modelState = (ics = (ImageContainerState)containerState).getModelState()) instanceof JAnnotationImageModel.ModelState) {
            JAnnotationImageModel.ModelState ms = (JAnnotationImageModel.ModelState)modelState;
            bimg = ms.getImage();
        }
        return bimg;
    }

    public void saveAnnotationImage(String pathToSave) {
        boolean dispatchThread = SwingUtilities.isEventDispatchThread();
        final File fileToSave = pathToSave == null ? null : new File(pathToSave);
        Runnable saveRunnable = new Runnable(){

            @Override
            public void run() {
                Object fileExtension = null;
                File internalFileToSave = fileToSave;
                if (internalFileToSave == null) {
                    String lowerfilename;
                    JFileChooser chooser = new JFileChooser();
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setAcceptAllFileFilterUsed(false);
                    String userdir = System.getProperty("user.dir");
                    if (userdir != null) {
                        chooser.setCurrentDirectory(new File(userdir));
                    }
                    chooser.addChoosableFileFilter(new AnnotationImageFileFilter());
                    int retValue = chooser.showSaveDialog(SwingUtilities.getRoot(JAnnotationImageContainer.this));
                    if (retValue == 0 && !(lowerfilename = (internalFileToSave = chooser.getSelectedFile()).getName().toLowerCase()).endsWith(".annimg")) {
                        internalFileToSave = new File(String.valueOf(internalFileToSave.getAbsolutePath()) + ".annimg");
                    }
                }
                if (internalFileToSave != null && (!internalFileToSave.exists() || JAnnotationImageContainer.this.checkForReplace(internalFileToSave))) {
                    try {
                        BufferedImage bim;
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        JAnnotationImageContainer.this.serializeXML(bos, false);
                        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(internalFileToSave));
                        ZipEntry zipEntry = new ZipEntry("bean.xml");
                        zos.putNextEntry(zipEntry);
                        byte[] bytes = bos.toByteArray();
                        zos.write(bytes, 0, bytes.length);
                        zos.closeEntry();
                        if (JAnnotationImageContainer.this.annotationImage != null && JAnnotationImageContainer.this.annotationImage.getModel() != null && (bim = JAnnotationImageContainer.this.annotationImage.getModel().bim) != null) {
                            zipEntry = new ZipEntry("image.png");
                            zos.putNextEntry(zipEntry);
                            ImageIO.write((RenderedImage)bim, "png", zos);
                            zos.closeEntry();
                        }
                        zos.close();
                    }
                    catch (Throwable t) {
                        System.out.println("Save Annotation Image THROWABLE " + t);
                        t.printStackTrace();
                    }
                }
            }
        };
        if (dispatchThread) {
            saveRunnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(saveRunnable);
            }
            catch (Throwable t) {
                System.out.println("saveRunnable throwable " + t);
            }
        }
    }

    private byte[] getByteArrayFromStream(InputStream is) throws IOException {
        int rb;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((rb = is.read(buffer, 0, buffer.length)) > 0) {
            bos.write(buffer, 0, rb);
        }
        bos.close();
        return bos.toByteArray();
    }

    public static class ImageContainerState
    implements Serializable {
        static final long serialVersionUID = 8466245075650346081L;
        Rectangle containerBounds;
        Rectangle annotationImageBounds;
        Object modelState;

        public Rectangle getContainerBounds() {
            return this.containerBounds;
        }

        public void setContainerBounds(Rectangle containerBounds) {
            this.containerBounds = containerBounds;
        }

        public Rectangle getAnnotationImageBounds() {
            return this.annotationImageBounds;
        }

        public void setAnnotationImageBounds(Rectangle annotationImageBounds) {
            this.annotationImageBounds = annotationImageBounds;
        }

        public Object getModelState() {
            return this.modelState;
        }

        public void setModelState(Object modelState) {
            this.modelState = modelState;
        }
    }
}

