/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.concord.swing.event.VariableEvent;
import org.concord.swing.event.VariableListener;

public class ModifyValueDialog
extends JDialog
implements ActionListener {
    protected JTextField variableField = new JTextField();
    protected JLabel label = new JLabel("Variable name:");
    protected JButton doneButton = new JButton("Done");
    protected JButton cancelButton = new JButton("Cancel");
    protected JPanel buttonPanel = new JPanel();
    protected JPanel topPanel = new JPanel();
    protected JPanel valuePanel = new JPanel();
    protected JTextField valueField = new JTextField();
    protected Object value;
    protected Vector listeners = new Vector();
    protected boolean changed = false;
    public static final String VARIABLE_CHANGED = "VARIABLE_CHANGED";

    public ModifyValueDialog(JFrame parent, String title) {
        super(parent, title, true);
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)this.label, "West");
        this.topPanel.add((Component)this.variableField, "Center");
        this.valuePanel.setLayout(new BorderLayout());
        this.valuePanel.add((Component)this.valueField, "North");
        this.buttonPanel.add(this.doneButton);
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.topPanel, "North");
        this.getContentPane().add((Component)this.valuePanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.doneButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.setBounds(200, 200, 400, 104);
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JButton button;
        Object source = event.getSource();
        JButton jButton = button = source instanceof JButton ? (JButton)source : null;
        if (button == this.cancelButton) {
            this.setVariable(null);
            this.setValue("");
        } else if (button == this.doneButton && this.changed) {
            this.notifyVariableValueChanged(this.getValue());
            this.changed = false;
        }
        this.setVisible(false);
    }

    public void setModify(boolean modify) {
        this.variableField.setEditable(!modify);
        this.variableField.setEnabled(!modify);
    }

    public boolean getModify() {
        return !this.variableField.isEditable();
    }

    public String getVariable() {
        return this.variableField.getText();
    }

    public void setVariable(String variable) {
        this.variableField.setText(variable);
    }

    public void setValue(Object value) {
        this.valueField.setText(value == null ? "" : value.toString());
        this.value = value;
    }

    public Object getValue() {
        this.value = this.valueField.getText();
        return this.value;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean value) {
        this.changed = value;
    }

    public void notifyVariableValueChanged(Object newValue) {
        int i = 0;
        while (i < this.listeners.size()) {
            VariableListener listener = (VariableListener)this.listeners.elementAt(i);
            listener.variableValueChanged(new VariableEvent(this, newValue));
            ++i;
        }
    }

    public void notifyVariableNameChanged(String newName) {
        int i = 0;
        while (i < this.listeners.size()) {
            VariableListener listener = (VariableListener)this.listeners.elementAt(i);
            listener.variableNameChanged(new VariableEvent(this, newName));
            ++i;
        }
    }

    public void addVariableListener(VariableListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeVariableListener(VariableListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.removeElement(listener);
        }
    }
}

