/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class MostRecentFileDialog {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int ACCESS_MODE_READ = 0;
    public static final int ACCESS_MODE_WRITE = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    static final String PREFERENCE_DOMAIN = "org/concord/swing/MostRecentFileDialog";
    static final String DEFAULT_PREFERENCES_KEY = "org.concord.swing.MostRecentFileDialog";
    public static boolean USE_SWING_DIALOG_DEFAULT = true;
    String preferencesKey;
    String extension;
    boolean swingOnly = false;
    File currentDirectory;
    File selectedFile;
    private int fileSelectionMode = 0;
    private int fileAccessMode = 0;
    private Component parent;
    private String title;

    public MostRecentFileDialog(String preferencesKey, boolean swingOnly) {
        this.preferencesKey = preferencesKey;
        this.swingOnly = swingOnly;
        this.initCurrentDirectory();
    }

    public MostRecentFileDialog(String preferencesKey) {
        this(preferencesKey, false);
    }

    public MostRecentFileDialog(boolean swingOnly) {
        this(null, swingOnly);
    }

    public MostRecentFileDialog() {
        this(null, false);
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        if (fileSelectionMode != 0 && fileSelectionMode != 2 && fileSelectionMode != 1) {
            throw new IllegalArgumentException("Must be either MostRecentFileDialog.FILES_ONLY, MostRecentFileDialog.FILES_AND_DIRECTORIES, or MostRecentFileDialog.DIRECTORIES_ONLY");
        }
        this.fileSelectionMode = fileSelectionMode;
    }

    public void setFilenameFilter(String extension) {
        this.extension = extension.toLowerCase();
    }

    protected void setCurrentDirectoryInternal(File directory) {
        this.currentDirectory = directory;
    }

    public void setCurrentDirectory(File directory) {
        this.currentDirectory = directory;
        this.saveCurrentDirectory(this.currentDirectory);
    }

    public void setSelectedFile(File currentFile) {
        if (this.useSwingDialog() && this.fileAccessMode == 1) {
            if (currentFile.exists()) {
                int retval = JOptionPane.showConfirmDialog(this.parent, "The file " + currentFile.getName() + " exists. " + "Do you want to overwrite it?", "Warning", 2);
                if (retval == 1 || retval == 2) {
                    this.showSaveDialog(this.parent, this.title);
                } else {
                    this.selectedFile = currentFile;
                }
            } else {
                File temp;
                String name = currentFile.getAbsolutePath();
                if (this.extension != null && !name.endsWith(this.extension)) {
                    name = String.valueOf(name) + "." + this.extension;
                }
                if ((temp = new File(name)).exists()) {
                    this.setSelectedFile(temp);
                } else {
                    this.selectedFile = temp;
                }
            }
        } else {
            this.selectedFile = currentFile;
        }
    }

    public int showOpenDialog(Component parent) {
        return this.showOpenDialog(parent, "Open");
    }

    public int showOpenDialog(Component parent, String title) {
        this.parent = parent;
        this.title = title;
        this.fileAccessMode = 0;
        if (this.useSwingDialog()) {
            JFileChooser fileChooser = new JFileChooser(this.getCurrentDirectory());
            if (this.fileSelectionMode == 1) {
                fileChooser.setFileSelectionMode(1);
            } else if (this.extension != null) {
                fileChooser.setFileFilter(new FileNameFilter(this.extension));
            }
            int returnVal = fileChooser.showOpenDialog(parent);
            if (returnVal == 0) {
                this.setSelectedFile(fileChooser.getSelectedFile());
                this.setCurrentDirectory(fileChooser.getCurrentDirectory());
                return returnVal;
            }
            return returnVal;
        }
        if (parent == null) {
            parent = new Frame();
        }
        Frame frame = (Frame)SwingUtilities.getRoot(parent);
        FileDialog dialog = new FileDialog(frame, "Open", 0);
        if (this.extension != null) {
            dialog.setFilenameFilter(new FileNameFilter(this.extension));
        }
        File currentDir = this.getCurrentDirectory();
        String startingPath = ".";
        if (currentDir != null) {
            startingPath = currentDir.getAbsolutePath();
        }
        dialog.setDirectory(startingPath);
        dialog.show();
        String selectedDirectoryStr = dialog.getDirectory();
        File selectedDirectory = null;
        if (selectedDirectoryStr != null) {
            selectedDirectory = new File(selectedDirectoryStr);
            this.setCurrentDirectory(selectedDirectory);
        }
        File selectedFile = null;
        if (this.fileSelectionMode == 1) {
            selectedFile = selectedDirectory != null ? selectedDirectory : null;
        } else {
            String selectedFileStr = dialog.getFile();
            if (selectedFileStr != null) {
                selectedFile = selectedDirectory != null ? new File(selectedDirectory, selectedFileStr) : new File(selectedFileStr);
            }
        }
        dialog.dispose();
        if (selectedFile != null) {
            this.setSelectedFile(selectedFile);
            return 0;
        }
        return 1;
    }

    public int showSaveDialog(Component parent) {
        return this.showSaveDialog(parent, "Save");
    }

    public int showSaveDialog(Component parent, String title) {
        this.parent = parent;
        this.title = title;
        this.fileAccessMode = 1;
        if (this.useSwingDialog()) {
            int returnVal;
            JFileChooser fileChooser = new JFileChooser(this.getCurrentDirectory());
            if (this.extension != null) {
                fileChooser.setFileFilter(new FileNameFilter(this.extension));
            }
            if ((returnVal = fileChooser.showSaveDialog(parent)) == 0) {
                this.setSelectedFile(fileChooser.getSelectedFile());
                this.setCurrentDirectory(fileChooser.getCurrentDirectory());
                return returnVal;
            }
            return returnVal;
        }
        if (parent == null) {
            parent = new Frame();
        }
        Frame frame = (Frame)SwingUtilities.getRoot(parent);
        FileDialog dialog = new FileDialog(frame, title, 1);
        if (this.extension != null) {
            dialog.setFilenameFilter(new FileNameFilter(this.extension));
        }
        dialog.show();
        String selectedFileStr = null;
        String selectedDirectoryStr = dialog.getDirectory();
        File selectedDirectory = null;
        if (selectedDirectoryStr != null) {
            selectedDirectory = new File(selectedDirectoryStr);
            this.setCurrentDirectory(selectedDirectory);
        }
        selectedFileStr = this.fileSelectionMode == 1 ? selectedDirectoryStr : dialog.getFile();
        dialog.dispose();
        if (selectedFileStr != null) {
            this.setSelectedFile(new File(selectedFileStr));
            return 0;
        }
        return 1;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public boolean useSwingDialog() {
        if (this.swingOnly) {
            return true;
        }
        if (System.getProperty("os.name").startsWith("Mac")) {
            return false;
        }
        return USE_SWING_DIALOG_DEFAULT;
    }

    protected void setPreferencesKey(String preferencesKey) {
        this.preferencesKey = preferencesKey;
    }

    protected String getPreferencesKey() {
        if (this.preferencesKey != null) {
            return this.preferencesKey;
        }
        return DEFAULT_PREFERENCES_KEY;
    }

    protected void initCurrentDirectory() {
        String suggestedPath = null;
        String savedPath = null;
        try {
            Preferences userPreferences = Preferences.userRoot();
            Preferences dialogPreferences = null;
            dialogPreferences = userPreferences.node(PREFERENCE_DOMAIN);
            if (dialogPreferences != null) {
                savedPath = dialogPreferences.get(this.preferencesKey, null);
            }
        }
        catch (Throwable userPreferences) {
            // empty catch block
        }
        if ((suggestedPath = savedPath) != null) {
            try {
                File tmpSuggestedFile = new File(suggestedPath);
                if (!tmpSuggestedFile.exists() || !tmpSuggestedFile.isDirectory()) {
                    suggestedPath = null;
                }
            }
            catch (Throwable t) {
                suggestedPath = null;
            }
        }
        if (suggestedPath == null) {
            try {
                suggestedPath = this.getCurrentDirectory().getCanonicalPath();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (suggestedPath == null) {
            try {
                suggestedPath = System.getProperty("user.dir");
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        File suggestedFile = null;
        suggestedFile = suggestedPath != null ? new File(suggestedPath) : new File(".");
        if (suggestedFile.exists() && suggestedFile.isDirectory()) {
            this.setCurrentDirectoryInternal(suggestedFile);
        }
    }

    protected void saveCurrentDirectory(File currentDirectory) {
        String canonicalPath = null;
        try {
            canonicalPath = currentDirectory.getCanonicalPath();
            Preferences userPreferences = Preferences.userRoot();
            Preferences dialogPreferences = userPreferences.node(PREFERENCE_DOMAIN);
            dialogPreferences.put(this.getPreferencesKey(), canonicalPath);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class FileNameFilter
    extends FileFilter
    implements FilenameFilter {
        String filter;

        public FileNameFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (dir.isDirectory()) {
                return true;
            }
            return name.lastIndexOf(".") != -1 && name.substring(name.lastIndexOf(".")).equalsIgnoreCase("." + this.filter);
        }

        @Override
        public boolean accept(File file) {
            String fileName = file.getAbsolutePath();
            if (file.isDirectory()) {
                return true;
            }
            return fileName.lastIndexOf(".") != -1 && fileName.substring(fileName.lastIndexOf(".")).equalsIgnoreCase("." + this.filter);
        }

        @Override
        public String getDescription() {
            if (this.filter != null && this.filter.length() > 0) {
                return String.valueOf(this.filter) + " files";
            }
            return "all files";
        }
    }
}

