/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class MouseInterceptPanel
extends JComponent
implements MouseListener,
MouseMotionListener {
    protected Component targetComponent;
    protected boolean mousePassThrough = true;
    protected boolean mouseMotionPassThrough = true;
    protected MouseListener mouseIntercept;
    protected MouseMotionListener mouseMotionIntercept;
    protected ComponentAdapter componentAdapter = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            MouseInterceptPanel.this.setSize(MouseInterceptPanel.this.targetComponent.getSize());
        }

        @Override
        public void componentMoved(ComponentEvent event) {
            MouseInterceptPanel.this.setLocation(MouseInterceptPanel.this.targetComponent.getLocation());
        }
    };

    public MouseInterceptPanel() {
        this.setOpaque(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public MouseInterceptPanel(Component component) {
        this();
        this.setTarget(component);
    }

    public void setTarget(Component component) {
        if (this.targetComponent instanceof Component) {
            this.targetComponent.removeComponentListener(this.componentAdapter);
        }
        if (component instanceof Component) {
            this.targetComponent = component;
            this.targetComponent.addComponentListener(this.componentAdapter);
            Container parent = this.targetComponent.getParent();
            if (parent instanceof Container) {
                parent.add((Component)this, 0);
                this.setBounds(this.targetComponent.getBounds());
            }
        }
    }

    public void setMouseIntercept(MouseListener listener) {
        if (this.mouseIntercept instanceof MouseListener) {
            this.removeMouseListener(this.mouseIntercept);
        }
        this.mouseIntercept = listener;
        if (this.mouseIntercept instanceof MouseListener) {
            this.removeMouseListener(this);
            this.addMouseListener(this.mouseIntercept);
            this.mousePassThrough = false;
        } else {
            this.addMouseListener(this);
            this.mousePassThrough = true;
        }
    }

    public void setMouseMotionIntercept(MouseMotionListener listener) {
        if (this.mouseMotionIntercept instanceof MouseMotionListener) {
            this.removeMouseMotionListener(this.mouseMotionIntercept);
        }
        this.mouseMotionIntercept = listener;
        if (this.mouseMotionIntercept instanceof MouseMotionListener) {
            this.removeMouseMotionListener(this);
            this.addMouseMotionListener(this.mouseMotionIntercept);
            this.mouseMotionPassThrough = false;
        } else {
            this.addMouseMotionListener(this);
            this.mouseMotionPassThrough = true;
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.mousePassThrough) {
            this.targetComponent.dispatchEvent(event);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (this.mouseMotionPassThrough) {
            this.targetComponent.dispatchEvent(event);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (this.mouseMotionPassThrough) {
            this.targetComponent.dispatchEvent(event);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.mousePassThrough) {
            this.targetComponent.dispatchEvent(event);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.mousePassThrough) {
            this.targetComponent.dispatchEvent(event);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.mouseMotionPassThrough) {
            this.targetComponent.dispatchEvent(event);
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.mouseMotionPassThrough) {
            this.targetComponent.dispatchEvent(event);
        }
    }
}

