/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.concord.swing.ComponentFramework;
import org.concord.swing.DefaultComponentFramework;
import org.concord.swing.PageComponent;
import org.concord.swing.Selectable;
import org.concord.swing.SelectableContainer;
import org.concord.swing.SelectionManager;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PageView
extends JPanel
implements HyperlinkListener,
SwingConstants {
    private static final long serialVersionUID = 1L;
    protected JToolBar toolBar = new JToolBar(1);
    protected JMenuBar menuBar = new JMenuBar();
    protected JFileChooser imageFileChooser = new JFileChooser();
    protected JFileChooser componentFileChooser = new JFileChooser();
    protected JFileChooser openFileChooser = new JFileChooser();
    protected JFileChooser saveFileChooser = new JFileChooser();
    protected Editor editor;
    protected boolean editable = true;
    protected File currentOpenFile;
    protected JScrollPane scrollPane;
    protected JFrame viewFrame;
    protected PageView viewPage;
    protected Map actionMap = new HashMap();
    protected Map menuMap = new HashMap();
    protected Action insertImage = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent event) {
            if (PageView.this.imageFileChooser.showOpenDialog(PageView.this.editor) == 0) {
                File imageFile = PageView.this.imageFileChooser.getSelectedFile();
                try {
                    URL iconURL = imageFile.toURL();
                    PageView.this.editor.insertIcon(iconURL);
                }
                catch (Exception e) {
                    System.out.println("" + e);
                }
            }
        }
    };
    protected Action insertComponent = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent event) {
            if (PageView.this.componentFileChooser.showOpenDialog(PageView.this.editor) == 0) {
                File componentFile = PageView.this.componentFileChooser.getSelectedFile();
                try {
                    URL componentURL = componentFile.toURL();
                    PageView.this.editor.insertComponent(componentURL);
                }
                catch (Exception e) {
                    System.out.println("" + e);
                }
            }
        }
    };
    protected Action saveAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent event) {
            if (PageView.this.saveFileChooser.showSaveDialog(PageView.this.editor) == 0) {
                File file = PageView.this.saveFileChooser.getSelectedFile();
                try {
                    FileOutputStream output = new FileOutputStream(file);
                    PageView.this.editor.write(output);
                    ((OutputStream)output).close();
                }
                catch (Exception e) {
                    System.out.println("" + e);
                }
            }
        }
    };
    protected Action openAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent event) {
            if (PageView.this.openFileChooser.showOpenDialog(PageView.this.editor) == 0) {
                File file = PageView.this.openFileChooser.getSelectedFile();
                try {
                    PageView.this.currentOpenFile = file;
                    FileInputStream input = new FileInputStream(file);
                    PageView.this.editor.read(input, null);
                    ((InputStream)input).close();
                }
                catch (Exception e) {
                    System.out.println("" + e);
                }
            }
        }
    };
    protected Action viewAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent event) {
            if (PageView.this.currentOpenFile != null && PageView.this.viewPage == null) {
                PageView.this.viewFrame = new JFrame("PageView");
                PageView.this.viewPage = new PageView();
                PageView.this.viewFrame.setDefaultCloseOperation(1);
                PageView.this.viewFrame.getContentPane().add(PageView.this.viewPage);
                PageView.this.viewFrame.setBounds(100, 100, 800, 600);
            }
            try {
                PageView.this.viewPage.setEditable(true);
                PageView.this.viewPage.readInput(new FileInputStream(PageView.this.currentOpenFile));
                PageView.this.viewPage.setEditable(false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            PageView.this.viewFrame.setVisible(true);
        }
    };
    protected String[][] commands;

    public PageView() {
        this(true);
    }

    public PageView(boolean editable) {
        String[][] stringArrayArray = new String[28][];
        String[] stringArray = new String[5];
        stringArray[0] = "OpenAction";
        stringArray[1] = "Open";
        stringArray[3] = "Actions";
        stringArray[4] = "images/open.gif";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[5];
        stringArray2[0] = "SaveAction";
        stringArray2[1] = "Save";
        stringArray2[3] = "Actions";
        stringArray2[4] = "images/save.gif";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = "ViewAction";
        stringArray3[1] = "View";
        stringArray3[3] = "Actions";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[5];
        stringArray4[0] = "copy-to-clipboard";
        stringArray4[1] = "Copy";
        stringArray4[3] = "Edit";
        stringArray4[4] = "images/copy.gif";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[5];
        stringArray5[0] = "cut-to-clipboard";
        stringArray5[1] = "Cut";
        stringArray5[3] = "Edit";
        stringArray5[4] = "images/cut.gif";
        stringArrayArray[4] = stringArray5;
        String[] stringArray6 = new String[5];
        stringArray6[0] = "paste-from-clipboard";
        stringArray6[1] = "Paste";
        stringArray6[3] = "Edit";
        stringArray6[4] = "images/paste.gif";
        stringArrayArray[5] = stringArray6;
        String[] stringArray7 = new String[5];
        stringArray7[0] = "separator";
        stringArray7[3] = "Edit";
        stringArrayArray[6] = stringArray7;
        String[] stringArray8 = new String[5];
        stringArray8[0] = "select-all";
        stringArray8[1] = "Select All";
        stringArray8[3] = "Edit";
        stringArrayArray[7] = stringArray8;
        stringArrayArray[8] = new String[]{"left-justify", "Left", "Edit", "Align", "images/AlignLeft.gif"};
        stringArrayArray[9] = new String[]{"center-justify", "Center", "Edit", "Align", "images/AlignCenter.gif"};
        stringArrayArray[10] = new String[]{"right-justify", "Right", "Edit", "Align", "images/AlignRight.gif"};
        String[] stringArray9 = new String[5];
        stringArray9[0] = "font-size-8";
        stringArray9[1] = "8";
        stringArray9[2] = "Font";
        stringArray9[3] = "Size";
        stringArrayArray[11] = stringArray9;
        String[] stringArray10 = new String[5];
        stringArray10[0] = "font-size-10";
        stringArray10[1] = "10";
        stringArray10[2] = "Font";
        stringArray10[3] = "Size";
        stringArrayArray[12] = stringArray10;
        String[] stringArray11 = new String[5];
        stringArray11[0] = "font-size-12";
        stringArray11[1] = "12";
        stringArray11[2] = "Font";
        stringArray11[3] = "Size";
        stringArrayArray[13] = stringArray11;
        String[] stringArray12 = new String[5];
        stringArray12[0] = "font-size-14";
        stringArray12[1] = "14";
        stringArray12[2] = "Font";
        stringArray12[3] = "Size";
        stringArrayArray[14] = stringArray12;
        String[] stringArray13 = new String[5];
        stringArray13[0] = "font-size-16";
        stringArray13[1] = "16";
        stringArray13[2] = "Font";
        stringArray13[3] = "Size";
        stringArrayArray[15] = stringArray13;
        String[] stringArray14 = new String[5];
        stringArray14[0] = "font-size-18";
        stringArray14[1] = "18";
        stringArray14[2] = "Font";
        stringArray14[3] = "Size";
        stringArrayArray[16] = stringArray14;
        String[] stringArray15 = new String[5];
        stringArray15[0] = "font-size-24";
        stringArray15[1] = "24";
        stringArray15[2] = "Font";
        stringArray15[3] = "Size";
        stringArrayArray[17] = stringArray15;
        String[] stringArray16 = new String[5];
        stringArray16[0] = "font-size-36";
        stringArray16[1] = "36";
        stringArray16[2] = "Font";
        stringArray16[3] = "Size";
        stringArrayArray[18] = stringArray16;
        String[] stringArray17 = new String[5];
        stringArray17[0] = "font-size-48";
        stringArray17[1] = "48";
        stringArray17[2] = "Font";
        stringArray17[3] = "Size";
        stringArrayArray[19] = stringArray17;
        String[] stringArray18 = new String[5];
        stringArray18[0] = "font-family-Serif";
        stringArray18[1] = "Serif";
        stringArray18[2] = "Font";
        stringArray18[3] = "Family";
        stringArrayArray[20] = stringArray18;
        String[] stringArray19 = new String[5];
        stringArray19[0] = "font-family-SansSerif";
        stringArray19[1] = "SansSerif";
        stringArray19[2] = "Font";
        stringArray19[3] = "Family";
        stringArrayArray[21] = stringArray19;
        String[] stringArray20 = new String[5];
        stringArray20[0] = "font-family-Monospaced";
        stringArray20[1] = "Monospaced";
        stringArray20[2] = "Font";
        stringArray20[3] = "Family";
        stringArrayArray[22] = stringArray20;
        stringArrayArray[23] = new String[]{"font-bold", "Bold", "Font", "Style", "images/Bold.gif"};
        stringArrayArray[24] = new String[]{"font-italic", "Italic", "Font", "Style", "images/Italic.gif"};
        stringArrayArray[25] = new String[]{"font-underline", "Underline", "Font", "Style", "images/Underline.gif"};
        String[] stringArray21 = new String[5];
        stringArray21[0] = "InsertImage";
        stringArray21[1] = "Image";
        stringArray21[3] = "Insert";
        stringArray21[4] = "images/InsertPicture.gif";
        stringArrayArray[26] = stringArray21;
        String[] stringArray22 = new String[5];
        stringArray22[0] = "InsertComponent";
        stringArray22[1] = "Component";
        stringArray22[3] = "Insert";
        stringArray22[4] = "images/InsertComponent.gif";
        stringArrayArray[27] = stringArray22;
        this.commands = stringArrayArray;
        this.setLayout(new BorderLayout());
        this.editor = new Editor(editable);
        this.scrollPane = new JScrollPane(this.editor);
        this.initializeCommands();
        this.setEditable(editable);
    }

    protected void initializeCommands() {
        this.actionMap.put("InsertImage", this.insertImage);
        this.actionMap.put("InsertComponent", this.insertComponent);
        this.actionMap.put("OpenAction", this.openAction);
        this.actionMap.put("SaveAction", this.saveAction);
        this.actionMap.put("ViewAction", this.viewAction);
        Action[] actions = this.editor.getEditorKit().getActions();
        int i = 0;
        while (i < actions.length) {
            String name = actions[i].getValue("Name").toString();
            this.actionMap.put(name, actions[i]);
            ++i;
        }
        i = 0;
        while (i < this.commands.length) {
            String[] command = this.commands[i];
            Action action = (Action)this.actionMap.get(command[0]);
            URL imageURL = null;
            JMenu parentMenu = null;
            JMenu menu = null;
            JMenuItem item = null;
            if (command[2] != null && (parentMenu = (JMenu)this.menuMap.get(command[2])) == null) {
                parentMenu = new JMenu(command[2]);
                this.menuMap.put(command[2], parentMenu);
                this.menuBar.add(parentMenu);
            }
            if ((menu = (JMenu)this.menuMap.get(command[3])) == null) {
                menu = new JMenu(command[3]);
                this.menuMap.put(command[3], menu);
                if (parentMenu != null) {
                    parentMenu.add(menu);
                } else {
                    this.menuBar.add(menu);
                }
            }
            if (command[1] != null) {
                item = menu.add(action);
                item.setText(command[1]);
            }
            if (command[4] != null) {
                imageURL = this.getClass().getResource(command[4]);
                JButton button = this.toolBar.add(action);
                button.setText(null);
                button.setIcon(new ImageIcon(imageURL));
                if (item != null) {
                    item.setIcon(button.getIcon());
                }
            }
            if (command[0].equals("separator")) {
                menu.addSeparator();
            }
            ++i;
        }
        this.toolBar.setFloatable(true);
        this.add((Component)this.scrollPane, "Center");
    }

    public void readInput(InputStream input) {
        this.editor.read(input, null);
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean value) {
        this.editable = value;
        if (this.editable) {
            this.add((Component)this.toolBar, "West");
            this.add((Component)this.menuBar, "North");
        } else {
            this.remove(this.toolBar);
            this.remove(this.menuBar);
        }
        this.editor.setEditable(this.editable);
        this.validate();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("PageView");
        PageView view = new PageView();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(view);
        frame.setBounds(100, 100, 800, 600);
        frame.setVisible(true);
    }

    public static class Editor
    extends JTextPane
    implements SelectableContainer,
    CaretListener {
        private static final long serialVersionUID = 1L;
        protected DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        protected DocumentBuilder builder;
        protected StyleContext styleContext = StyleContext.getDefaultStyleContext();
        protected Style sectionStyle = this.styleContext.addStyle("Section", null);
        protected Style paragraphStyle = this.styleContext.addStyle("Paragraph", this.sectionStyle);
        protected Style contentStyle = this.styleContext.addStyle("Content", this.paragraphStyle);
        protected StyleMethods styleMethods = new StyleMethods();
        protected Map componentMap = new HashMap();
        protected Map iconMap = new HashMap();
        protected Map locationMap = new HashMap();
        protected SelectionManager selectionManager = new SelectionManager();
        protected ComponentFramework state = new DefaultComponentFramework();

        public Editor(boolean editable) {
            this.builderFactory.setValidating(false);
            this.setMargin(new Insets(5, 5, 5, 5));
            super.setEditable(true);
            this.selectionManager.setSelectableContainer(this);
            this.addCaretListener(this);
            try {
                this.builder = this.builderFactory.newDocumentBuilder();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }

        @Override
        public void setEditable(boolean value) {
            super.setEditable(value);
            if (this.componentMap != null) {
                for (PageComponent pageComponent : this.componentMap.keySet()) {
                    pageComponent.setEditable(value);
                }
            }
        }

        public void insertIcon(URL iconURL) {
            ImageIcon icon = new ImageIcon(iconURL);
            super.insertIcon(icon);
            this.iconMap.put(icon, iconURL);
        }

        public void insertComponent(URL componentURL) {
            PageComponent component = new PageComponent(componentURL);
            component.setSelectionManager(this.selectionManager);
            super.insertComponent(component);
            this.componentMap.put(component, componentURL);
        }

        public void write(OutputStream outputStream) {
            AbstractDocument doc = (AbstractDocument)this.getDocument();
            javax.swing.text.Element root = doc.getDefaultRootElement();
            Document document = this.builder.newDocument();
            this.writeTree(root, document, document);
            try {
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.setOutputProperty("indent", "yes");
                t.setOutputProperty("method", "xml");
                t.setOutputProperty("omit-xml-declaration", "yes");
                t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                t.transform(new DOMSource(document), new StreamResult(outputStream));
            }
            catch (Exception e) {
                System.out.println("write = " + e);
            }
        }

        protected void writeElement(javax.swing.text.Element element, Document document, Node parent, Object key, Map map) {
            AttributeSet attributes = element.getAttributes();
            Object value = attributes.getAttribute(key);
            URL url = (URL)map.get(value);
            Element xmlElement = document.createElement(key.toString());
            parent.appendChild(xmlElement);
            xmlElement.setAttribute("href", url.toString());
            xmlElement.setAttribute("start", "" + element.getStartOffset());
            xmlElement.setAttribute("end", "" + element.getEndOffset());
        }

        protected void writeIconElement(javax.swing.text.Element element, Document document, Node parent) {
            Object iconKey = StyleConstants.CharacterConstants.IconAttribute;
            this.writeElement(element, document, parent, iconKey, this.iconMap);
        }

        protected void writeComponentElement(javax.swing.text.Element element, Document document, Node parent) {
            Object componentKey = StyleConstants.CharacterConstants.ComponentAttribute;
            this.writeElement(element, document, parent, componentKey, this.componentMap);
        }

        protected void writeTree(javax.swing.text.Element element, Document document, Node parent) {
            String elementName = element.getName();
            if (elementName.equals("icon")) {
                this.writeIconElement(element, document, parent);
            } else if (elementName.equals("component")) {
                this.writeComponentElement(element, document, parent);
            } else {
                Element xmlElement = document.createElement(elementName);
                parent.appendChild(xmlElement);
                if (parent == document) {
                    try {
                        StringWriter writer = new StringWriter();
                        super.write(writer);
                        String data = writer.toString();
                        CDATASection dataNode = document.createCDATASection(data);
                        document.getDocumentElement().appendChild(dataNode);
                    }
                    catch (Exception e) {
                        System.out.println("writeData = " + e);
                    }
                }
                Enumeration<?> eNames = ((AttributeSet)((Object)element)).getAttributeNames();
                while (eNames.hasMoreElements()) {
                    Object name = eNames.nextElement();
                    if (name.toString().equals("resolver")) continue;
                    Object value = ((AttributeSet)((Object)element)).getAttribute(name);
                    xmlElement.setAttribute(name.toString(), value.toString());
                }
                if (element.isLeaf()) {
                    xmlElement.setAttribute("start", "" + element.getStartOffset());
                    xmlElement.setAttribute("end", "" + element.getEndOffset());
                } else {
                    int i = 0;
                    while (i < element.getElementCount()) {
                        javax.swing.text.Element childElement = element.getElement(i);
                        this.writeTree(childElement, document, xmlElement);
                        ++i;
                    }
                }
            }
        }

        protected void installComponents() {
            for (String urlString : this.locationMap.keySet()) {
                Integer location = (Integer)this.locationMap.get(urlString);
                int start = location;
                DefaultStyledDocument doc = (DefaultStyledDocument)this.getDocument();
                try {
                    URL componentURL = new URL(urlString);
                    doc.remove(start, 1);
                    int dot = this.getCaret().getDot();
                    this.getCaret().setDot(start);
                    this.insertComponent(componentURL);
                    this.getCaret().setDot(dot);
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void read(InputStream input, Object desc) {
            this.removeCaretListener(this);
            try {
                Document document = this.builder.parse(new InputSource(input));
                this.readTree(document, document);
                this.installComponents();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addCaretListener(this);
        }

        protected void readDocumentElement(Node node, Style style) {
            style.removeAttributes(style);
            NamedNodeMap attributes = node.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Node attributeNode = attributes.item(i);
                String nodeName = attributeNode.getNodeName();
                String nodeValue = attributeNode.getNodeValue();
                this.styleMethods.set(style, nodeName, nodeValue);
                ++i;
            }
        }

        protected void readContentElement(Node node) {
            this.contentStyle.removeAttributes(this.contentStyle);
            NamedNodeMap attributes = node.getAttributes();
            Node attributeNode = attributes.getNamedItem("start");
            int start = Integer.decode(attributeNode.getNodeValue());
            attributeNode = attributes.getNamedItem("end");
            int end = Integer.decode(attributeNode.getNodeValue());
            DefaultStyledDocument doc = (DefaultStyledDocument)this.getDocument();
            int i = 0;
            while (i < attributes.getLength()) {
                attributeNode = attributes.item(i);
                String nodeName = attributeNode.getNodeName();
                String nodeValue = attributeNode.getNodeValue();
                if (!nodeName.equals("start") && !nodeName.equals("end")) {
                    this.styleMethods.set(this.contentStyle, nodeName, nodeValue);
                }
                ++i;
            }
            try {
                int length = end - start;
                if (length > 0 && end <= doc.getLength()) {
                    String text = doc.getText(start, length);
                    doc.replace(start, length, text, this.contentStyle);
                    doc.setParagraphAttributes(start, length, this.paragraphStyle, false);
                }
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        protected void readIconElement(Node node) {
            NamedNodeMap xmlAttributes = node.getAttributes();
            Node attributeNode = xmlAttributes.getNamedItem("href");
            String urlString = attributeNode.getNodeValue();
            attributeNode = xmlAttributes.getNamedItem("start");
            int start = Integer.decode(attributeNode.getNodeValue());
            DefaultStyledDocument doc = (DefaultStyledDocument)this.getDocument();
            try {
                URL iconURL = new URL(urlString);
                doc.remove(start, 1);
                int dot = this.getCaret().getDot();
                this.getCaret().setDot(start);
                this.insertIcon(iconURL);
                this.getCaret().setDot(dot);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected void readComponentElement(Node node) {
            NamedNodeMap xmlAttributes = node.getAttributes();
            Node attributeNode = xmlAttributes.getNamedItem("href");
            String urlString = attributeNode.getNodeValue();
            attributeNode = xmlAttributes.getNamedItem("start");
            int start = Integer.decode(attributeNode.getNodeValue());
            this.locationMap.put(urlString, new Integer(start));
        }

        public void readTree(Document document, Node node) {
            if (node instanceof CDATASection) {
                try {
                    String text = node.getNodeValue();
                    StringReader reader = new StringReader(text);
                    super.read(reader, null);
                }
                catch (Exception text) {}
            } else {
                if (node.getNodeName().equals("section")) {
                    this.readDocumentElement(node, this.sectionStyle);
                } else if (node.getNodeName().equals("paragraph")) {
                    this.readDocumentElement(node, this.paragraphStyle);
                } else if (node.getNodeName().equals("content")) {
                    this.readContentElement(node);
                } else if (node.getNodeName().equals("icon")) {
                    this.readIconElement(node);
                } else if (node.getNodeName().equals("component")) {
                    this.readComponentElement(node);
                }
                NodeList list = node.getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    node = list.item(i);
                    this.readTree(document, node);
                    ++i;
                }
            }
        }

        @Override
        public Selectable findSelectable(MouseEvent event, int x, int y) {
            return (Selectable)event.getSource();
        }

        @Override
        public Selectable getActiveObject() {
            return null;
        }

        @Override
        public Point getOffset() {
            return null;
        }

        @Override
        public void select(Selectable selectable, boolean multiple) {
            selectable.setSelected(true);
        }

        @Override
        public void deselect() {
        }

        @Override
        public void dragAction(int dx, int dy, Selectable selectable) {
        }

        @Override
        public void dragActionDone(Selectable selectable) {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            Selectable selected;
            if (this.selectionManager != null && (selected = this.selectionManager.getSelectedObject()) != null) {
                selected.setSelected(false);
            }
        }
    }

    public static class StyleMethods {
        protected Map getters = new HashMap();
        protected Map setters = new HashMap();
        protected final String SET = "set";
        protected final String GET = "get";
        protected final String IS = "is";
        protected final String FONT = "font";
        protected final Class[][] primitives = new Class[][]{{Integer.TYPE, Integer.class}, {Long.TYPE, Long.class}, {Short.TYPE, Short.class}, {Byte.TYPE, Byte.class}, {Float.TYPE, Float.class}, {Double.TYPE, Double.class}, {Character.TYPE, Character.class}, {Boolean.TYPE, Boolean.class}};
        protected Map typeMap = new HashMap();

        public StyleMethods() {
            Method[] methods = StyleConstants.class.getMethods();
            int i = 0;
            while (i < methods.length) {
                Method method = methods[i];
                String methodName = method.getName();
                if (methodName.startsWith("get")) {
                    this.createProperty(methodName, "get".length(), method, this.getters);
                } else if (methodName.startsWith("is")) {
                    this.createProperty(methodName, "is".length(), method, this.getters);
                } else if (methodName.startsWith("set")) {
                    this.createProperty(methodName, "set".length(), method, this.setters);
                }
                ++i;
            }
            i = 0;
            while (i < this.primitives.length) {
                this.typeMap.put(this.primitives[i][0], this.primitives[i][1]);
                ++i;
            }
        }

        protected Class getTypeClass(Class type) {
            Class typeClass = (Class)this.typeMap.get(type);
            if (typeClass == null) {
                return type;
            }
            return typeClass;
        }

        protected void createProperty(String methodName, int prefixLength, Method method, Map table) {
            String propertyName = methodName.substring(prefixLength);
            propertyName = String.valueOf(Character.toLowerCase(propertyName.charAt(0))) + propertyName.substring(1);
            table.put(propertyName, method);
            if (propertyName.startsWith("font")) {
                propertyName = propertyName.substring("font".length());
                propertyName = String.valueOf(Character.toLowerCase(propertyName.charAt(0))) + propertyName.substring(1);
                table.put(propertyName, method);
            }
        }

        public Object get(AttributeSet attributeSet, String propertyName) {
            Method method = (Method)this.getters.get(propertyName = String.valueOf(Character.toLowerCase(propertyName.charAt(0))) + propertyName.substring(1));
            if (method != null) {
                try {
                    return method.invoke(null, attributeSet);
                }
                catch (IllegalArgumentException e) {
                    System.out.println(e);
                }
                catch (IllegalAccessException e) {
                    System.out.println(e);
                }
                catch (InvocationTargetException e) {
                    System.out.println(e);
                }
            }
            return null;
        }

        public void set(MutableAttributeSet attributeSet, String propertyName, Object value) {
            Method method = (Method)this.setters.get(propertyName = String.valueOf(Character.toLowerCase(propertyName.charAt(0))) + propertyName.substring(1));
            if (method != null) {
                try {
                    if (value instanceof String) {
                        Class<?>[] argClasses = method.getParameterTypes();
                        Class argType = this.getTypeClass(argClasses[1]);
                        Constructor constructor = argType.getConstructor(String.class);
                        value = constructor.newInstance(value);
                    }
                    method.invoke(null, attributeSet, value);
                }
                catch (IllegalArgumentException e) {
                    System.out.println(e);
                }
                catch (IllegalAccessException e) {
                    System.out.println(e);
                }
                catch (InvocationTargetException e) {
                    System.out.println(e);
                }
                catch (NoSuchMethodException e) {
                    System.out.println(e);
                }
                catch (InstantiationException e) {
                    System.out.println(e);
                }
            }
        }
    }
}

