/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import org.concord.swing.CoordinateTransformer;

class ParentComponentTransformer
implements CoordinateTransformer {
    Component destinationComponent;
    Component sourceComponent;

    ParentComponentTransformer() {
    }

    ParentComponentTransformer(Component destinationComponent, Component sourceComponent) {
        this.destinationComponent = destinationComponent;
        this.sourceComponent = sourceComponent;
    }

    @Override
    public Point2D transform(Point2D p2d) {
        if (this.destinationComponent == null || this.sourceComponent == null || p2d == null) {
            return p2d;
        }
        Point pt = new Point((int)Math.round(p2d.getX()), (int)Math.round(p2d.getY()));
        return SwingUtilities.convertPoint(this.sourceComponent, pt, this.destinationComponent);
    }

    public void setSourceComponent(Component sourceComponent) {
        this.sourceComponent = sourceComponent;
    }

    public void setDestinationComponent(Component destinationComponent) {
        this.destinationComponent = destinationComponent;
    }
}

