/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.concord.swing.ModifyPathDialog;

public class PathDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public static final String JAVA_HOME = "java.home";
    public static final String USER_DIR = "user.dir";
    public static final String OS_NAME = "os.name";
    public static final String PREFIX_BREAK = "$";
    protected JList pathList = new JList();
    protected Vector paths = new Vector();
    protected JButton doneButton = new JButton("Done");
    protected JButton addButton = new JButton("Add");
    protected JButton modifyButton = new JButton("Modify");
    protected JButton removeButton = new JButton("Remove");
    protected JButton upButton = new JButton("Move Up");
    protected JButton downButton = new JButton("Move Down");
    protected JButton javaHomeButton = new JButton();
    protected JPanel controlPanel = new JPanel();
    protected String javaHome;
    protected JScrollPane listScroll = new JScrollPane(this.pathList);
    protected JFileChooser selectPathChooser = new JFileChooser();
    protected ModifyPathDialog modifyPathDialog;
    protected Properties prefixTable = new Properties();
    protected JPanel contentPane;
    protected String selectedItem;

    public PathDialog(JFrame frame) {
        super(frame, "Add and Remove Path Components", true);
        this.addPrefix(USER_DIR, System.getProperty(USER_DIR, ""));
        this.setJavaHome(System.getProperty(JAVA_HOME, ""));
        this.modifyPathDialog = new ModifyPathDialog(frame);
        this.controlPanel.setLayout(new GridLayout(0, 1));
        this.controlPanel.add(this.doneButton);
        this.controlPanel.add(this.addButton);
        this.controlPanel.add(this.modifyButton);
        this.controlPanel.add(this.removeButton);
        this.controlPanel.add(this.upButton);
        this.controlPanel.add(this.downButton);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.listScroll, "Center");
        this.contentPane.add((Component)this.controlPanel, "East");
        this.contentPane.add((Component)this.javaHomeButton, "South");
        this.doneButton.addActionListener(this);
        this.addButton.addActionListener(this);
        this.modifyButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.javaHomeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.pathList.addListSelectionListener(this);
        this.selectPathChooser.setMultiSelectionEnabled(false);
        this.selectPathChooser.setCurrentDirectory(new File(System.getProperty(USER_DIR)));
        this.setLocation(200, 200);
        this.pack();
    }

    public void addPrefix(String prefix, String value) {
        this.prefixTable.put(prefix, value);
    }

    protected String substitutePrefix(String element) {
        StringTokenizer tokens = new StringTokenizer(element, PREFIX_BREAK);
        if (tokens.hasMoreTokens()) {
            String pathPrefix;
            String prefix = tokens.nextToken();
            if (tokens.hasMoreTokens()) {
                element = tokens.nextToken();
            }
            if ((pathPrefix = this.prefixTable.getProperty(prefix)) == null) {
                pathPrefix = System.getProperty(prefix, "");
            }
            return String.valueOf(pathPrefix) + element;
        }
        return element;
    }

    protected String removePrefix(String element, String toRemove) {
        String prefix;
        StringTokenizer tokens = new StringTokenizer(element, PREFIX_BREAK);
        if (tokens.hasMoreTokens() && toRemove.equals(prefix = tokens.nextToken()) && tokens.hasMoreTokens()) {
            element = tokens.nextToken().substring(1);
        }
        return element;
    }

    protected String matchPrefix(String element) {
        Enumeration<Object> enumer = this.prefixTable.keys();
        while (enumer.hasMoreElements()) {
            String key = (String)enumer.nextElement();
            String value = (String)this.prefixTable.get(key);
            if (!element.startsWith(value)) continue;
            element = element.substring(value.length());
            element = String.valueOf(key) + PREFIX_BREAK + element;
            break;
        }
        return element;
    }

    public String getPath(boolean expand) {
        return this.getPath(expand, null);
    }

    public String getPath(boolean expand, String toRemove) {
        String path = "";
        int n = this.paths.size();
        int i = 0;
        while (i < n) {
            String pathElement = (String)this.paths.elementAt(i);
            if (toRemove instanceof String) {
                pathElement = this.removePrefix(pathElement, toRemove);
            }
            if (expand) {
                pathElement = this.substitutePrefix(pathElement);
            }
            path = String.valueOf(path) + pathElement;
            if (i < n - 1) {
                path = String.valueOf(path) + File.pathSeparator;
            }
            ++i;
        }
        System.out.println(path);
        return path;
    }

    public String getPath() {
        return this.getPath(true, USER_DIR);
    }

    public void setPath(String path) {
        if (path instanceof String && path.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(path, ";");
            this.paths.removeAllElements();
            while (tokens.hasMoreTokens()) {
                this.paths.addElement(tokens.nextToken());
            }
            this.selectedItem = null;
            this.pathList.setListData(this.paths);
        }
    }

    public void addToPath(String pathElement) {
        if (pathElement instanceof String) {
            pathElement = this.matchPrefix(pathElement);
            this.paths.addElement(pathElement);
            this.pathList.setListData(this.paths);
        }
    }

    public void addToPath(String prefix, String partialPath) {
        if (partialPath instanceof String) {
            this.paths.addElement(String.valueOf(prefix) + PREFIX_BREAK + partialPath);
            this.pathList.setListData(this.paths);
        }
    }

    public void setJavaHome(String path) {
        File javaDir = new File(path);
        if (javaDir.exists() && javaDir.isDirectory()) {
            this.javaHome = path;
            this.javaHomeButton.setText("Set Java Home Directory: " + this.javaHome);
            this.prefixTable.put(JAVA_HOME, path);
        }
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JButton button;
        Object source = event.getSource();
        JButton jButton = button = source instanceof JButton ? (JButton)source : null;
        if (button == this.doneButton) {
            this.setVisible(false);
        } else if (button == this.addButton) {
            this.selectPathChooser.setFileSelectionMode(2);
            this.selectPathChooser.showDialog(this, "Select Path");
            File selectedFile = this.selectPathChooser.getSelectedFile();
            try {
                this.selectedItem = selectedFile.getCanonicalPath();
                this.selectedItem = this.matchPrefix(this.selectedItem);
                this.paths.addElement(this.selectedItem);
                this.pathList.setListData(this.paths);
                this.pathList.setSelectedValue(this.selectedItem, true);
            }
            catch (Exception exception) {}
        } else if (button == this.modifyButton) {
            int index = this.paths.indexOf(this.selectedItem);
            this.modifyPathDialog.setPathElement(this.selectedItem);
            this.modifyPathDialog.show();
            this.selectedItem = this.modifyPathDialog.getPathElement();
            this.paths.setElementAt(this.selectedItem, index);
            this.pathList.setSelectedValue(this.selectedItem, true);
        } else if (button == this.removeButton) {
            if (this.selectedItem instanceof String) {
                this.paths.removeElement(this.selectedItem);
                this.selectedItem = null;
                this.pathList.setListData(this.paths);
            }
        } else if (button == this.upButton) {
            int index;
            if (this.selectedItem instanceof String && (index = this.paths.indexOf(this.selectedItem)) > 0) {
                this.paths.removeElementAt(index);
                this.paths.insertElementAt(this.selectedItem, index - 1);
                this.pathList.setSelectedValue(this.selectedItem, true);
            }
        } else if (button == this.downButton) {
            if (this.selectedItem instanceof String) {
                int index = this.paths.indexOf(this.selectedItem);
                int n = this.paths.size();
                if (index > -1 && index < n - 1) {
                    this.paths.removeElementAt(index);
                    this.paths.insertElementAt(this.selectedItem, index + 1);
                    this.pathList.setSelectedValue(this.selectedItem, true);
                }
            }
        } else if (button == this.javaHomeButton) {
            this.selectPathChooser.setFileSelectionMode(2);
            this.selectPathChooser.showDialog(this, "Select Java Home");
            File selectedFile = this.selectPathChooser.getSelectedFile();
            try {
                String javaDir = selectedFile.getCanonicalPath();
                if (javaDir.indexOf(PREFIX_BREAK) > -1) {
                    int length = this.selectPathChooser.getCurrentDirectory().toString().length();
                    javaDir = this.selectedItem.substring(length + 1);
                }
                this.setJavaHome(javaDir);
            }
            catch (Exception e) {
                this.setJavaHome(System.getProperty(JAVA_HOME));
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        Object object = event.getSource();
        if (object instanceof JList) {
            JList list = (JList)object;
            this.selectedItem = (String)list.getSelectedValue();
            boolean haveSelection = this.selectedItem instanceof String;
            this.removeButton.setEnabled(haveSelection);
            this.upButton.setEnabled(haveSelection);
            this.downButton.setEnabled(haveSelection);
        }
    }
}

