/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JFrame;

public class QuickHull {
    Point[] originalPoints;
    int fullSteps = 0;
    Vector hullPoints = new Vector();
    static int nDots = 500;
    static int offset = 50;
    static int sizeX = 400;
    static int sizeY = 400;
    static double r = (double)sizeX / 2.0 - (double)offset;
    static double xc = (double)sizeX / 2.0;
    static double yc = (double)sizeY / 2.0;
    static QuickHull qh;

    public QuickHull(Point[] originalPoints) {
        this.originalPoints = originalPoints;
        this.qhull(originalPoints, 0, 0);
        this.reorderPoints(this.hullPoints);
    }

    public Point[] getOriginalPoints() {
        return this.originalPoints;
    }

    public Vector getHullPointsAsVector() {
        return (Vector)this.hullPoints.clone();
    }

    public Point[] getHullPointsAsArray() {
        if (this.hullPoints == null) {
            return null;
        }
        Point[] hulldots = new Point[this.hullPoints.size()];
        int i = 0;
        while (i < hulldots.length) {
            hulldots[i] = (Point)this.hullPoints.elementAt(i);
            ++i;
        }
        return hulldots;
    }

    void reorderPoints(Vector v) {
        AngleWrapper[] angleWrappers = new AngleWrapper[v.size()];
        double xc = 0.0;
        double yc = 0.0;
        int i = 0;
        while (i < v.size()) {
            Point pt = (Point)v.elementAt(i);
            xc += (double)pt.x;
            yc += (double)pt.y;
            ++i;
        }
        xc /= (double)v.size();
        yc /= (double)v.size();
        i = 0;
        while (i < angleWrappers.length) {
            angleWrappers[i] = QuickHull.createAngleWrapper((Point)v.elementAt(i), xc, yc);
            ++i;
        }
        Arrays.sort(angleWrappers, new AngleComparator());
        v.removeAllElements();
        i = 0;
        while (i < angleWrappers.length) {
            v.add(angleWrappers[i].pt);
            ++i;
        }
    }

    void qhull(Object[] dots0, int up, int step) {
        ++this.fullSteps;
        if (dots0 == null || dots0.length < 1 || step > 200) {
            return;
        }
        if (dots0.length < 2) {
            this.addHullPoint((Point)dots0[0]);
            return;
        }
        try {
            int leftIndex = 0;
            int rightIndex = 0;
            int i = 1;
            while (i < dots0.length) {
                if (((Point)dots0[i]).x < ((Point)dots0[leftIndex]).x) {
                    leftIndex = i;
                }
                if (((Point)dots0[i]).x > ((Point)dots0[rightIndex]).x) {
                    rightIndex = i;
                }
                ++i;
            }
            Point leftPoint = (Point)dots0[leftIndex];
            Point rightPoint = (Point)dots0[rightIndex];
            this.addHullPoint(leftPoint);
            this.addHullPoint(rightPoint);
            if (dots0.length == 3) {
                int middlePoint = -1;
                int i2 = 0;
                while (i2 < dots0.length) {
                    if (i2 != leftIndex && i2 != rightIndex) {
                        middlePoint = i2;
                        break;
                    }
                    ++i2;
                }
                this.addHullPoint((Point)dots0[middlePoint]);
            } else if (dots0.length > 3) {
                int upIndex;
                Vector vIn = new Vector();
                Vector vOut = new Vector();
                if (up >= 0 && (upIndex = QuickHull.selectPoints(dots0, leftPoint, rightPoint, true, vIn)) >= 0 && vIn.size() > 0) {
                    Point upPoint = (Point)vIn.elementAt(upIndex);
                    vOut.removeAllElements();
                    QuickHull.selectPoints(vIn, leftPoint, upPoint, true, vOut);
                    this.qhull(vOut.toArray(), 1, step + 1);
                    vOut.removeAllElements();
                    QuickHull.selectPoints(vIn, upPoint, rightPoint, true, vOut);
                    this.qhull(vOut.toArray(), 1, step + 1);
                }
                if (up <= 0) {
                    vIn.removeAllElements();
                    int downIndex = QuickHull.selectPoints(dots0, rightPoint, leftPoint, false, vIn);
                    if (downIndex >= 0 && vIn.size() > 0) {
                        Point downPoint = (Point)vIn.elementAt(downIndex);
                        vOut.removeAllElements();
                        QuickHull.selectPoints(vIn, rightPoint, downPoint, false, vOut);
                        this.qhull(vOut.toArray(), -1, step + 1);
                        vOut.removeAllElements();
                        QuickHull.selectPoints(vIn, downPoint, leftPoint, false, vOut);
                        this.qhull(vOut.toArray(), -1, step + 1);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void addHullPoint(Point pt) {
        if (!this.hullPoints.contains(pt)) {
            this.hullPoints.add(pt);
        }
    }

    static int selectPoints(Object[] pIn, Point pLeft, Point pRight, boolean up, Vector vOut) {
        int retValue = -1;
        if (pIn == null || vOut == null) {
            return retValue;
        }
        double k = (double)(pRight.y - pLeft.y) / (double)(pRight.x - pLeft.x);
        double A = -k;
        double B = 1.0;
        double C = k * (double)pLeft.x - (double)pLeft.y;
        double dup = 0.0;
        int i = 0;
        while (i < pIn.length) {
            Point pt = (Point)pIn[i];
            if (!pt.equals(pLeft) && !pt.equals(pRight)) {
                int px = pt.x;
                int py = pt.y;
                double y = (double)pLeft.y + k * (double)(px - pLeft.x);
                if (!up && y < (double)py || up && y > (double)py) {
                    vOut.add(pt);
                    double d = A * (double)px + B * (double)py + C;
                    if (d < 0.0) {
                        d = -d;
                    }
                    if (d > dup) {
                        dup = d;
                        retValue = vOut.size() - 1;
                    }
                }
            }
            ++i;
        }
        vOut.add(pLeft);
        vOut.add(pRight);
        return retValue;
    }

    static int selectPoints(Vector vIn, Point pLeft, Point pRight, boolean up, Vector vOut) {
        int retValue = -1;
        if (vIn == null || vOut == null) {
            return retValue;
        }
        double k = (double)(pRight.y - pLeft.y) / (double)(pRight.x - pLeft.x);
        double A = -k;
        double B = 1.0;
        double C = k * (double)pLeft.x - (double)pLeft.y;
        double dup = 0.0;
        int i = 0;
        while (i < vIn.size()) {
            Point pt = (Point)vIn.elementAt(i);
            if (!pt.equals(pLeft) && !pt.equals(pRight)) {
                int px = pt.x;
                int py = pt.y;
                double y = (double)pLeft.y + k * (double)(px - pLeft.x);
                if (!up && y < (double)py || up && y > (double)py) {
                    vOut.add(pt);
                    double d = A * (double)px + B * (double)py + C;
                    if (d < 0.0) {
                        d = -d;
                    }
                    if (d > dup) {
                        dup = d;
                        retValue = vOut.size() - 1;
                    }
                }
            }
            ++i;
        }
        vOut.add(pLeft);
        vOut.add(pRight);
        return retValue;
    }

    static AngleWrapper createAngleWrapper(Point pt, double xc, double yc) {
        double angle = Math.atan2((double)pt.y - yc, (double)pt.x - xc);
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return new AngleWrapper(angle, new Point(pt));
    }

    static void initDots() {
        Point[] dots = new Point[nDots];
        int i = 0;
        while (i < dots.length) {
            int px = (int)Math.round((double)offset + (double)(sizeX - 2 * offset) * Math.random());
            int py = (int)Math.round((double)offset + (double)(sizeY - 2 * offset) * Math.random());
            dots[i] = new Point(px, py);
            ++i;
        }
        qh = new QuickHull(dots);
        System.out.println("hullPoints " + QuickHull.qh.hullPoints.size() + " fullSteps " + QuickHull.qh.fullSteps);
    }

    static void drawDots(Graphics g) {
        if (qh == null) {
            return;
        }
        g.setColor(Color.gray);
        Point[] dots = qh.getOriginalPoints();
        int i = 0;
        while (i < dots.length) {
            Point pt = dots[i];
            g.fillRect(pt.x, pt.y, 3, 3);
            ++i;
        }
        g.setColor(Color.red);
        Vector outPoints = qh.getHullPointsAsVector();
        int i2 = 0;
        while (i2 < outPoints.size()) {
            Point ptPrev;
            Point pt = (Point)outPoints.elementAt(i2);
            g.fillRect(pt.x, pt.y, 3, 3);
            if (i2 > 0) {
                ptPrev = (Point)outPoints.elementAt(i2 - 1);
                g.drawLine(ptPrev.x, ptPrev.y, pt.x, pt.y);
            }
            if (i2 == outPoints.size() - 1) {
                ptPrev = (Point)outPoints.elementAt(0);
                g.drawLine(ptPrev.x, ptPrev.y, pt.x, pt.y);
            }
            ++i2;
        }
    }

    public static void main(String[] args) {
        JFrame frame1 = new JFrame("test"){
            boolean wasInited = false;

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (!this.wasInited) {
                    QuickHull.initDots();
                    this.wasInited = true;
                }
                QuickHull.drawDots(g);
            }
        };
        frame1.setSize(sizeX, sizeY);
        frame1.setVisible(true);
    }

    static class AngleComparator
    implements Comparator {
        AngleComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (!(obj1 instanceof AngleWrapper) || !(obj2 instanceof AngleWrapper)) {
                return 0;
            }
            AngleWrapper ac1 = (AngleWrapper)obj1;
            AngleWrapper ac2 = (AngleWrapper)obj2;
            return ac1.angle < ac2.angle ? -1 : 1;
        }
    }

    static class AngleWrapper
    implements Comparable {
        double angle;
        Point pt;

        AngleWrapper(double angle, Point pt) {
            this.angle = angle;
            this.pt = pt;
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof AngleWrapper)) {
                return 0;
            }
            AngleWrapper ac = (AngleWrapper)obj;
            return ac.angle < this.angle ? -1 : 1;
        }
    }
}

