/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;

public class RecordBuffer {
    protected byte[] bytes = null;
    protected char[] chars = null;
    protected int index = 0;
    protected int count = 0;
    protected RecordEvent recordEvent;
    protected Vector listeners = new Vector();

    public RecordBuffer(Class type, int size) {
        if (type == Byte.TYPE) {
            this.bytes = new byte[size];
        } else {
            this.chars = new char[size];
        }
        this.recordEvent = new RecordEvent(this);
    }

    public RecordBuffer(int size) {
        this(Byte.TYPE, size);
    }

    protected void notifyRecordListeners(int value) {
        int i = 0;
        while (i < this.listeners.size()) {
            RecordListener listener = (RecordListener)this.listeners.get(i);
            this.recordEvent.setValue(value);
            listener.valueRecorded(this.recordEvent);
            ++i;
        }
    }

    public void addRecordListener(RecordListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeRecordListener(RecordListener listener) {
        this.listeners.remove(listener);
    }

    protected String getBufferString(int i, int n) {
        return this.bytes != null ? new String(this.bytes, i, n) : new String(this.chars, i, n);
    }

    public String getText() {
        int length;
        String text = this.getBufferString(0, this.index);
        int n = length = this.bytes != null ? this.bytes.length : this.chars.length;
        if (this.count >= length) {
            text = String.valueOf(this.getBufferString(this.index, length - this.index)) + text;
        }
        return text;
    }

    public void put(int value) {
        int length = 0;
        if (this.bytes != null) {
            this.bytes[this.index] = (byte)value;
            length = this.bytes.length;
        } else {
            this.chars[this.index] = (char)value;
            length = this.chars.length;
        }
        this.index = this.index >= length - 1 ? 0 : this.index + 1;
        ++this.count;
        this.notifyRecordListeners(value);
    }

    public static class RecordEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        protected int value = 0;

        public RecordEvent(Object source) {
            super(source);
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }
    }

    public static interface RecordListener
    extends EventListener {
        public void valueRecorded(RecordEvent var1);
    }
}

