/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.concord.swing.RecordBuffer;
import org.concord.swing.StreamRecord;

public class StreamRecordView
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    protected StreamRecord streamRecord;

    public StreamRecordView(StreamRecord record) {
        this.streamRecord = record;
    }

    public String getText(String tabName) {
        int index = this.indexOfTab(tabName);
        RecordView recordView = (RecordView)this.getComponentAt(index);
        return recordView.getText();
    }

    public InputStream addInputStream(InputStream stream, InputStream shared) {
        return this.addInputStream(stream, null, shared);
    }

    public InputStream addInputStream(InputStream stream, String name) {
        return this.addInputStream(stream, name, null);
    }

    protected InputStream addInputStream(InputStream stream, String name, InputStream shared) {
        InputStream result = (InputStream)this.streamRecord.getStream(stream, shared);
        if (result instanceof InputStream && shared == null && name != null) {
            RecordView recordView = new RecordView(this.streamRecord, result);
            this.insertTab(name, null, recordView, "InputStream", 0);
        }
        return result;
    }

    public OutputStream addOutputStream(OutputStream stream, OutputStream shared) {
        return this.addOutputStream(stream, null, shared);
    }

    public OutputStream addOutputStream(OutputStream stream, String name) {
        return this.addOutputStream(stream, name, null);
    }

    protected OutputStream addOutputStream(OutputStream stream, String name, OutputStream shared) {
        OutputStream result = (OutputStream)this.streamRecord.getStream(stream, shared);
        if (result instanceof OutputStream && shared == null && name != null) {
            RecordView recordView = new RecordView(this.streamRecord, result);
            this.insertTab(name, null, recordView, "OutputStream", 0);
        }
        return result;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test RecordView");
        StreamRecord record = new StreamRecord(10000);
        StreamRecordView view = new StreamRecordView(record);
        frame.setDefaultCloseOperation(3);
        System.setIn(view.addInputStream(System.in, "System.in"));
        System.setOut((PrintStream)view.addOutputStream((OutputStream)System.out, "System.out"));
        System.setErr((PrintStream)view.addOutputStream((OutputStream)System.err, System.out));
        int i = 0;
        while (i < 1000) {
            System.out.println("This is line # " + i);
            System.err.println("This is error # " + i);
            ++i;
        }
        frame.getContentPane().add(view);
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    public static class RecordView
    extends JComponent
    implements RecordBuffer.RecordListener {
        private static final long serialVersionUID = 1L;
        protected StreamRecord streamRecord;
        protected Object recordStream;
        protected JTextArea textArea = new JTextArea();
        protected JScrollPane scroll = new JScrollPane(this.textArea);

        public RecordView(StreamRecord record, Object stream) {
            this.streamRecord = record;
            this.recordStream = stream;
            this.setLayout(new BorderLayout());
            this.add((Component)this.scroll, "Center");
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.streamRecord.addRecordListener(this.recordStream, this);
            this.textArea.setText(this.streamRecord.getText(this.recordStream));
            this.repaint();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.streamRecord.removeRecordListener(this.recordStream, this);
        }

        public String getText() {
            return this.streamRecord.getText(this.recordStream);
        }

        @Override
        public void valueRecorded(RecordBuffer.RecordEvent event) {
            if (event.getValue() == 10 || event.getValue() == 13) {
                this.textArea.setText(this.streamRecord.getText(this.recordStream));
                this.repaint();
            }
        }
    }
}

