/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class SwingTableCellRenderer
extends JLabel
implements TableCellRenderer,
Serializable {
    private Hashtable colors;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;

    public SwingTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    public void setBackground(Color color, int row) {
        if (color == null) {
            return;
        }
        if (this.colors == null) {
            this.colors = new Hashtable();
        }
        this.colors.put(new Integer(row), color);
    }

    public void clearBackground(int row) {
        if (this.colors == null) {
            return;
        }
        Integer key = new Integer(row);
        if (this.colors.containsKey(key)) {
            this.colors.remove(key);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            Color rowColor;
            Color color = rowColor = this.colors == null ? null : (Color)this.colors.get(new Integer(row));
            if (rowColor == null) {
                rowColor = this.unselectedBackground != null ? this.unselectedBackground : table.getBackground();
            }
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(rowColor);
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setValue(value);
        Color back = this.getBackground();
        boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
        this.setOpaque(!colorMatch);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }

    public static class UIResource
    extends SwingTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

