/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class TabularView
extends JComponent {
    protected Vector rows = new Vector();
    protected int columnCount = 0;
    protected int[] columnWidths;
    protected Dimension totalSize = new Dimension(0, 0);
    protected Dimension pad = new Dimension(10, 5);

    public TabularView() {
        this.setLayout(null);
        this.setPreferredSize(this.totalSize);
        this.setFont(new Font("SanSerif", 0, 12));
    }

    public void addRow(String[] values) {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        if (this.columnWidths == null) {
            this.columnCount = values.length;
            this.columnWidths = new int[this.columnCount];
        }
        if (values.length == this.columnCount) {
            JLabel[] row = new JLabel[this.columnCount];
            this.rows.addElement(row);
            int i = 0;
            while (i < this.columnCount) {
                row[i] = new JLabel(values[i]);
                row[i].setFont(this.getFont());
                row[i].setForeground(this.getForeground());
                this.columnWidths[i] = Math.max(this.columnWidths[i], metrics.stringWidth(values[i]));
                this.add(row[i]);
                ++i;
            }
            int n = this.rows.size();
            int offsetX = 0;
            int offsetY = 0;
            int i2 = 0;
            while (i2 < n) {
                row = (JLabel[])this.rows.elementAt(i2);
                int j = 0;
                while (j < this.columnCount) {
                    row[j].setSize(this.columnWidths[j] + this.pad.width, metrics.getHeight() + this.pad.height);
                    row[j].setLocation(offsetX, offsetY);
                    offsetX += this.columnWidths[j] + this.pad.width;
                    ++j;
                }
                offsetY += metrics.getHeight() + this.pad.height;
                offsetX = 0;
                ++i2;
            }
            this.totalSize.width = offsetX;
            this.totalSize.height = offsetY;
        }
    }

    public void setColumnAlignment(int column, int align) {
        if (column < this.columnCount) {
            int n = this.rows.size();
            int i = 0;
            while (i < n) {
                JLabel[] row = (JLabel[])this.rows.elementAt(i);
                row[column].setHorizontalAlignment(align);
                ++i;
            }
        }
    }

    public void setPadding(int h, int v) {
        this.pad.width = h;
        this.pad.height = v;
    }

    public Dimension getPadding() {
        return this.pad;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.totalSize;
    }

    public void clear() {
        this.removeAll();
        this.rows.removeAllElements();
        this.columnCount = 0;
        this.totalSize.width = 0;
        this.totalSize.height = 0;
        this.columnWidths = null;
    }
}

