/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;

public class ViewEditor
extends JComponent {
    protected int mouseX;
    protected int mouseY;
    protected int dragX;
    protected int dragY;
    protected boolean selected;
    protected boolean dragged = false;
    protected Vector selectionList = new Vector();
    protected Vector viewList = new Vector();
    protected Vector freeList = new Vector();
    protected Hashtable componentToEditor = new Hashtable();
    protected Hashtable editorToComponent = new Hashtable();
    protected SelectionBoundary boundary = new SelectionBoundary(this);
    protected SelectionHandle handle = null;
    protected Component targetComponent;
    protected Container container;
    protected Component popupComponent;
    protected MouseAdapter mouseAdapter = new MouseAdapter(){
        boolean popup = false;

        @Override
        public void mousePressed(MouseEvent event) {
            boolean multiple = false;
            ViewEditor.this.mouseX = event.getX();
            ViewEditor.this.mouseY = event.getY();
            ViewEditor.this.handle = ViewEditor.this.findHandle(ViewEditor.this.mouseX, ViewEditor.this.mouseY);
            if (ViewEditor.this.handle == null) {
                ViewEditor.this.deselect();
            }
            ViewEditor.this.select(multiple);
            if (ViewEditor.this.handle == null) {
                int i = 0;
                while (i < ViewEditor.this.viewList.size()) {
                    ViewEditor editor = (ViewEditor)ViewEditor.this.viewList.elementAt(i);
                    Rectangle b = editor.getBounds();
                    int x = ViewEditor.this.mouseX;
                    int y = ViewEditor.this.mouseY;
                    if (b.contains(ViewEditor.this.mouseX, ViewEditor.this.mouseY)) {
                        editor.select(multiple);
                    }
                    ++i;
                }
            }
            ViewEditor.this.getParent().repaint();
            this.popup = event.isPopupTrigger();
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if ((this.popup || event.isPopupTrigger()) && ViewEditor.this.popupComponent instanceof Component) {
                ViewEditor.this.popupComponent.setVisible(true);
            } else if (ViewEditor.this.dragged && ViewEditor.this.getParent() instanceof ViewEditor) {
                ViewEditor.this.setBounds(ViewEditor.this.boundary.getBounds());
                ViewEditor.this.dragged = false;
                ViewEditor.this.getParent().repaint();
            }
        }
    };
    protected MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

        @Override
        public void mouseDragged(MouseEvent event) {
            ViewEditor.this.dragAction(event);
        }
    };
    protected ComponentAdapter targetAdapter = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            if (ViewEditor.this.targetComponent instanceof Component) {
                ViewEditor.this.targetComponent.setSize(ViewEditor.this.getSize());
                ViewEditor.this.getParent().repaint();
            }
        }

        @Override
        public void componentMoved(ComponentEvent event) {
            if (ViewEditor.this.targetComponent instanceof Component) {
                ViewEditor.this.targetComponent.setLocation(ViewEditor.this.getLocation());
                ViewEditor.this.getParent().repaint();
            }
        }
    };
    protected ComponentAdapter containerAdapter = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            if (ViewEditor.this.targetComponent instanceof Component) {
                ViewEditor.this.setSize(ViewEditor.this.targetComponent.getSize());
                ViewEditor.this.repaint();
            }
        }

        @Override
        public void componentMoved(ComponentEvent event) {
            if (ViewEditor.this.targetComponent instanceof Component) {
                ViewEditor.this.setLocation(ViewEditor.this.targetComponent.getLocation());
                ViewEditor.this.repaint();
            }
        }
    };

    protected SelectionHandle findHandle(int x, int y) {
        this.handle = null;
        int i = 0;
        while (i < this.selectionList.size()) {
            ViewEditor view = (ViewEditor)this.selectionList.elementAt(i);
            this.handle = view.getBoundary().findHandle(x, y);
            if (this.handle != null) break;
            ++i;
        }
        return this.handle;
    }

    public void deselect() {
        int i = 0;
        while (i < this.selectionList.size()) {
            ((ViewEditor)this.selectionList.elementAt(i)).deselect();
            ++i;
        }
        this.selectionList.removeAllElements();
        this.selected = false;
    }

    public void select(boolean multiple) {
        if (this.getParent() instanceof ViewEditor) {
            ViewEditor parentView = (ViewEditor)this.getParent();
            Vector list = parentView.selectionList;
            if (!multiple) {
                int i = 0;
                while (i < list.size()) {
                    ((ViewEditor)list.elementAt((int)i)).selected = false;
                    ++i;
                }
                list.removeAllElements();
                this.selected = true;
                parentView.select(multiple);
            }
            list.addElement(this);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void delete() {
        if (this.getParent() instanceof ViewEditor) {
            ViewEditor parentView = (ViewEditor)this.getParent();
            parentView.remove(this);
            Vector list = (Vector)this.viewList.clone();
            int i = 0;
            while (i < list.size()) {
                ViewEditor childView = (ViewEditor)list.elementAt(i);
                childView.delete();
                ++i;
            }
            parentView.viewList.removeElement(this);
            parentView.selectionList.removeElement(this);
            this.viewList.removeAllElements();
            this.selectionList.removeAllElements();
            this.boundary = null;
            this.handle = null;
        }
    }

    protected void moveAction(ViewEditor view, int deltaX, int deltaY) {
        this.dragged = true;
        if (view.selected) {
            Rectangle b = view.getBounds();
            view.setLocation(b.x + deltaX, b.y + deltaY);
        }
    }

    protected void dragAction(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        int deltaX = x - this.mouseX;
        int deltaY = y - this.mouseY;
        if (this.handle != null) {
            if (this.handle.getPosition() == 8) {
                ViewEditor view = this.handle.parent.getParent();
                this.moveAction(view, deltaX, deltaY);
            } else {
                this.handle.scale(deltaX, deltaY);
            }
        } else {
            int i = 0;
            while (i < this.viewList.size()) {
                ViewEditor view = (ViewEditor)this.viewList.elementAt(i);
                this.moveAction(view, deltaX, deltaY);
                ++i;
            }
        }
        this.mouseX = x;
        this.mouseY = y;
        this.getParent().repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        int i = 0;
        while (i < this.viewList.size()) {
            ViewEditor view = (ViewEditor)this.viewList.elementAt(i);
            view.boundary.draw(g);
            ++i;
        }
    }

    public ViewEditor(Container container) {
        this();
        this.setContainer(container);
    }

    public ViewEditor() {
        this.setOpaque(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container container = this.getParent();
        if (container instanceof ViewEditor) {
            if (this.targetComponent instanceof Component) {
                this.setBounds(this.targetComponent.getBounds());
            }
            this.addComponentListener(this.targetAdapter);
        } else {
            ViewEditor editor;
            int i = 0;
            while (i < this.viewList.size()) {
                editor = (ViewEditor)this.viewList.elementAt(i);
                editor.setTarget(null);
                editor.removeComponentListener(this.targetAdapter);
                this.freeList.addElement(editor);
                ++i;
            }
            this.viewList.removeAllElements();
            Component[] components = container.getComponents();
            int i2 = 0;
            while (i2 < components.length) {
                if (components[i2] != this) {
                    editor = this.freeList.size() > 0 ? (ViewEditor)this.freeList.remove(0) : new ViewEditor();
                    editor.setTarget(components[i2]);
                    this.add(editor);
                    this.viewList.addElement(editor);
                }
                ++i2;
            }
        }
    }

    public void setContainer(Container container) {
        if (this.container instanceof Container) {
            this.container.removeComponentListener(this.containerAdapter);
            this.container.remove(this);
            this.removeMouseListener(this.mouseAdapter);
            this.removeMouseMotionListener(this.mouseMotionAdapter);
        }
        this.setTarget(container);
        this.container = container;
        if (this.container instanceof Container) {
            this.container.addComponentListener(this.containerAdapter);
            this.addMouseListener(this.mouseAdapter);
            this.addMouseMotionListener(this.mouseMotionAdapter);
            this.setBounds(this.container.getBounds());
        }
    }

    public void setPopupComponent(Component popup) {
        this.popupComponent = popup;
    }

    @Override
    public void addComponentListener(ComponentListener listener) {
        if (this.getParent() instanceof ViewEditor) {
            super.addComponentListener(listener);
        } else {
            int i = 0;
            while (i < this.viewList.size()) {
                ViewEditor editor = (ViewEditor)this.viewList.elementAt(i);
                editor.addComponentListener(listener);
                ++i;
            }
        }
    }

    @Override
    public void removeComponentListener(ComponentListener listener) {
        if (this.getParent() instanceof ViewEditor) {
            super.removeComponentListener(listener);
        } else {
            int i = 0;
            while (i < this.viewList.size()) {
                ViewEditor editor = (ViewEditor)this.viewList.elementAt(i);
                editor.removeComponentListener(listener);
                ++i;
            }
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public void setTarget(Component component) {
        this.targetComponent = component;
    }

    public Component getTarget() {
        return this.targetComponent;
    }

    public Vector getViewList() {
        return this.viewList;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        if (this.boundary instanceof SelectionBoundary) {
            this.boundary.setBounds(bounds);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.boundary instanceof SelectionBoundary) {
            this.boundary.setBounds(x, y, width, height);
        }
    }

    public SelectionBoundary getBoundary() {
        return this.boundary;
    }

    public void setHandleSize(int width, int height) {
        this.boundary.setHandleSize(width, height);
    }

    public static class SelectionBoundary
    extends Rectangle {
        protected int handleWidth = 6;
        protected int handleHeight = 6;
        protected SelectionHandle[] handles = new SelectionHandle[9];
        protected ViewEditor parent;

        public SelectionBoundary(ViewEditor view) {
            this.parent = view;
        }

        @Override
        public void setBounds(Rectangle b) {
            this.setBounds(b.x, b.y, b.width, b.height);
        }

        public void setHandleSize(int width, int height) {
            this.handleWidth = width;
            this.handleHeight = height;
            int i = 0;
            while (i < this.handles.length) {
                if (this.handles[i] == null) {
                    this.handles[i] = new SelectionHandle(this, i, this.handleWidth, this.handleHeight);
                } else {
                    this.handles[i].setSize(this.handleWidth, this.handleHeight);
                }
                ++i;
            }
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(--x, --y, ++width, ++height);
            this.setHandleSize(this.handleWidth, this.handleHeight);
            int i = 0;
            while (i < this.handles.length) {
                this.handles[i].setHandleBounds(x, y, width, height);
                ++i;
            }
        }

        @Override
        public Rectangle getBounds() {
            Rectangle b = this.parent.getBounds();
            b.x = this.x + 1;
            b.y = this.y + 1;
            b.width = this.width - 1;
            b.height = this.height - 1;
            return b;
        }

        @Override
        public void translate(int dx, int dy) {
            super.translate(dx, dy);
            Rectangle b = this.getBounds();
            int i = 0;
            while (i < this.handles.length) {
                this.handles[i].setHandleBounds(b.x + dx, b.y + dy, this.width, this.height);
                ++i;
            }
        }

        public ViewEditor getParent() {
            return this.parent;
        }

        public SelectionHandle findHandle(int x, int y) {
            int i = 0;
            while (i < this.handles.length) {
                if (this.handles[i].contains(x, y)) {
                    return this.handles[i];
                }
                ++i;
            }
            return null;
        }

        public void draw(Graphics g) {
            g.drawRect(this.x, this.y, this.width, this.height);
            if (this.parent.selected) {
                int i = 0;
                while (i < this.handles.length) {
                    Rectangle b = this.handles[i];
                    if (i == 8) {
                        b = this.handles[i].dragBounds;
                        g.drawRect(b.x, b.y, b.width, b.height);
                    } else {
                        g.fillRect(b.x, b.y, b.width, b.height);
                    }
                    ++i;
                }
            }
        }
    }

    public static class SelectionHandle
    extends Rectangle {
        public static final int TOP_LEFT = 0;
        public static final int TOP_MIDDLE = 1;
        public static final int TOP_RIGHT = 2;
        public static final int MIDDLE_RIGHT = 3;
        public static final int BOTTOM_RIGHT = 4;
        public static final int BOTTOM_MIDDLE = 5;
        public static final int BOTTOM_LEFT = 6;
        public static final int MIDDLE_LEFT = 7;
        public static final int DRAG = 8;
        public static final int HANDLE_WIDTH = 6;
        public static final int HANDLE_HEIGHT = 6;
        public static final int MIN_WIDTH = 4;
        public static final int MIN_HEIGHT = 4;
        public static final Rectangle[] scaleFactors = new Rectangle[]{new Rectangle(1, 1, -1, -1), new Rectangle(0, 1, 0, -1), new Rectangle(0, 1, 1, -1), new Rectangle(0, 0, 1, 0), new Rectangle(0, 0, 1, 1), new Rectangle(0, 0, 0, 1), new Rectangle(1, 0, -1, 1), new Rectangle(1, 0, -1, 0), new Rectangle(1, 1, 1, 1)};
        protected Rectangle factors;
        protected int position = -1;
        protected SelectionBoundary parent;
        protected Rectangle dragBounds = new Rectangle();

        public SelectionHandle(SelectionBoundary parent, int position, int w, int h) {
            this.width = w;
            this.height = h;
            this.position = position;
            this.parent = parent;
            this.factors = scaleFactors[position];
        }

        public void scale(int dx, int dy) {
            ViewEditor view = this.parent.getParent();
            Rectangle b = view.getBounds();
            b.width += this.factors.width * dx;
            b.height += this.factors.height * dy;
            if (b.width < 4) {
                b.width = 4;
            } else {
                b.x += this.factors.x * dx;
            }
            if (b.height < 4) {
                b.height = 4;
            } else {
                b.y += this.factors.y * dy;
            }
            view.setBounds(b.x, b.y, b.width, b.height);
        }

        public void setHandleBounds(int x, int y, int w, int h) {
            switch (this.position) {
                case 0: {
                    this.x = x - this.width - 1;
                    this.y = y - this.height - 1;
                    break;
                }
                case 1: {
                    this.x = x + w / 2 + 1 - this.width / 2;
                    this.y = y - this.height - 1;
                    break;
                }
                case 2: {
                    this.x = x + w + 2;
                    this.y = y - this.height - 1;
                    break;
                }
                case 3: {
                    this.x = x + w + 2;
                    this.y = y + h / 2 + 1 - this.height / 2;
                    break;
                }
                case 4: {
                    this.x = x + w + 2;
                    this.y = y + h + 2;
                    break;
                }
                case 5: {
                    this.x = x + w / 2 + 1 - this.width / 2;
                    this.y = y + h + 2;
                    break;
                }
                case 6: {
                    this.x = x - this.width - 1;
                    this.y = y + h + 2;
                    break;
                }
                case 7: {
                    this.x = x - this.width - 1;
                    this.y = y + h / 2 + 1 - this.height / 2;
                    break;
                }
                case 8: {
                    this.dragBounds.x = x - this.width - 1;
                    this.dragBounds.y = y - this.height - 1;
                    this.dragBounds.width = w + 2 * this.width + 2;
                    this.dragBounds.height = h + 2 * this.height + 2;
                }
            }
        }

        @Override
        public boolean contains(int x, int y) {
            if (this.position == 8) {
                return this.dragBounds.contains(x, y);
            }
            return super.contains(x, y);
        }

        public int getPosition() {
            return this.position;
        }
    }
}

