/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import org.concord.swing.MostRecentFileDialog;

public class Zipper {
    public static final int ZIP_MODE_SINGLE_FILE = 1;
    public static final int ZIP_MODE_MULTIPLE_FILES = 2;
    public static final int ZIP_MODE_FOLDER = 3;
    Vector inputs;
    File output;

    public static File zip(Vector files) {
        String msg = "Please specify the zipped file";
        JOptionPane.showMessageDialog(null, msg, "", 1);
        File output = null;
        MostRecentFileDialog mrfd = new MostRecentFileDialog();
        mrfd.setFilenameFilter("zip");
        int retval = mrfd.showSaveDialog(null, "Save as");
        if (retval == 0) {
            output = mrfd.getSelectedFile();
            Zipper.zip(files, output);
        }
        return output;
    }

    public static void zip(Vector files, File output) {
        if (files == null || files.size() == 0) {
            return;
        }
        int size = files.size();
        String[] fns = new String[size];
        int i = 0;
        while (i < size) {
            Object ele = files.elementAt(i);
            if (ele instanceof String) {
                fns[i] = ele.toString();
            } else if (ele instanceof File) {
                try {
                    fns[i] = ((File)ele).getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.err.println("Zip entry must be either File or File name (String)");
            }
            ++i;
        }
        Zipper.zip(fns, output);
    }

    public static void zip(String[] files, String output) {
        Zipper.zip(files, new File(output));
    }

    public static void zip(String input, String output) {
        Zipper.zip(new File(input), new File(output));
    }

    public static void zip(String input, File output) {
        Zipper.zip(new File(input), output);
    }

    public static void zip(File input, String output) {
        Vector<File> v = new Vector<File>(1);
        v.addElement(input);
        Zipper.zip(v, new File(output));
    }

    public static void zip(File input, File output) {
        Vector<File> v = new Vector<File>(1);
        v.addElement(input);
        Zipper.zip(v, output);
    }

    public static void zip(File[] files, File output) {
        if (files == null || files.length == 0) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(output);
            ZipOutputStream zout = new ZipOutputStream(fos);
            byte[] b = new byte[512];
            int i = 0;
            while (i < files.length) {
                if (files[i] != null && files[i].exists()) {
                    String fName = files[i].getCanonicalPath().replace(File.separatorChar, '/');
                    FileInputStream fis = new FileInputStream(files[i]);
                    ZipEntry ze = new ZipEntry(fName);
                    zout.putNextEntry(ze);
                    int len = 0;
                    while ((len = fis.read(b)) != -1) {
                        zout.write(b, 0, len);
                    }
                    zout.closeEntry();
                    Zipper.print(ze);
                    fis.close();
                }
                ++i;
            }
            zout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void zip(File[] files, String output) {
        Zipper.zip(files, new File(output));
    }

    public static void zip(String[] files, File output) {
        if (files == null || files.length == 0) {
            return;
        }
        int length = files.length;
        File[] fs = new File[length];
        int i = 0;
        while (i < length) {
            fs[i] = new File(files[i]);
            ++i;
        }
        Zipper.zip(fs, output);
    }

    public static void zip(Vector files, String output) {
        Zipper.zip(files, new File(output));
    }

    public static void print(ZipEntry e) {
        System.err.print("added " + e.getName());
        if (e.getMethod() == 8) {
            long size = e.getSize();
            if (size > 0L) {
                long csize = e.getCompressedSize();
                long ratio = (size - csize) * 100L / size;
                System.err.println(" (deflated " + ratio + "%)");
            } else {
                System.err.println(" (deflated 0%)");
            }
        } else {
            System.err.println(" (stored 0%)");
        }
    }

    public static void main(String[] args) {
        File f1 = new File("src/org/concord/swing/Zipper.java");
        File f2 = new File("lib/org/concord/swing/Zipper.class");
        File fo = new File("out.zip");
        File[] files = new File[]{f1, f2};
        Vector<File> vector = new Vector<File>();
        vector.addElement(f1);
        vector.addElement(f2);
        String[] strs = new String[]{f1.getAbsolutePath(), f2.getAbsolutePath()};
        Zipper.zip(strs, "out.zip");
    }
}

