/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.concord.swing.about.AboutTextFromHTML;

public class AboutBox
extends JButton
implements ActionListener {
    Component parent;
    JFrame frame;
    String interactiveName;
    String aboutFile;
    static String TYPE = "text/html";

    public AboutBox(String interactiveName) {
        this.interactiveName = interactiveName;
        this.setText("About");
        this.setToolTipText("About " + interactiveName);
        this.setContentAreaFilled(false);
        this.addActionListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AboutBox.this.setUpFrame();
            }
        });
    }

    private void setUpFrame() {
        this.parent = this.getParent();
        this.frame = new JFrame("About " + this.interactiveName);
        this.frame.setSize(600, 400);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation(d.width / 2 - 225, d.height / 2 - 200);
        this.frame.setDefaultCloseOperation(1);
        if (this.parent != null) {
            this.frame.setLocation(this.parent.getLocation());
        }
        Container contentPane = this.frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel closePanel = new JPanel(new FlowLayout());
        JButton close = new JButton("Close");
        closePanel.add(close);
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutBox.this.frame.hide();
            }
        });
        contentPane.add((Component)closePanel, "South");
        try {
            JTabbedPane content = AboutTextFromHTML.getTabbedPane(this.removeSpaces(this.interactiveName));
            content.add((Component)AboutBox.getSystemInformationTab(), "System Information");
            content.setPreferredSize(new Dimension(100, 500));
            contentPane.add((Component)content, "Center");
        }
        catch (Exception e) {
            System.err.println("Exception caught parsing file");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int retVal;
        String message = "Your java vm is not up-todate.\nVersion 1.4 or higher is recommended.\nDo you want to continue?";
        if (System.getProperty("java.vm.version").compareTo("1.3.1") <= 0 && ((retVal = JOptionPane.showConfirmDialog(null, message, "Warning", 1)) == 2 || retVal == -1 || retVal == 1)) {
            return;
        }
        this.frame.show();
    }

    public static String readTextFromJar(String s) {
        StringBuffer everything = new StringBuffer();
        try {
            String thisLine;
            InputStream is = AboutBox.class.getResourceAsStream(s);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                everything.append(thisLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return everything.toString();
    }

    public String removeSpaces(String s) {
        StringTokenizer st = new StringTokenizer(s, " ", false);
        String t = "";
        while (st.hasMoreElements()) {
            t = String.valueOf(t) + st.nextElement();
        }
        return t;
    }

    public static JComponent getSystemInformationTab() {
        StringBuffer sysInfo = new StringBuffer();
        sysInfo.append("<html>");
        sysInfo.append("<p><b>Operating System:</b> ");
        sysInfo.append(String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.version") + "</p>");
        sysInfo.append("<p><b>Java VM Version:</b> ");
        sysInfo.append(String.valueOf(System.getProperty("java.vm.version")) + "</p>");
        sysInfo.append("<p><b>Java VM Vendor:</b> ");
        sysInfo.append(String.valueOf(System.getProperty("java.vm.vendor")) + "</p>");
        sysInfo.append("<p><b>Java VM Path:</b> ");
        sysInfo.append(String.valueOf(System.getProperty("java.home")) + "</p>");
        sysInfo.append("</html>");
        JEditorPane retval = new JEditorPane(TYPE, sysInfo.toString());
        retval.setEditable(false);
        JScrollPane tab = new JScrollPane(retval, 20, 31);
        return tab;
    }

    public static void main(String[] args) {
        JFrame that = new JFrame("About test");
        that.setDefaultCloseOperation(3);
        that.getContentPane().add(new AboutBox("FunctionAnalyzer"));
        that.pack();
        that.show();
    }
}

