/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.beans;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import org.concord.swing.beans.PropertyInterimPanel;

public class PropertyDialog
extends Dialog {
    PropertyInterimPanel pis;
    Button cancelButton;
    Button applyButton;
    int maxSize = 300;

    public PropertyDialog(Object o, String panelName) {
        this(null, o, panelName);
    }

    public PropertyDialog(Frame frame, Object o, String panelName) {
        this(frame, o, panelName, null);
    }

    public PropertyDialog(Frame frame, Object o, String panelName, Hashtable validProps) {
        super(frame, true);
        try {
            this.pis = new PropertyInterimPanel(o, panelName, validProps);
            this.setLayout(null);
            this.add(this.pis);
            this.pis.setLocation(0, 0);
            Dimension d = this.pis.getPreferredSize();
            this.pis.setSize(d);
            this.setSize(d.width, d.height);
            this.setResizable(false);
            this.setTitle("Properties Dialog");
            this.cancelButton = new Button("Cancel");
            this.applyButton = new Button("Apply");
            this.add(this.cancelButton);
            this.add(this.applyButton);
            ButtonListener buttonListener = new ButtonListener();
            this.cancelButton.addActionListener(buttonListener);
            this.applyButton.addActionListener(buttonListener);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PropertyDialog.this.cancelAll();
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    PropertyDialog.this.cancelAll();
                }
            });
        }
        catch (IllegalArgumentException e) {
            Toolkit.getDefaultToolkit().beep();
            throw e;
        }
        catch (Exception e) {
            System.out.println("PropertyDialog Exception " + e);
            e.printStackTrace();
        }
    }

    protected void cancelAll() {
        if (this.pis != null) {
            this.pis.restoreOldValues();
        }
        this.setVisible(false);
    }

    public void initialize(Object o) {
        this.pis.initialize(o);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        int insetsH = this.getInsets().top + this.getInsets().bottom;
        int needSizeW = this.getSize().width;
        int needSizeH = this.getSize().height + insetsH;
        if (needSizeH > this.maxSize) {
            needSizeH = this.maxSize;
        }
        int panelHeight = needSizeH - insetsH;
        int addHOffset = insetsH;
        this.pis.setLocation(0, addHOffset);
        this.pis.defineScrollBar(panelHeight);
        Dimension d = this.pis.getPreferredSize();
        d.height = panelHeight;
        this.pis.setSize(d);
        needSizeW = d.width;
        Dimension dcb = this.cancelButton.getPreferredSize();
        Dimension dab = this.applyButton.getPreferredSize();
        this.setResizable(true);
        this.setSize(needSizeW, needSizeH + dcb.height + 10);
        this.setResizable(false);
        int buttonsWidth = dcb.width + dab.width + 10;
        int cancelX = needSizeW / 2 - buttonsWidth / 2;
        int applyX = cancelX + dcb.width + 10;
        this.applyButton.setLocation(applyX, addHOffset + panelHeight + 5);
        this.cancelButton.setLocation(cancelX, addHOffset + panelHeight + 5);
        this.cancelButton.setSize(dcb);
        this.applyButton.setSize(dab);
        this.doLayout();
        this.pis.repaint();
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Cancel")) {
                PropertyDialog.this.cancelAll();
            } else if (e.getActionCommand().equals("Apply")) {
                PropertyDialog.this.pis.writeNewValues();
                PropertyDialog.this.setVisible(false);
            }
        }
    }
}

