/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.beans;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioGroupPropertyEditor
extends PropertyEditorSupport
implements ActionListener {
    JPanel radioPanel = new JPanel();
    ButtonGroup radioGroup = new ButtonGroup();
    Hashtable radioButtonValues;

    public RadioGroupPropertyEditor() {
        this.radioPanel.setLayout(new GridLayout(1, 5));
        this.radioButtonValues = new Hashtable();
        this.initValues();
    }

    @Override
    public Component getCustomEditor() {
        return this.radioPanel;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        Enumeration values = this.radioButtonValues.keys();
        while (values.hasMoreElements()) {
            Integer val = (Integer)values.nextElement();
            if (!((JRadioButton)this.radioButtonValues.get(val)).isSelected()) continue;
            return val;
        }
        return new Integer(0);
    }

    @Override
    public void setValue(Object value) {
        JRadioButton butt = (JRadioButton)this.radioButtonValues.get(value);
        if (butt != null) {
            butt.setSelected(true);
        }
    }

    protected void initValues() {
        this.addRadio("test", 0);
    }

    public void addRadio(String label, int value) {
        JRadioButton radio = new JRadioButton();
        radio.setText(label);
        radio.addActionListener(this);
        this.radioButtonValues.put(new Integer(value), radio);
        this.radioGroup.add(radio);
        this.radioPanel.add(radio);
        this.radioPanel.validate();
    }
}

