/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.concord.swing.editor.XMEditorKit;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMEditor
extends JTextPane {
    protected AbstractDocument doc;
    protected DocumentBuilderFactory builderFactory;
    protected DocumentBuilder builder;
    protected XMEditorKit editorKit;
    protected JTextArea changeLog;
    protected String newline = "\n";
    protected HashMap actions;
    protected JPanel statusPane;
    protected JMenu editMenu;
    protected JMenu styleMenu;
    protected JPopupMenu popupMenu;
    protected boolean popupMenuEnabled = true;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected UndoManager undo = new UndoManager();
    protected MouseListener popupListener = new MouseAdapter(){
        boolean maybePopup = false;

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybePopup = event.isPopupTrigger();
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if ((this.maybePopup || event.isPopupTrigger()) && XMEditor.this.popupMenuEnabled) {
                XMEditor.this.popupMenu.show(XMEditor.this, event.getX(), event.getY());
            }
        }
    };

    public XMEditor() {
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builderFactory.setValidating(false);
        try {
            this.builder = this.builderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.editorKit = new XMEditorKit();
        this.setEditorKit(this.editorKit);
        this.editorKit.install(this);
        this.setCaretPosition(0);
        this.setMargin(new Insets(5, 5, 5, 5));
        StyledDocument styledDoc = this.getStyledDocument();
        if (styledDoc instanceof AbstractDocument) {
            this.doc = (AbstractDocument)((Object)styledDoc);
        } else {
            System.err.println("Text pane's document isn't an AbstractDocument!");
            System.exit(-1);
        }
        this.statusPane = new JPanel(new GridLayout(1, 1));
        CaretListenerLabel caretListenerLabel = new CaretListenerLabel("Caret Status");
        this.statusPane.add(caretListenerLabel);
        this.createActionTable(this);
        this.editMenu = this.createEditMenu();
        this.styleMenu = this.createStyleMenu();
        this.popupMenu = new JPopupMenu("Editor Menu");
        this.popupMenu.add(this.editMenu);
        this.popupMenu.add(this.styleMenu);
        this.addBindings();
        this.doc.addUndoableEditListener(new MyUndoableEditListener());
        this.addCaretListener(caretListenerLabel);
        this.doc.addDocumentListener(new MyDocumentListener());
        this.addMouseListener(this.popupListener);
    }

    public boolean isPopupMenuEnabled() {
        return this.popupMenuEnabled;
    }

    public void setPopupMenuEnabled(boolean value) {
        this.popupMenuEnabled = value;
    }

    @Override
    public void write(Writer writer) {
        javax.swing.text.Element root = this.doc.getDefaultRootElement();
        org.w3c.dom.Document document = this.builder.newDocument();
        this.writeData(document, document);
        this.writeTree(root, document, document);
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            t.transform(new DOMSource(document), new StreamResult(writer));
        }
        catch (Exception e) {
            System.out.println("write = " + e);
        }
    }

    protected void writeData(org.w3c.dom.Document document, Node parent) {
        try {
            StringWriter writer = new StringWriter();
            super.write(writer);
            String data = writer.toString();
            CDATASection dataNode = document.createCDATASection(data);
            parent.appendChild(dataNode);
        }
        catch (Exception e) {
            System.out.println("writeData = " + e);
        }
    }

    protected void writeTree(javax.swing.text.Element element, org.w3c.dom.Document document, Node parent) {
        Element xmlElement = document.createElement(element.getName());
        parent.appendChild(xmlElement);
        if (parent == document) {
            this.writeData(document, xmlElement);
        }
        Enumeration<?> eNames = ((AttributeSet)((Object)element)).getAttributeNames();
        while (eNames.hasMoreElements()) {
            Object name = eNames.nextElement();
            if (name.toString().equals("resolver")) continue;
            Object value = ((AttributeSet)((Object)element)).getAttribute(name);
            xmlElement.setAttribute(name.toString(), value.toString());
        }
        if (element.isLeaf()) {
            xmlElement.setAttribute("start", "" + element.getStartOffset());
            xmlElement.setAttribute("end", "" + element.getEndOffset());
        } else {
            int i = 0;
            while (i < element.getElementCount()) {
                javax.swing.text.Element childElement = element.getElement(i);
                this.writeTree(childElement, document, xmlElement);
                ++i;
            }
        }
    }

    protected void addBindings() {
        InputMap inputMap = this.getInputMap();
        KeyStroke key = KeyStroke.getKeyStroke(66, 2);
        inputMap.put(key, "caret-backward");
        key = KeyStroke.getKeyStroke(70, 2);
        inputMap.put(key, "caret-forward");
        key = KeyStroke.getKeyStroke(80, 2);
        inputMap.put(key, "caret-up");
        key = KeyStroke.getKeyStroke(78, 2);
        inputMap.put(key, "caret-down");
        key = KeyStroke.getKeyStroke(90, 2);
        inputMap.put(key, this.undoAction);
        key = KeyStroke.getKeyStroke(89, 2);
        inputMap.put(key, this.redoAction);
        key = KeyStroke.getKeyStroke(88, 2);
        inputMap.put(key, "cut-to-clipboard");
        key = KeyStroke.getKeyStroke(67, 2);
        inputMap.put(key, "copy-to-clipboard");
        key = KeyStroke.getKeyStroke(86, 2);
        inputMap.put(key, "paste-from-clipboard");
    }

    protected JMenu createEditMenu() {
        JMenu menu = new JMenu("Edit");
        this.undoAction = new UndoAction();
        menu.add(this.undoAction);
        this.redoAction = new RedoAction();
        menu.add(this.redoAction);
        menu.addSeparator();
        menu.add(this.getActionByName("cut-to-clipboard"));
        menu.add(this.getActionByName("copy-to-clipboard"));
        menu.add(this.getActionByName("paste-from-clipboard"));
        menu.addSeparator();
        menu.add(this.getActionByName("select-all"));
        menu.addSeparator();
        menu.add(new XMEditorKit.InsertImageAction("Insert image..."));
        return menu;
    }

    protected JMenu createStyleMenu() {
        JMenu menu = new JMenu("Style");
        StyledEditorKit.StyledTextAction action = new StyledEditorKit.BoldAction();
        action.putValue("Name", "Bold");
        menu.add(action);
        action = new StyledEditorKit.ItalicAction();
        action.putValue("Name", "Italic");
        menu.add(action);
        action = new StyledEditorKit.UnderlineAction();
        action.putValue("Name", "Underline");
        menu.add(action);
        menu.addSeparator();
        JMenu subMenu = new JMenu("Font Family");
        menu.add(subMenu);
        subMenu.add(new StyledEditorKit.FontFamilyAction("Serif", "Serif"));
        subMenu.add(new StyledEditorKit.FontFamilyAction("SansSerif", "SansSerif"));
        subMenu.add(new StyledEditorKit.FontFamilyAction("Monospaced", "Monospaced"));
        subMenu = new JMenu("Font Size");
        menu.add(subMenu);
        subMenu.add(new StyledEditorKit.FontSizeAction("8", 8));
        subMenu.add(new StyledEditorKit.FontSizeAction("10", 10));
        subMenu.add(new StyledEditorKit.FontSizeAction("12", 12));
        subMenu.add(new StyledEditorKit.FontSizeAction("14", 14));
        subMenu.add(new StyledEditorKit.FontSizeAction("18", 18));
        subMenu.add(new StyledEditorKit.FontSizeAction("20", 20));
        subMenu.add(new StyledEditorKit.FontSizeAction("24", 24));
        subMenu.add(new StyledEditorKit.FontSizeAction("36", 36));
        menu.addSeparator();
        menu.add(new XMEditorKit.TextColorAction("Text Color..."));
        menu.add(new XMEditorKit.TextBackgroundAction("Text Background Color..."));
        menu.add(new XMEditorKit.BackgroundAction("Background Color..."));
        return menu;
    }

    public void initDocument() {
        String[] initString = new String[]{"Use the mouse to place the caret.", "Use the edit menu to cut, copy, paste, and select text.", "Also to undo and redo changes.", "Use the style menu to change the style of the text.", "Use these emacs key bindings to move the caret:", "ctrl-f, ctrl-b, ctrl-n, ctrl-p."};
        SimpleAttributeSet[] attrs = this.initAttributes(initString.length);
        try {
            int i = 0;
            while (i < initString.length) {
                this.doc.insertString(this.doc.getLength(), String.valueOf(initString[i]) + this.newline, attrs[i]);
                ++i;
            }
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text.");
        }
    }

    protected SimpleAttributeSet[] initAttributes(int length) {
        SimpleAttributeSet[] attrs = new SimpleAttributeSet[length];
        attrs[0] = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attrs[0], "SansSerif");
        StyleConstants.setFontSize(attrs[0], 16);
        attrs[1] = new SimpleAttributeSet(attrs[0]);
        StyleConstants.setBold(attrs[1], true);
        attrs[2] = new SimpleAttributeSet(attrs[0]);
        StyleConstants.setItalic(attrs[2], true);
        attrs[3] = new SimpleAttributeSet(attrs[0]);
        StyleConstants.setFontSize(attrs[3], 20);
        attrs[4] = new SimpleAttributeSet(attrs[0]);
        StyleConstants.setFontSize(attrs[4], 12);
        attrs[5] = new SimpleAttributeSet(attrs[0]);
        StyleConstants.setForeground(attrs[5], Color.red);
        return attrs;
    }

    private void createActionTable(JTextComponent textComponent) {
        this.actions = new HashMap();
        Action[] actionsArray = textComponent.getActions();
        int i = 0;
        while (i < actionsArray.length) {
            Action a = actionsArray[i];
            this.actions.put(a.getValue("Name"), a);
            ++i;
        }
    }

    private Action getActionByName(String name) {
        return (Action)this.actions.get(name);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("Extensible Markup Editor");
        XMEditor editor = new XMEditor();
        frame.setDefaultCloseOperation(3);
        JScrollPane scrollPane = new JScrollPane(editor);
        scrollPane.setPreferredSize(new Dimension(200, 200));
        editor.changeLog = new JTextArea(5, 30);
        editor.changeLog.setEditable(false);
        JScrollPane scrollPaneForLog = new JScrollPane(editor.changeLog);
        JSplitPane splitPane = new JSplitPane(0, scrollPane, scrollPaneForLog);
        splitPane.setOneTouchExpandable(true);
        frame.getContentPane().add((Component)splitPane, "Center");
        frame.getContentPane().add((Component)editor.statusPane, "Last");
        editor.initDocument();
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XMEditor.createAndShowGUI();
            }
        });
    }

    protected class CaretListenerLabel
    extends JLabel
    implements CaretListener {
        public CaretListenerLabel(String label) {
            super(label);
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.displaySelectionInfo(e.getDot(), e.getMark());
        }

        protected void displaySelectionInfo(final int dot, final int mark) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (dot == mark) {
                        try {
                            Rectangle caretCoords = XMEditor.this.modelToView(dot);
                            String text = "caret: text position: ";
                            text = String.valueOf(text) + dot + ", view location = [";
                            text = String.valueOf(text) + caretCoords.x + ", ";
                            text = String.valueOf(text) + caretCoords.y + "]";
                            text = String.valueOf(text) + ((CaretListenerLabel)CaretListenerLabel.this).XMEditor.this.newline;
                            CaretListenerLabel.this.setText(text);
                        }
                        catch (BadLocationException ble) {
                            CaretListenerLabel.this.setText("caret: text position: " + dot + ((CaretListenerLabel)CaretListenerLabel.this).XMEditor.this.newline);
                        }
                    } else if (dot < mark) {
                        CaretListenerLabel.this.setText("selection from: " + dot + " to " + mark + ((CaretListenerLabel)CaretListenerLabel.this).XMEditor.this.newline);
                    } else {
                        CaretListenerLabel.this.setText("selection from: " + mark + " to " + dot + ((CaretListenerLabel)CaretListenerLabel.this).XMEditor.this.newline);
                    }
                }
            });
        }
    }

    protected class MyDocumentListener
    implements DocumentListener {
        protected MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.displayEditInfo(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.displayEditInfo(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.displayEditInfo(e);
        }

        private void displayEditInfo(DocumentEvent e) {
            Document document = e.getDocument();
            if (document instanceof Document) {
                int changeLength = e.getLength();
                if (XMEditor.this.changeLog instanceof JTextArea) {
                    String text = String.valueOf(e.getType().toString()) + ": ";
                    text = String.valueOf(text) + " character";
                    text = String.valueOf(text) + (changeLength == 1 ? ". " : "s. ");
                    text = String.valueOf(text) + " Text length = " + document.getLength();
                    text = String.valueOf(text) + "." + XMEditor.this.newline;
                    XMEditor.this.changeLog.append(text);
                }
            }
        }
    }

    protected class MyUndoableEditListener
    implements UndoableEditListener {
        protected MyUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            XMEditor.this.undo.addEdit(e.getEdit());
            XMEditor.this.undoAction.updateUndoState();
            XMEditor.this.redoAction.updateRedoState();
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                XMEditor.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                System.out.println("Unable to redo: " + ex);
                ex.printStackTrace();
            }
            this.updateRedoState();
            XMEditor.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (XMEditor.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", XMEditor.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                XMEditor.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println("Unable to undo: " + ex);
                ex.printStackTrace();
            }
            this.updateUndoState();
            XMEditor.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (XMEditor.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", XMEditor.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }
}

